/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.pms.database.MediaTableFiles;
import net.pms.parsers.MPlayerParser;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.item.DVDISOTitle;
import org.apache.commons.lang3.StringUtils;

public class DVDISOFile
extends StoreContainer {
    private static final String NAME = "[DVD ISO] %s";
    private final File file;
    private final boolean isVideoTS;
    private String volumeId;

    public DVDISOFile(Renderer renderer, File file) {
        super(renderer, DVDISOFile.getName(file), "images/store/optical-disc.png");
        this.file = file;
        this.isVideoTS = file.getName().equalsIgnoreCase("VIDEO_TS");
        this.setLastModified(file.lastModified());
    }

    protected void finalizeDisplayNameVars(Map<String, Object> vars) {
        if (this.isVideoTS) {
            vars.put("isVTS", true);
            File dvdFolder = this.file.getParentFile();
            if (dvdFolder != null) {
                vars.put("vtsDVD", dvdFolder.getName());
            }
        }
    }

    @Override
    public String getFileName() {
        return DVDISOFile.getFileName(this.file);
    }

    @Override
    public String getName() {
        if (StringUtils.isNotBlank(this.volumeId)) {
            if (this.renderer.getUmsConfiguration().isPrettifyFilenames()) {
                return "[DVD] " + this.volumeId;
            }
            return super.getName() + " (" + this.volumeId + ")";
        }
        return super.getName();
    }

    @Override
    public String getSystemName() {
        return this.file == null ? "Unknown" : this.file.getAbsolutePath();
    }

    @Override
    protected void resolveOnce() {
        HashMap<Integer, Double> titles = new HashMap<Integer, Double>();
        this.volumeId = MPlayerParser.parseIsoFile(this.file, titles);
        double oldduration = -1.0;
        for (int i = 1; i < 99; ++i) {
            Double duration = (Double)titles.get(i);
            if (duration == null || !(duration > 10.0) || duration == oldduration && !(oldduration < 3600.0)) continue;
            DVDISOTitle dvd = new DVDISOTitle(this.renderer, this.file, this.volumeId, i);
            this.addChild(dvd);
            oldduration = duration;
        }
        if (this.childrenCount() > 0) {
            MediaTableFiles.getOrInsertFileId(this.file.getAbsolutePath(), this.file.lastModified(), 32);
        }
    }

    private static String getName(File file) {
        return String.format(NAME, DVDISOFile.getFileName(file));
    }

    private static String getFileName(File file) {
        return file.isFile() ? file.getName() : "VIDEO_TS";
    }
}

