/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.item.RealFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class ApertureLibraries
extends LocalizedStoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApertureLibraries.class);

    public ApertureLibraries(Renderer renderer) {
        super(renderer, "ApertureLibrary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApertureLibraries getApertureFolder(Renderer renderer) {
        ApertureLibraries res = null;
        if (Platform.isMac()) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec(new String[]{"defaults", "read", "com.apple.iApps", "ApertureLibraries"});
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    res = new ApertureLibraries(renderer);
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith("(") || line.startsWith(")")) continue;
                        line = line.trim();
                        StoreContainer apertureLibrary = ApertureLibraries.createApertureDlnaLibrary(renderer, line = line.substring(1, line.lastIndexOf(34)));
                        if (apertureLibrary == null) continue;
                        res.addChild(apertureLibrary);
                    }
                }
            }
            catch (IOException | URISyntaxException | XmlParseException e) {
                LOGGER.error("Something went wrong with the aperture library scan: ", e);
            }
            finally {
                if (process != null) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Interrupted while waiting for stream for process");
                        Thread.currentThread().interrupt();
                    }
                    try {
                        process.getErrorStream().close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not close process output stream: {}", (Object)e.getMessage());
                        LOGGER.trace("", e);
                    }
                    try {
                        process.getInputStream().close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not close stream for output process", e);
                    }
                    try {
                        process.getOutputStream().close();
                    }
                    catch (IOException e) {
                        LOGGER.warn("Could not close stream for output process", e);
                    }
                }
            }
        }
        return res;
    }

    private static StoreContainer createApertureDlnaLibrary(Renderer renderer, String url) throws XmlParseException, IOException, URISyntaxException {
        StoreContainer res = null;
        if (url != null) {
            String mediaName;
            URI tURI = new URI(url);
            Map<String, Object> iPhotoLib = Plist.load(URLDecoder.decode(tURI.toURL().getFile(), System.getProperty("file.encoding")));
            Map photoList = (Map)iPhotoLib.get("Master Image List");
            Object mediaPath = iPhotoLib.get("Archive Path");
            mediaName = mediaPath != null ? ((mediaName = mediaPath.toString()) != null && mediaName.lastIndexOf(47) != -1 && mediaName.lastIndexOf(".aplibrary") != -1 ? mediaName.substring(mediaName.lastIndexOf(47), mediaName.lastIndexOf(".aplibrary")) : "unknown library") : "unknown library";
            LOGGER.info("Going to parse aperture library: " + mediaName);
            res = new StoreContainer(renderer, mediaName, null);
            List listOfAlbums = (List)iPhotoLib.get("List of Albums");
            for (Object item : listOfAlbums) {
                Map album = (Map)item;
                if (album.get("Parent") != null) continue;
                StoreContainer vAlbum = ApertureLibraries.createApertureAlbum(renderer, photoList, album, listOfAlbums);
                res.addChild(vAlbum);
            }
        } else {
            LOGGER.info("No Aperture library found.");
        }
        return res;
    }

    private static StoreContainer createApertureAlbum(Renderer renderer, Map<?, ?> photoList, Map<?, ?> album, List<?> listOfAlbums) {
        int albumId = (Integer)album.get("AlbumId");
        StoreContainer vAlbum = new StoreContainer(renderer, album.get("AlbumName").toString(), null);
        for (Object item : listOfAlbums) {
            int parent;
            Map sub = (Map)item;
            if (sub.get("Parent") == null || (parent = ((Integer)sub.get("Parent")).intValue()) != albumId) continue;
            StoreContainer subAlbum = ApertureLibraries.createApertureAlbum(renderer, photoList, sub, listOfAlbums);
            vAlbum.addChild(subAlbum);
        }
        List albumPhotos = (List)album.get("KeyList");
        if (albumPhotos == null) {
            return vAlbum;
        }
        boolean firstPhoto = true;
        for (Object photoKey : albumPhotos) {
            Map photo = (Map)photoList.get(photoKey);
            if (firstPhoto) {
                Object x = photoList.get("ThumbPath");
                if (x != null) {
                    vAlbum.setThumbnail(x.toString());
                }
                firstPhoto = false;
            }
            RealFile file = new RealFile(renderer, new File(photo.get("ImagePath").toString()));
            vAlbum.addChild(file);
        }
        return vAlbum;
    }
}

