/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import com.sun.jna.Platform;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.sharedcontent.ApertureContent;
import net.pms.configuration.sharedcontent.FeedAudioContent;
import net.pms.configuration.sharedcontent.FeedImageContent;
import net.pms.configuration.sharedcontent.FeedVideoContent;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.IPhotoContent;
import net.pms.configuration.sharedcontent.ITunesContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentArray;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.configuration.sharedcontent.SharedContentWithPath;
import net.pms.configuration.sharedcontent.StreamAudioContent;
import net.pms.configuration.sharedcontent.StreamContent;
import net.pms.configuration.sharedcontent.StreamVideoContent;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdLibrary;
import net.pms.store.FileSearch;
import net.pms.store.MediaStoreId;
import net.pms.store.MediaStoreIds;
import net.pms.store.PlaylistManager;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.SystemFileResource;
import net.pms.store.container.ApertureLibraries;
import net.pms.store.container.AudiosFeed;
import net.pms.store.container.CodeEnter;
import net.pms.store.container.CueFolder;
import net.pms.store.container.DVDISOFile;
import net.pms.store.container.DynamicPlaylist;
import net.pms.store.container.FolderLimit;
import net.pms.store.container.IPhotoLibrary;
import net.pms.store.container.ITunesLibrary;
import net.pms.store.container.ImagesFeed;
import net.pms.store.container.MediaLibrary;
import net.pms.store.container.MediaMonitor;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.container.RarredFile;
import net.pms.store.container.RealFolder;
import net.pms.store.container.SearchFolder;
import net.pms.store.container.ServerSettingsFolder;
import net.pms.store.container.SevenZipFile;
import net.pms.store.container.UmsPlaylist;
import net.pms.store.container.UnattachedFolder;
import net.pms.store.container.VideosFeed;
import net.pms.store.container.VirtualFolder;
import net.pms.store.container.ZippedFile;
import net.pms.store.item.RealFile;
import net.pms.store.item.WebAudioStream;
import net.pms.store.item.WebVideoStream;
import net.pms.util.FileUtil;
import net.pms.util.SimpleThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaStore
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaStore.class);
    private static final AtomicInteger WORKERS = new AtomicInteger(0);
    private static final String TEMP_TAG = "$Temp$";
    private final Map<Long, WeakReference<StoreResource>> weakResources = new HashMap<Long, WeakReference<StoreResource>>();
    private final Map<Long, Object> idLocks = new HashMap<Long, Object>();
    private final UnattachedFolder tempFolder;
    private final MediaLibrary mediaLibrary;
    private final DbIdLibrary dbIdLibrary;
    private DynamicPlaylist dynamicPls;
    private FolderLimit lim;
    private MediaMonitor mon;
    private final List<StoreResource> backupChildren = new ArrayList<StoreResource>();

    public MediaStore(Renderer renderer) {
        super(renderer, "root", null);
        this.tempFolder = new UnattachedFolder(renderer, TEMP_TAG);
        this.mediaLibrary = new MediaLibrary(renderer);
        this.dbIdLibrary = new DbIdLibrary(renderer);
        this.setLongId(0L);
    }

    public UnattachedFolder getTemp() {
        return this.tempFolder;
    }

    public UmsPlaylist getDynamicPls() {
        if (this.dynamicPls == null) {
            this.dynamicPls = new DynamicPlaylist(this.renderer, Messages.getString("DynamicPlaylist"), this.renderer.getUmsConfiguration().getDynamicPlsSavePath(), (this.renderer.getUmsConfiguration().isDynamicPlsAutoSave() ? 2 : 0) | 1);
        }
        return this.dynamicPls;
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    public DbIdLibrary getDbIdLibrary() {
        return this.dbIdLibrary;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public synchronized void discoverChildren() {
        List<File> foldersMonitored;
        if (this.isDiscovered()) {
            return;
        }
        LOGGER.debug("Discovering the root folder for " + this.renderer.getRendererName());
        this.backupChildren.clear();
        for (StoreResource storeResource : this.getChildren()) {
            this.backupChildren.add(storeResource);
        }
        this.getChildren().clear();
        if (this.renderer.getUmsConfiguration().isShowMediaLibraryFolder()) {
            if (this.backupChildren.contains(this.mediaLibrary)) {
                this.addChildInternal(this.mediaLibrary, false);
                this.backupChildren.remove(this.mediaLibrary);
            } else {
                this.addChild(this.mediaLibrary);
            }
        }
        this.dbIdLibrary.reset(this.backupChildren);
        if (this.mon != null) {
            this.mon.clearChildren();
        }
        if (!(foldersMonitored = SharedContentConfiguration.getMonitoredFolders()).isEmpty()) {
            File[] dirs = (File[])foldersMonitored.toArray(File[]::new);
            this.mon = new MediaMonitor(this.renderer, dirs);
        }
        if (this.renderer.getUmsConfiguration().getFolderLimit() && this.renderer.isLimitFolders()) {
            this.lim = new FolderLimit(this.renderer);
            this.addChild(this.lim);
        }
        if (this.renderer.getUmsConfiguration().isDynamicPls()) {
            if (this.dynamicPls != null && this.backupChildren.contains(this.dynamicPls)) {
                this.addChildInternal(this.dynamicPls, false);
                this.backupChildren.remove(this.dynamicPls);
            } else {
                this.addChild(this.getDynamicPls());
            }
            if (!this.renderer.getUmsConfiguration().isHideSavedPlaylistFolder()) {
                File plsdir = new File(this.renderer.getUmsConfiguration().getDynamicPlsSavePath());
                StoreResource plsResource = this.findResourceFromFile(this.backupChildren, plsdir);
                if (plsResource != null) {
                    this.addChildInternal(plsResource, false);
                    this.backupChildren.remove(plsResource);
                } else {
                    this.addChild(new RealFolder(this.renderer, plsdir, Messages.getString("SavedPlaylists")));
                }
            }
        }
        this.setSharedContents();
        if (this.renderer.getUmsConfiguration().isShowServerSettingsFolder()) {
            StoreContainer serverSettingsFolder = this.findSystemNameInResources(this.backupChildren, "ServerSettings");
            if (serverSettingsFolder != null) {
                this.addChildInternal(serverSettingsFolder, false);
                this.backupChildren.remove(serverSettingsFolder);
            } else {
                serverSettingsFolder = ServerSettingsFolder.getServerSettingsFolder(this.renderer);
                if (serverSettingsFolder != null) {
                    this.addChild(serverSettingsFolder);
                }
            }
        }
        this.clearBackupChildren();
        this.setDiscovered(true);
    }

    private StoreContainer findSystemNameInResources(List<StoreResource> resources, String systemName) {
        if (systemName == null) {
            return null;
        }
        for (StoreResource resource : resources) {
            StoreContainer container;
            if (!(resource instanceof StoreContainer) || !systemName.equals((container = (StoreContainer)resource).getSystemName())) continue;
            return container;
        }
        return null;
    }

    public void setFolderLim(StoreResource r) {
        if (this.lim != null) {
            this.lim.setStart(r);
        }
    }

    private void setSharedContents() {
        ArrayList<StoreResource> realSystemFileResources = new ArrayList<StoreResource>();
        SharedContentArray sharedContents = SharedContentConfiguration.getSharedContentArray();
        boolean useExternalContent = CONFIGURATION.getExternalNetwork() && this.renderer.getUmsConfiguration().getExternalNetwork();
        for (SharedContent sharedContent : sharedContents) {
            SharedContentWithPath sharedContentWithPath;
            if (!sharedContent.isActive() || !sharedContent.isGroupAllowed(this.renderer.getAccountGroupId())) continue;
            if (sharedContent instanceof ITunesContent) {
                ITunesContent iTunesContent = (ITunesContent)sharedContent;
                this.setITunesContent(iTunesContent);
                continue;
            }
            if (sharedContent instanceof ApertureContent) {
                this.setApertureContent();
                continue;
            }
            if (sharedContent instanceof IPhotoContent) {
                this.setIPhotoContent();
                continue;
            }
            if (sharedContent instanceof FolderContent) {
                StoreResource realSystemFileResource;
                FolderContent folder = (FolderContent)sharedContent;
                if (folder.getFile() == null || !((realSystemFileResource = this.setFolderContent(folder)) instanceof RealFolder) && !(realSystemFileResource instanceof RealFile)) continue;
                realSystemFileResources.add(realSystemFileResource);
                continue;
            }
            if (sharedContent instanceof VirtualFolderContent) {
                VirtualFolderContent virtualFolder = (VirtualFolderContent)sharedContent;
                this.setVirtualFolderContent(virtualFolder);
                continue;
            }
            if (!useExternalContent || !(sharedContent instanceof SharedContentWithPath) || !(sharedContentWithPath = (SharedContentWithPath)sharedContent).isExternalContent()) continue;
            this.setExternalContent(sharedContentWithPath);
        }
        if (this.renderer.getUmsConfiguration().getSearchFolder()) {
            SearchFolder sf = new SearchFolder(this.renderer, "SearchDiscFolders", new FileSearch(realSystemFileResources));
            this.addChild(sf);
        }
    }

    private StoreResource setFolderContent(FolderContent folderContent) {
        if (folderContent.getFile() != null) {
            StoreResource realSystemFileResource = this.findResourceFromFile(this.backupChildren, folderContent.getFile());
            if (realSystemFileResource != null) {
                this.addChildInternal(realSystemFileResource, false);
                this.backupChildren.remove(realSystemFileResource);
            } else {
                realSystemFileResource = this.createResourceFromFile(folderContent.getFile(), true);
                if (realSystemFileResource != null) {
                    this.addChild(realSystemFileResource, true, true);
                } else {
                    LOGGER.trace("createResourceFromFile has failed for {}", (Object)folderContent.getFile());
                }
            }
            return realSystemFileResource;
        }
        return null;
    }

    private void setVirtualFolderContent(VirtualFolderContent virtualFolderContent) {
        StoreContainer parent = this.getSharedContentParent(virtualFolderContent.getParent());
        parent.addChild(new VirtualFolder(this.renderer, virtualFolderContent));
    }

    private void setITunesContent(ITunesContent iTunesContent) {
        int osType = Platform.getOSType();
        if (osType == 0 || osType == 2) {
            StoreContainer iTunesRes = this.findSystemNameInResources(this.backupChildren, "ItunesLibrary");
            if (iTunesRes != null) {
                this.addChildInternal(iTunesRes, false);
                this.backupChildren.remove(iTunesRes);
            } else {
                iTunesRes = ITunesLibrary.getiTunesFolder(this.renderer, iTunesContent.getPath());
                if (iTunesRes != null) {
                    this.addChild(iTunesRes);
                }
            }
        }
    }

    private void setApertureContent() {
        int osType = Platform.getOSType();
        if (osType == 0) {
            StoreContainer apertureRes = this.findSystemNameInResources(this.backupChildren, "ApertureLibrary");
            if (apertureRes != null) {
                this.addChildInternal(apertureRes, false);
                this.backupChildren.remove(apertureRes);
            } else {
                apertureRes = ApertureLibraries.getApertureFolder(this.renderer);
                if (apertureRes != null) {
                    this.addChild(apertureRes);
                }
            }
        }
    }

    private void setIPhotoContent() {
        int osType = Platform.getOSType();
        if (osType == 0) {
            StoreContainer iPhotoRes = this.findSystemNameInResources(this.backupChildren, "IphotoLibrary");
            if (iPhotoRes != null) {
                this.addChildInternal(iPhotoRes, false);
                this.backupChildren.remove(iPhotoRes);
            } else {
                iPhotoRes = IPhotoLibrary.getiPhotoFolder(this.renderer);
                if (iPhotoRes != null) {
                    this.addChild(iPhotoRes);
                }
            }
        }
    }

    private void setExternalContent(SharedContentWithPath sharedContent) {
        StreamContent streamContent;
        StoreContainer playlist;
        StoreContainer parent = this.getSharedContentParent(sharedContent.getParent());
        if (sharedContent instanceof StreamContent && (playlist = PlaylistManager.getPlaylist(this.renderer, (streamContent = (StreamContent)sharedContent).getName(), streamContent.getUri(), streamContent.getFormat())) != null) {
            parent.addChild(playlist);
            return;
        }
        if (sharedContent instanceof FeedAudioContent) {
            FeedAudioContent feedAudioContent = (FeedAudioContent)sharedContent;
            parent.addChild(new AudiosFeed(this.renderer, feedAudioContent.getUri()));
        } else if (sharedContent instanceof FeedImageContent) {
            FeedImageContent feedImageContent = (FeedImageContent)sharedContent;
            parent.addChild(new ImagesFeed(this.renderer, feedImageContent.getUri()));
        } else if (sharedContent instanceof FeedVideoContent) {
            FeedVideoContent feedVideoContent = (FeedVideoContent)sharedContent;
            parent.addChild(new VideosFeed(this.renderer, feedVideoContent.getUri()));
        } else if (sharedContent instanceof StreamAudioContent) {
            StreamAudioContent streamAudioContent = (StreamAudioContent)sharedContent;
            parent.addChild(new WebAudioStream(this.renderer, streamAudioContent.getName(), streamAudioContent.getUri(), streamAudioContent.getThumbnail()));
        } else if (sharedContent instanceof StreamVideoContent) {
            StreamVideoContent streamVideoContent = (StreamVideoContent)sharedContent;
            parent.addChild(new WebVideoStream(this.renderer, streamVideoContent.getName(), streamVideoContent.getUri(), streamVideoContent.getThumbnail()));
        }
        this.setLastModified(1L);
    }

    private void clearBackupChildren() {
        Iterator<StoreResource> backupResources = this.backupChildren.iterator();
        while (backupResources.hasNext()) {
            StoreResource resource = backupResources.next();
            if (resource instanceof StoreContainer) {
                StoreContainer container = (StoreContainer)resource;
                container.clearChildren();
            }
            backupResources.remove();
            this.deleteWeakResource(resource);
        }
        this.backupChildren.clear();
    }

    public void reset() {
        if (this.isDiscovered()) {
            this.setDiscovered(false);
            this.discoverChildren();
        }
    }

    public void stopPlaying(StoreResource res) {
        if (this.mon != null) {
            this.mon.stopped(res);
        }
    }

    public StoreResource getValidResource(String uri, String name) {
        LOGGER.debug("Validating URI \"{}\"", (Object)uri);
        String objectId = MediaStore.parseObjectId(uri);
        if (objectId != null) {
            if (objectId.startsWith(TEMP_TAG)) {
                int index = this.tempFolder.indexOf(objectId);
                return index > -1 ? this.tempFolder.getChildren().get(index) : this.tempFolder.recreate(objectId, name);
            }
            return this.getResource(objectId);
        }
        return this.tempFolder.add(uri, name);
    }

    /*
     * Exception decompiling
     */
    public StoreResource getResource(String objectId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getIdLock(Long id) {
        Map<Long, Object> map = this.idLocks;
        synchronized (map) {
            if (this.idLocks.containsKey(id)) {
                return this.idLocks.get(id);
            }
            Object idLock = new Object();
            this.idLocks.put(id, idLock);
            return idLock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreResource getWeakResource(String objectId) {
        Object idLock;
        Long id = MediaStore.parseIndex(objectId);
        if (id == null) {
            return null;
        }
        Object object = idLock = this.getIdLock(id);
        synchronized (object) {
            StoreResource res = this.getWeakResource(id);
            if (res != null) {
                return res;
            }
            return this.recreateResource(id);
        }
    }

    private StoreResource recreateResource(long id) {
        LOGGER.trace("try recreating resource with id '{}'", (Object)id);
        List<MediaStoreId> libraryIds = MediaStoreIds.getMediaStoreResourceTree(id);
        if (!libraryIds.isEmpty()) {
            for (MediaStoreId libraryId : libraryIds) {
                StoreResource parent = this.getWeakResource(libraryId.getId());
                if (!(parent instanceof StoreContainer)) continue;
                StoreContainer container = (StoreContainer)parent;
                container.discoverChildren();
            }
            StoreResource resource = this.getWeakResource(id);
            if (resource != null) {
                LOGGER.trace("resource with id '{}' recreacted succefully", (Object)id);
                return resource;
            }
            LOGGER.trace("resource with id '{}' is no longer available in the store tree", (Object)id);
        } else {
            LOGGER.trace("resource with id '{}' was not found in database", (Object)id);
        }
        return null;
    }

    public boolean weakResourceExists(String objectId) {
        Long id = MediaStore.parseIndex(objectId);
        return this.getWeakResource(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StoreResource getWeakResource(Long id) {
        Map<Long, WeakReference<StoreResource>> map = this.weakResources;
        synchronized (map) {
            if (id != null && this.weakResources.containsKey(id) && this.weakResources.get(id).get() != null) {
                return (StoreResource)this.weakResources.get(id).get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWeakResource(Long id, StoreResource resource) {
        if (id != null) {
            Map<Long, WeakReference<StoreResource>> map = this.weakResources;
            synchronized (map) {
                this.weakResources.put(id, new WeakReference<StoreResource>(resource));
            }
            return true;
        }
        return false;
    }

    public boolean addWeakResource(StoreResource resource) {
        Long id = MediaStoreIds.getMediaStoreResourceId(resource);
        return this.addWeakResource(id, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceWeakResource(StoreResource a, StoreResource b) {
        Long id = MediaStore.parseIndex(a.getId());
        Map<Long, WeakReference<StoreResource>> map = this.weakResources;
        synchronized (map) {
            if (id != null && this.weakResources.containsKey(id)) {
                this.weakResources.get(id).clear();
                this.weakResources.put(id, new WeakReference<StoreResource>(b));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWeakResource(StoreResource resource) {
        Long id = MediaStore.parseIndex(resource.getId());
        Map<Long, WeakReference<StoreResource>> map = this.weakResources;
        synchronized (map) {
            if (id != null && this.weakResources.containsKey(id)) {
                this.weakResources.get(id).clear();
                this.weakResources.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWeakResources() {
        Map<Long, WeakReference<StoreResource>> map = this.weakResources;
        synchronized (map) {
            this.weakResources.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreResource> findSystemFileResources(File file) {
        ArrayList<StoreResource> systemFileResources = new ArrayList<StoreResource>();
        Map<Long, WeakReference<StoreResource>> map = this.weakResources;
        synchronized (map) {
            for (WeakReference<StoreResource> resource : this.weakResources.values()) {
                SystemFileResource systemFileResource;
                Object t = resource.get();
                if (!(t instanceof SystemFileResource) || !file.equals((systemFileResource = (SystemFileResource)t).getSystemFile()) || !(systemFileResource instanceof StoreResource)) continue;
                StoreResource storeResource = (StoreResource)((Object)systemFileResource);
                systemFileResources.add(storeResource);
            }
        }
        return systemFileResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreResource> getResources(String objectId, boolean returnChildren) {
        try {
            Object ids;
            WORKERS.incrementAndGet();
            ArrayList<StoreResource> resources = new ArrayList<StoreResource>();
            if (StringUtils.isEmpty(objectId)) {
                ArrayList<StoreResource> arrayList = resources;
                return arrayList;
            }
            if (objectId.startsWith(TEMP_TAG)) {
                List<StoreResource> items = this.getTemp().asList(objectId);
                List<StoreResource> list = items != null ? items : resources;
                return list;
            }
            StoreResource resource = this.getResource(objectId);
            if (resource == null) {
                objectId = StringUtils.substringBefore(objectId, "/");
                ids = objectId.split("\\.");
                resource = this.search((String[])ids);
            }
            if (resource != null) {
                if (!(resource instanceof CodeEnter) && !this.isCodeValid(resource)) {
                    LOGGER.debug("code is not valid any longer");
                    ids = resources;
                    return ids;
                }
                if (!this.isRendererAllowed()) {
                    LOGGER.debug("renderer does not have access to this ressource");
                    ids = resources;
                    return ids;
                }
                if (!returnChildren) {
                    resources.add(resource);
                    if (resource instanceof StoreContainer) {
                        storeContainer = (StoreContainer)resource;
                        if (!storeContainer.isDiscovered()) {
                            storeContainer.discover(false);
                        } else {
                            storeContainer.refreshChildrenIfNeeded();
                        }
                    }
                } else if (resource instanceof StoreContainer) {
                    storeContainer = (StoreContainer)resource;
                    storeContainer.discover(true);
                    int count = storeContainer.getChildren().size();
                    if (count > 0) {
                        String systemName = storeContainer.getSystemName();
                        LOGGER.trace("Start of analysis for " + systemName);
                        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(count);
                        int nParallelThreads = 3;
                        if (storeContainer instanceof DVDISOFile) {
                            nParallelThreads = 1;
                        }
                        ThreadPoolExecutor tpe = new ThreadPoolExecutor(Math.min(count, nParallelThreads), count, 20L, TimeUnit.SECONDS, queue, new SimpleThreadFactory("LibraryResource resolver thread", true));
                        if (MediaStore.shouldDoAudioTrackSorting(storeContainer)) {
                            MediaStore.sortChildrenWithAudioElements(storeContainer);
                        }
                        for (int i = 0; i < storeContainer.getChildren().size(); ++i) {
                            StoreResource child = storeContainer.getChildren().get(i);
                            if (child != null) {
                                tpe.execute(child);
                                resources.add(child);
                                continue;
                            }
                            LOGGER.warn("null child at index {} in {}", (Object)i, (Object)systemName);
                        }
                        try {
                            tpe.shutdown();
                            tpe.awaitTermination(20L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("error while shutting down thread pool executor for " + systemName, e);
                            Thread.currentThread().interrupt();
                        }
                        LOGGER.trace("End of analysis for " + systemName);
                    }
                }
            }
            ArrayList<StoreResource> arrayList = resources;
            return arrayList;
        }
        finally {
            WORKERS.decrementAndGet();
        }
    }

    private StoreResource search(String[] searchIds) {
        for (String searchId : searchIds) {
            StoreResource resource = searchId.equals("0") ? this : this.getWeakResource(searchId);
            if (resource == null) {
                LOGGER.debug("Bad id {} found in path", (Object)searchId);
                return null;
            }
            if (!(resource instanceof StoreContainer)) continue;
            StoreContainer storeContainer = resource;
            storeContainer.discover(false);
        }
        return this.getWeakResource(searchIds[searchIds.length - 1]);
    }

    public void fileRemoved(File file) {
        for (StoreResource storeResource : this.findSystemFileResources(file)) {
            storeResource.getParent().removeChild(storeResource);
            storeResource.getParent().notifyRefresh();
        }
    }

    public void fileAdded(File file) {
        File parentFile = file.getParentFile();
        for (StoreResource storeResource : this.findSystemFileResources(parentFile)) {
            if (!(storeResource instanceof VirtualFolder)) continue;
            VirtualFolder virtualFolder = (VirtualFolder)storeResource;
            virtualFolder.doRefreshChildren();
        }
    }

    private StoreResource findResourceFromFile(List<StoreResource> resources, File file) {
        if (file == null || file.isHidden() || !file.canRead() || !file.isFile() && !file.isDirectory()) {
            return null;
        }
        if (file.isDirectory()) {
            if (file.getName().toUpperCase(Locale.ROOT).equals("VIDEO_TS")) {
                return this.findResourceFromFile(resources, file, DVDISOFile.class);
            }
            return this.findResourceFromFile(resources, file, RealFolder.class);
        }
        String lcFilename = file.getName().toLowerCase();
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".zip") || lcFilename.endsWith(".cbz"))) {
            return this.findResourceFromFile(resources, file, ZippedFile.class);
        }
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".rar") || lcFilename.endsWith(".cbr"))) {
            return this.findResourceFromFile(resources, file, RarredFile.class);
        }
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".tar") || lcFilename.endsWith(".gzip") || lcFilename.endsWith(".gz") || lcFilename.endsWith(".7z"))) {
            return this.findResourceFromFile(resources, file, SevenZipFile.class);
        }
        if (lcFilename.endsWith(".iso") || lcFilename.endsWith(".img")) {
            return this.findResourceFromFile(resources, file, DVDISOFile.class);
        }
        if (lcFilename.endsWith(".m3u") || lcFilename.endsWith(".m3u8") || lcFilename.endsWith(".pls")) {
            return this.findResourceFromFile(resources, file, PlaylistFolder.class);
        }
        if (lcFilename.endsWith(".cue")) {
            return this.findResourceFromFile(resources, file, CueFolder.class);
        }
        if (lcFilename.endsWith(".ups")) {
            return this.findResourceFromFile(resources, file, UmsPlaylist.class);
        }
        return this.findResourceFromFile(resources, file, RealFile.class);
    }

    private StoreResource findResourceFromFile(List<StoreResource> resources, File file, Class<?> resourceClass) {
        if (file == null || file.isHidden() || !file.canRead() || !file.isFile() && !file.isDirectory()) {
            return null;
        }
        for (StoreResource resource : resources) {
            SystemFileResource systemFileResource;
            if (!resourceClass.isInstance(resource) || !(resource instanceof SystemFileResource) || !file.equals((systemFileResource = (SystemFileResource)((Object)resource)).getSystemFile())) continue;
            return resource;
        }
        return null;
    }

    public StoreResource createResourceFromFile(File file) {
        return this.createResourceFromFile(file, false);
    }

    public StoreResource createResourceFromFile(File file, boolean allowHidden) {
        if (file == null) {
            LOGGER.trace("createResourceFromFile return null as file is null.");
            return null;
        }
        if (!allowHidden && file.isHidden()) {
            LOGGER.trace("createResourceFromFile return null as {} is hidden.", (Object)file.toString());
            return null;
        }
        if (!file.canRead()) {
            LOGGER.trace("createResourceFromFile return null as {} is unreadable.", (Object)file.toString());
            return null;
        }
        if (!file.isFile() && !file.isDirectory()) {
            LOGGER.trace("createResourceFromFile return null as {} is neither a file or a directory.", (Object)file.toString());
            return null;
        }
        String lcFilename = file.getName();
        lcFilename = lcFilename == null ? "" : lcFilename.toLowerCase();
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".zip") || lcFilename.endsWith(".cbz"))) {
            return new ZippedFile(this.renderer, file);
        }
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".rar") || lcFilename.endsWith(".cbr"))) {
            return new RarredFile(this.renderer, file);
        }
        if (this.renderer.getUmsConfiguration().isArchiveBrowsing() && (lcFilename.endsWith(".tar") || lcFilename.endsWith(".gzip") || lcFilename.endsWith(".gz") || lcFilename.endsWith(".7z"))) {
            return new SevenZipFile(this.renderer, file);
        }
        if (lcFilename.endsWith(".iso") || lcFilename.endsWith(".img") || file.isDirectory() && lcFilename.toUpperCase(Locale.ROOT).equals("VIDEO_TS")) {
            return new DVDISOFile(this.renderer, file);
        }
        if (lcFilename.endsWith(".m3u") || lcFilename.endsWith(".m3u8") || lcFilename.endsWith(".pls") || lcFilename.endsWith(".cue") || lcFilename.endsWith(".ups")) {
            StoreContainer d = PlaylistManager.getPlaylist(this.renderer, file.getName(), file.getAbsolutePath(), 0);
            if (d == null) {
                LOGGER.trace("createResourceFromFile return null as {} is PlaylistFolder fail.", (Object)file.toString());
            }
            return d;
        }
        List<String> ignoredFolderNames = this.renderer.getUmsConfiguration().getIgnoredFolderNames();
        if (file.isDirectory() && this.renderer.getUmsConfiguration().isHideEmptyFolders() && !FileUtil.isFolderRelevant(file, this.renderer.getUmsConfiguration())) {
            LOGGER.debug("Ignoring empty/non-relevant directory: " + file.toString());
            return null;
        }
        if (file.isDirectory() && !"".equals(lcFilename) && !ignoredFolderNames.isEmpty() && ignoredFolderNames.contains(file.getName())) {
            LOGGER.debug("Ignoring {} because it is in the ignored folders list", (Object)file.toString());
            return null;
        }
        if (file.isDirectory()) {
            return new RealFolder(this.renderer, file);
        }
        RealFile rf = new RealFile(this.renderer, file);
        if (rf.length() == 0L) {
            LOGGER.debug("Ignoring {} because it seems corrupted when the length of the file is 0", (Object)file.toString());
            return null;
        }
        return rf;
    }

    @Override
    public String toString() {
        return "MediaStore[" + String.valueOf(this.getChildren()) + "]";
    }

    private static Long parseIndex(String id) {
        try {
            String longId = StringUtils.substringBefore(id, "$");
            longId = StringUtils.substringBefore(longId, "#");
            return Long.valueOf(longId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean shouldDoAudioTrackSorting(StoreContainer resource) {
        if (!PMS.getConfiguration().isSortAudioTracksByAlbumPosition()) {
            LOGGER.trace("shouldDoAudioTrackSorting : {}", (Object)PMS.getConfiguration().isSortAudioTracksByAlbumPosition());
            return false;
        }
        String album = null;
        String mbReleaseId = null;
        int numberOfAudioFiles = 0;
        int numberOfOtherFiles = 0;
        boolean audioExists = false;
        for (StoreResource res : resource.getChildren()) {
            StoreItem item;
            if (res instanceof StoreItem && (item = (StoreItem)res).getFormat() != null && item.getFormat().isAudio()) {
                if (res.getMediaInfo() == null || !res.getMediaInfo().hasAudioMetadata()) {
                    LOGGER.warn("Audio resource has no AudioMetadata : {}", (Object)res.getDisplayName());
                    continue;
                }
                MediaAudioMetadata metadata = res.getMediaInfo().getAudioMetadata();
                ++numberOfAudioFiles;
                if (album == null) {
                    audioExists = true;
                    album = metadata.getAlbum() != null ? metadata.getAlbum() : "";
                    mbReleaseId = metadata.getMbidRecord();
                    if (!StringUtils.isAllBlank(album) || !StringUtils.isAllBlank(mbReleaseId)) continue;
                    return false;
                }
                if (!(mbReleaseId != null && !StringUtils.isAllBlank(mbReleaseId) ? !mbReleaseId.equals(metadata.getMbidRecord()) : !album.equals(metadata.getAlbum()))) continue;
                return false;
            }
            ++numberOfOtherFiles;
        }
        return audioExists && numberOfAudioFiles > numberOfOtherFiles;
    }

    private static void sortChildrenWithAudioElements(StoreContainer resource) {
        Collections.sort(resource.getChildren(), (o1, o2) -> {
            if (MediaStore.getDiscNum(o1) == null || MediaStore.getDiscNum(o2) == null || MediaStore.getDiscNum(o1).equals(MediaStore.getDiscNum(o2))) {
                StoreItem item1;
                if (o1 instanceof StoreItem && (item1 = (StoreItem)o1).getFormat() != null && item1.getFormat().isAudio()) {
                    StoreItem item2;
                    if (o2 instanceof StoreItem && (item2 = (StoreItem)o2).getFormat() != null && item2.getFormat().isAudio()) {
                        return MediaStore.getTrackNum(o1).compareTo(MediaStore.getTrackNum(o2));
                    }
                    return o1.getDisplayNameBase().compareTo(o2.getDisplayNameBase());
                }
                return o1.getDisplayNameBase().compareTo(o2.getDisplayNameBase());
            }
            return MediaStore.getDiscNum(o1).compareTo(MediaStore.getDiscNum(o2));
        });
    }

    private static Integer getTrackNum(StoreResource res) {
        if (res != null && res.getMediaInfo() != null && res.getMediaInfo().hasAudioMetadata()) {
            return res.getMediaInfo().getAudioMetadata().getTrack();
        }
        return 0;
    }

    private static Integer getDiscNum(StoreResource res) {
        if (res != null && res.getMediaInfo() != null && res.getMediaInfo().hasAudioMetadata()) {
            return res.getMediaInfo().getAudioMetadata().getDisc();
        }
        return 0;
    }

    public static void waitWorkers() throws InterruptedException {
        while (WORKERS.get() > 0) {
            Thread.sleep(100L);
        }
    }
}

