/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.pms.Messages;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableFilesStatus;
import net.pms.gui.GuiManager;
import net.pms.media.MediaStatus;
import net.pms.store.MediaStoreIds;

public class MediaStatusStore {
    private static final Map<Integer, Map<String, MediaStatus>> STORE = new HashMap<Integer, Map<String, MediaStatus>>();

    private MediaStatusStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaStatus getMediaStatus(int userId, String filename) {
        Map<Integer, Map<String, MediaStatus>> map = STORE;
        synchronized (map) {
            if (STORE.containsKey(userId) && STORE.get(userId) != null && STORE.get(userId).containsKey(filename)) {
                return STORE.get(userId).get(filename);
            }
            MediaStatus mediaStatus = null;
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    mediaStatus = MediaTableFilesStatus.getMediaStatus(connection, filename, userId);
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
            if (mediaStatus == null) {
                mediaStatus = new MediaStatus();
            }
            if (!STORE.containsKey(userId)) {
                STORE.put(userId, new HashMap());
            }
            STORE.get(userId).put(filename, mediaStatus);
            return mediaStatus;
        }
    }

    public static boolean isFullyPlayed(String filename, int userId) {
        MediaStatus mediaStatus = MediaStatusStore.getMediaStatus(userId, filename);
        return mediaStatus.isFullyPlayed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFullyPlayed(String filename, int userId, boolean isFullyPlayed, Double lastPlaybackPosition) {
        MediaStatus mediaStatus = MediaStatusStore.getMediaStatus(userId, filename);
        mediaStatus.setFullyPlayed(isFullyPlayed);
        if (lastPlaybackPosition != null) {
            mediaStatus.setLastPlaybackPosition(lastPlaybackPosition);
            mediaStatus.setPlaybackCount(mediaStatus.getPlaybackCount() + 1);
        }
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFilesStatus.setFullyPlayed(connection, filename, userId, isFullyPlayed);
                if (lastPlaybackPosition != null) {
                    MediaTableFilesStatus.setLastPlayed(connection, filename, userId, lastPlaybackPosition);
                }
            }
            MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLastPlayed(String filename, int userId, Double lastPlaybackPosition) {
        if (lastPlaybackPosition != null) {
            MediaStatus mediaStatus = MediaStatusStore.getMediaStatus(userId, filename);
            mediaStatus.setLastPlaybackPosition(lastPlaybackPosition);
            mediaStatus.setPlaybackCount(mediaStatus.getPlaybackCount() + 1);
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaTableFilesStatus.setLastPlayed(connection, filename, userId, lastPlaybackPosition);
                }
                MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBookmark(String filename, int userId, int bookmark) {
        MediaStatus mediaStatus = MediaStatusStore.getMediaStatus(userId, filename);
        mediaStatus.setBookmark(bookmark);
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                MediaTableFilesStatus.setBookmark(connection, filename, userId, bookmark);
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDirectoryFullyPlayed(Connection connection, String fullPathToFolder, int userId, boolean isFullyPlayed) {
        String statusLineString = isFullyPlayed ? Messages.getString("MarkContentsFullyPlayed") : Messages.getString("MarkContentsUnplayed");
        GuiManager.setStatusLine(statusLineString + ": " + fullPathToFolder);
        try {
            for (String fullPathToFile : MediaTableFiles.getFilenamesInFolder(connection, fullPathToFolder)) {
                MediaStatusStore.setFullyPlayed(fullPathToFile, userId, isFullyPlayed, null);
            }
        }
        finally {
            GuiManager.setStatusLine(null);
        }
        MediaStoreIds.incrementSystemUpdateId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaEntriesInFolder(String pathToFolder) {
        boolean removed = false;
        Map<Integer, Map<String, MediaStatus>> map = STORE;
        synchronized (map) {
            for (int userId : STORE.keySet()) {
                if (STORE.get(userId) == null) continue;
                Iterator<String> filenames = STORE.get(userId).keySet().iterator();
                while (filenames.hasNext()) {
                    if (!filenames.next().startsWith(pathToFolder)) continue;
                    filenames.remove();
                    removed = true;
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeMediaEntry(String filename) {
        boolean removed = false;
        Map<Integer, Map<String, MediaStatus>> map = STORE;
        synchronized (map) {
            for (int userId : STORE.keySet()) {
                if (STORE.get(userId) == null || STORE.get(userId).remove(filename) == null) continue;
                removed = true;
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(int userId) {
        Map<Integer, Map<String, MediaStatus>> map = STORE;
        synchronized (map) {
            if (STORE.containsKey(userId) && STORE.get(userId) != null) {
                STORE.get(userId).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<Integer, Map<String, MediaStatus>> map = STORE;
        synchronized (map) {
            STORE.clear();
        }
    }
}

