/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.sleep;

import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSleepWorker
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSleepWorker.class);
    protected boolean preventSleep;
    protected boolean sleepPrevented;
    protected boolean resetSleepTimer;
    protected long lastChange = 0L;
    protected long allowSleepTimer = 0L;
    protected PreventSleepMode mode;
    private final SleepManager owner;

    protected int getDelayUntilAllowSleep() {
        return 0;
    }

    protected AbstractSleepWorker(String threadName, PreventSleepMode mode, SleepManager owner) {
        super(StringUtils.isBlank(threadName) ? "SleepWorker" : threadName);
        this.mode = mode;
        this.owner = owner;
    }

    public synchronized void allowSleep() {
        this.preventSleep = false;
        this.lastChange = System.currentTimeMillis();
        this.notifyAll();
    }

    public synchronized void preventSleep() {
        this.preventSleep = true;
        this.lastChange = System.currentTimeMillis();
        this.notifyAll();
    }

    public synchronized void resetSleepTimer() {
        this.resetSleepTimer = true;
        this.lastChange = System.currentTimeMillis();
        this.notifyAll();
    }

    public synchronized void setMode(PreventSleepMode mode) {
        this.mode = mode;
    }

    @Override
    public synchronized void run() {
        try {
            while (true) {
                if (this.sleepPrevented && this.lastChange + 5000L > System.currentTimeMillis()) {
                    this.wait(Math.max(System.currentTimeMillis() - this.lastChange + 5001L, 0L));
                    continue;
                }
                if (this.preventSleep != this.sleepPrevented) {
                    if (this.preventSleep) {
                        this.doPreventSleep();
                        continue;
                    }
                    if (this.getDelayUntilAllowSleep() > 0) {
                        if (this.allowSleepTimer > 0L) {
                            if (System.currentTimeMillis() < this.allowSleepTimer) {
                                this.wait(5000L);
                                continue;
                            }
                            this.allowSleepTimer = 0L;
                        } else {
                            this.allowSleepTimer = System.currentTimeMillis() + (long)this.getDelayUntilAllowSleep();
                            continue;
                        }
                    }
                    this.doAllowSleep();
                    continue;
                }
                if (this.resetSleepTimer) {
                    if (!this.sleepPrevented) {
                        this.doResetSleepTimer();
                        continue;
                    }
                    this.resetSleepTimer = false;
                    continue;
                }
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOGGER.debug("Shutting down sleep worker");
            this.doAllowSleep();
            this.owner.clearWorker();
        }
        catch (Throwable e) {
            LOGGER.error("Unexpected error in SleepManager worker thread, shutting down worker: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    protected abstract void doAllowSleep();

    protected abstract void doPreventSleep();

    protected abstract void doResetSleepTimer();
}

