/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.util.Map;
import net.pms.network.StartStopListener;
import net.pms.renderers.devices.WebGuiRenderer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebGuiPlayer
extends LogicalPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebGuiPlayer.class);
    private StoreItem playingRes;

    public WebGuiPlayer(WebGuiRenderer renderer) {
        super(renderer);
        LOGGER.debug("Created web gui player for " + renderer.getRendererName());
    }

    @Override
    public void setURI(String uri, String metadata) {
        StoreResource r;
        PlaylistItem item = this.resolveURI(uri, metadata);
        if (item != null && (r = this.renderer.getMediaStore().getValidResource(item.getUri(), item.getName())) != null) {
            ((WebGuiRenderer)this.renderer).sendMessage("setPlayId", r.getId());
            return;
        }
        LOGGER.debug("Bad uri " + uri);
    }

    @Override
    public void pause() {
        ((WebGuiRenderer)this.renderer).sendMessage("pause");
    }

    @Override
    public void play() {
        ((WebGuiRenderer)this.renderer).sendMessage("play");
    }

    @Override
    public void stop() {
        ((WebGuiRenderer)this.renderer).sendMessage("stop");
    }

    @Override
    public void mute() {
        ((WebGuiRenderer)this.renderer).sendMessage("mute");
    }

    @Override
    public void setVolume(int volume) {
        ((WebGuiRenderer)this.renderer).sendMessage("setvolume", "" + volume);
    }

    @Override
    public int getControls() {
        return this.renderer.getUmsConfiguration().isWebPlayerControllable() ? 3 : 0;
    }

    @Override
    public void start() {
        this.playingRes = this.renderer.getPlayingRes();
        this.state.setName(this.playingRes.getDisplayName());
        if (this.playingRes.getMediaInfo() != null) {
            this.state.setDuration(StringUtil.shortTime(this.playingRes.getMediaInfo().getDurationString(), 4));
        }
    }

    public void updateStatus(Map<String, String> status) {
        String s = status.get("playback");
        if (s != null) {
            this.state.setPlayback(switch (s) {
                case "STOPPED" -> 0;
                case "PLAYING" -> 1;
                case "PAUSED" -> 2;
                default -> -1;
            });
        }
        if ((s = status.get("mute")) != null) {
            this.state.setMuted(!"0".equals(status.get("mute")));
        }
        if ((s = status.get("volume")) != null) {
            try {
                this.state.setVolume(StringUtil.hasValue(s) ? Integer.parseInt(s) : 0);
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Unexpected volume value \"{}\"", (Object)status.get("volume"));
            }
        }
        if (this.state.isStopped()) {
            this.state.setPosition("");
        } else {
            s = status.get("position");
            if (s != null) {
                try {
                    long seconds = Integer.parseInt(s);
                    this.state.setPosition(seconds * 1000L);
                    if (this.playingRes != null) {
                        this.playingRes.setLastStartPosition(seconds);
                        if (this.playingRes.getMediaStatus() != null) {
                            this.playingRes.getMediaStatus().setLastPlaybackPosition(seconds);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Unexpected position value \"{}\"", (Object)s);
                }
                catch (Exception e) {
                    LOGGER.debug("Exception \"{}\"", (Object)s);
                }
            }
            if ((this.state.isPlaying() || this.state.isPaused()) && this.playingRes != null) {
                StartStopListener startStopListener = new StartStopListener(this.renderer.getUUID(), this.playingRes);
                startStopListener.start();
                startStopListener.stop();
            }
        }
        this.alert();
    }
}

