/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.MinimalPlayer;
import net.pms.store.StoreItem;
import net.pms.util.UMSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaybackTimer
extends MinimalPlayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaybackTimer.class);

    public PlaybackTimer(Renderer renderer) {
        super(renderer);
        LOGGER.debug("Created playback timer for " + renderer.getRendererName());
    }

    @Override
    public void start() {
        long duration;
        StoreItem res = this.renderer.getPlayingRes();
        this.state.setName(res.getDisplayName());
        if (res.getMediaInfo() != null) {
            duration = (long)res.getMediaInfo().getDurationInSeconds() * 1000L;
            this.state.setDuration(duration);
        } else {
            duration = 0L;
        }
        Runnable r = () -> {
            this.state.setPlayback(1);
            while (res == this.renderer.getPlayingRes()) {
                long elapsed = System.currentTimeMillis() - res.getLastStartSystemTime();
                if ((long)res.getLastStartPosition() != 0L) {
                    elapsed += (long)(res.getLastStartPosition() * 1000.0);
                }
                if (duration == 0L || elapsed < duration + 500L) {
                    this.state.setPosition(elapsed);
                } else {
                    this.state.setPosition("NOT_IMPLEMENTED" + (elapsed / 1000L % 2L == 0L ? "  " : "--"));
                }
                this.alert();
                UMSUtils.sleep(1000);
            }
            if (this.renderer.getPlayingRes() == null) {
                this.reset();
            }
        };
        new Thread(r).start();
    }
}

