/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.pms.configuration.RendererConfiguration;
import net.pms.renderers.Renderer;
import net.pms.renderers.RendererFilter;
import net.pms.renderers.RendererUser;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.ChromecastPlayer;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.ChromeCast;

public final class ChromecastDevice
extends Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromecastDevice.class);
    public final ChromeCast chromeCast;

    public ChromecastDevice(ChromeCast chromeCast, RendererConfiguration rendererConf, InetAddress inetAddress) throws ConfigurationException, InterruptedException {
        super(rendererConf, inetAddress);
        this.chromeCast = chromeCast;
        this.uuid = chromeCast.getName();
        this.setAllowed(RendererFilter.isAllowed(this.uuid));
        this.setUserId(RendererUser.getUserId(this.uuid));
        this.setControls(3);
        this.setActive(true);
        this.associateIP(inetAddress);
    }

    @Override
    public String getRendererName() {
        try {
            if (StringUtils.isNotEmpty(this.chromeCast.getName())) {
                return this.chromeCast.getName();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Failed to find name for Chromecast \"{}\"", (Object)this.chromeCast);
            LOGGER.trace("", e);
        }
        return this.getConfName();
    }

    @Override
    public BasicPlayer getPlayer() {
        if (this.player == null) {
            this.player = new ChromecastPlayer(this, this.chromeCast);
            ((ChromecastPlayer)this.player).startPoll();
        }
        return this.player;
    }

    @Override
    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.chromeCast.getAddress());
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Failed to find address for Chromecast \"{}\"", (Object)this.chromeCast);
            LOGGER.trace("", e);
            return null;
        }
    }
}

