/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.RendererConfigurations;
import net.pms.network.SpeedStats;
import net.pms.renderers.JUPnPDeviceHelper;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.WebGuiRenderer;
import net.pms.util.SortedHeaderMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedRenderers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectedRenderers.class);
    private static final Map<InetAddress, Renderer> ADDRESS_RENDERER_ASSOCIATION = Collections.synchronizedMap(new HashMap());
    private static final Map<String, InetAddress> UUID_ADDRESS_ASSOCIATION = Collections.synchronizedMap(new HashMap());
    private static final Map<String, WebGuiRenderer> REACT_CLIENT_RENDERERS = Collections.synchronizedMap(new HashMap());
    private static final Map<String, Renderer> UUID_RENDERER_ASSOCIATION = Collections.synchronizedMap(new HashMap());
    private static final String[] KNOWN_HEADERS = new String[]{"accept", "accept-language", "accept-encoding", "callback", "connection", "content-length", "content-type", "date", "host", "nt", "sid", "timeout", "user-agent"};
    public static final Lock RENDERER_LOCK = new ReentrantLock();

    private ConnectedRenderers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Renderer getRenderer(InetAddress ia, String userAgentString, Collection<Map.Entry<String, String>> headers) {
        Renderer renderer = null;
        RENDERER_LOCK.lock();
        try {
            renderer = ConnectedRenderers.getRendererBySocketAddress(ia);
            if (renderer == null || !renderer.isLoaded()) {
                renderer = ConnectedRenderers.getRendererConfigurationByHeaders(headers, ia);
            }
            if (renderer == null) {
                renderer = ConnectedRenderers.resolve(ia, null);
                if (renderer != null) {
                    LOGGER.debug("Using default media renderer \"{}\"", (Object)renderer.getConfName());
                    if (userAgentString != null && !userAgentString.equals("FDSSDP")) {
                        List<String> identifiers = ConnectedRenderers.getIdentifiers(userAgentString, headers);
                        renderer.setIdentifiers(identifiers);
                        LOGGER.info("Media renderer was not recognized. Possible identifying HTTP headers:\n{}", (Object)StringUtils.join(identifiers, "\n"));
                        PMS.get().setRendererFound(renderer);
                    }
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recognized media renderer \"{}\"", (Object)renderer.getRendererName());
            }
        }
        finally {
            RENDERER_LOCK.unlock();
        }
        return renderer;
    }

    public static Collection<Renderer> getConnectedRenderers() {
        HashSet<Renderer> renderers = new HashSet<Renderer>(UUID_RENDERER_ASSOCIATION.values());
        renderers.addAll(ADDRESS_RENDERER_ASSOCIATION.values());
        renderers.addAll(REACT_CLIENT_RENDERERS.values());
        renderers.addAll(PMS.get().getFoundRenderers());
        return renderers;
    }

    private static List<String> getIdentifiers(String userAgentString, Collection<Map.Entry<String, String>> headers) {
        ArrayList<String> identifiers = new ArrayList<String>();
        identifiers.add("User-Agent: " + userAgentString);
        for (Map.Entry<String, String> header : headers) {
            boolean isKnown = false;
            String headerName = header.getKey().toLowerCase();
            for (String knownHeaderString : KNOWN_HEADERS) {
                if (!headerName.startsWith(knownHeaderString)) continue;
                isKnown = true;
                break;
            }
            if (isKnown) continue;
            identifiers.add(header.getKey() + ": " + header.getValue());
        }
        return identifiers;
    }

    public static Renderer getRendererConfigurationByHeaders(Collection<Map.Entry<String, String>> headers, InetAddress ia) {
        return ConnectedRenderers.getRendererConfigurationByHeaders(new SortedHeaderMap(headers), ia);
    }

    public static Renderer getRendererConfigurationByHeaders(SortedHeaderMap sortedHeaders, InetAddress ia) {
        Renderer r = null;
        RendererConfiguration ref = RendererConfigurations.getRendererConfigurationByHeaders(sortedHeaders);
        if (ref != null) {
            boolean isNew = !ADDRESS_RENDERER_ASSOCIATION.containsKey(ia);
            r = ConnectedRenderers.resolve(ia, ref);
            if (r != null) {
                LOGGER.trace("Matched {}media renderer \"{}\" based on headers {}", isNew ? "new " : "", r.getRendererName(), sortedHeaders);
            }
        }
        return r;
    }

    public static Renderer getRendererBySocketAddress(InetAddress sa) {
        Renderer r = ADDRESS_RENDERER_ASSOCIATION.get(sa);
        if (r != null) {
            LOGGER.trace("Matched media renderer \"{}\" based on address {}", (Object)r.getRendererName(), (Object)sa.getHostAddress());
        }
        return r;
    }

    public static Renderer getRendererByUUID(String uuid) {
        for (Renderer renderer : ConnectedRenderers.getConnectedRenderers()) {
            if (!uuid.equalsIgnoreCase(renderer.getUUID())) continue;
            return renderer;
        }
        return null;
    }

    public static Renderer find(Renderer r, InetAddress ia) {
        return ConnectedRenderers.find(r.getConfName(), ia);
    }

    public static Renderer find(String name, InetAddress ia) {
        for (Renderer r : ConnectedRenderers.getConnectedRenderers()) {
            if (!ia.equals(r.getAddress()) || !name.equals(r.getConfName())) continue;
            return r;
        }
        return null;
    }

    public static Renderer resolve(InetAddress ia, RendererConfiguration ref) {
        boolean recognized;
        Renderer renderer = null;
        boolean bl = recognized = ref != null;
        if (!recognized) {
            ref = RendererConfigurations.getDefaultConf();
        }
        try {
            if (ADDRESS_RENDERER_ASSOCIATION.containsKey(ia)) {
                boolean higher;
                renderer = ADDRESS_RENDERER_ASSOCIATION.get(ia);
                boolean bl2 = higher = ref != null && ref.getLoadingPriority() > renderer.getLoadingPriority() && recognized;
                if (!renderer.isLoaded() || higher) {
                    LOGGER.debug("Finishing configuration for {}", (Object)renderer);
                    if (higher) {
                        LOGGER.debug("Switching to higher priority renderer: {}", (Object)ref);
                    }
                    renderer.inherit(ref);
                    renderer.updateRendererGui();
                }
            } else if (!JUPnPDeviceHelper.isNonRenderer(ia)) {
                renderer = new Renderer(ref, ia);
                if (renderer.associateIP(ia)) {
                    PMS.get().setRendererFound(renderer);
                }
                renderer.setActive(true);
                if (JUPnPDeviceHelper.getDevice(ia) == null) {
                    LOGGER.debug("Sending UPnP search for newly created renderer: {}", (Object)renderer);
                    JUPnPDeviceHelper.searchMediaRendererDevices();
                } else if (renderer.isUpnpPostponed()) {
                    renderer.setUpnpMode(1);
                }
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error("Configuration error while resolving renderer: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupted while resolving renderer \"{}\": {}", (Object)ia, (Object)e.getMessage());
            Thread.currentThread().interrupt();
            return null;
        }
        if (!recognized) {
            LOGGER.trace("Marking renderer \"{}\" at {} as unrecognized", (Object)renderer, (Object)ia.getHostAddress());
            if (renderer != null) {
                renderer.resetLoaded();
            }
        }
        return renderer;
    }

    public static void verify(Renderer r) {
        if (!r.verify()) {
            LOGGER.debug("Purging renderer {} as invalid", (Object)r);
            ConnectedRenderers.delete(r, 0L);
        }
    }

    public static void delete(final Renderer renderer, long delay) {
        renderer.setActive(false);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (!renderer.isActive()) {
                    String uuid;
                    LOGGER.debug("Deleting renderer " + String.valueOf(renderer));
                    renderer.deleteGuis();
                    PMS.get().getFoundRenderers().remove(renderer);
                    InetAddress ia = renderer.getAddress();
                    if (ADDRESS_RENDERER_ASSOCIATION.get(ia) == renderer) {
                        ADDRESS_RENDERER_ASSOCIATION.remove(ia);
                    }
                    if ((uuid = renderer.getUUID()) != null) {
                        if (UUID_RENDERER_ASSOCIATION.get(uuid) == renderer) {
                            UUID_RENDERER_ASSOCIATION.remove(uuid);
                        }
                        if (REACT_CLIENT_RENDERERS.get(uuid) == renderer) {
                            REACT_CLIENT_RENDERERS.remove(uuid);
                        }
                        if (uuid.equals(ConnectedRenderers.getUuidOf(ia))) {
                            ConnectedRenderers.removeUuidOf(ia);
                        }
                    }
                    renderer.clearMediaStore();
                }
            }
        };
        new Timer("RendererDeletion").schedule(task, delay);
    }

    public static void deleteAllConnectedRenderers() {
        for (Renderer r : ConnectedRenderers.getConnectedRenderers()) {
            ConnectedRenderers.delete(r, 0L);
        }
    }

    public static void resetAllRenderers() {
        for (Renderer r : ConnectedRenderers.getConnectedRenderers()) {
            r.resetMediaStore();
        }
    }

    public static List<Renderer> getInheritors(Renderer renderer) {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        RendererConfiguration ref = renderer.getRef();
        for (Renderer connectedRenderer : ConnectedRenderers.getConnectedRenderers()) {
            if (connectedRenderer.getRef() != ref) continue;
            renderers.add(connectedRenderer);
        }
        return renderers;
    }

    public static void addRendererAssociation(InetAddress sa, Renderer r) {
        Renderer prev = ADDRESS_RENDERER_ASSOCIATION.put(sa, r);
        if (prev != null) {
            ConnectedRenderers.verify(prev);
        }
    }

    public static boolean hasInetAddressForRenderer(Renderer r) {
        return ADDRESS_RENDERER_ASSOCIATION.containsValue(r);
    }

    public static InetAddress getRendererInetAddress(Renderer r) {
        for (Map.Entry<InetAddress, Renderer> entry : ADDRESS_RENDERER_ASSOCIATION.entrySet()) {
            if (entry.getValue() != r) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void addUuidAssociation(InetAddress ia, String id) {
        if (ia != null && id != null) {
            UUID_ADDRESS_ASSOCIATION.put(id, ia);
        }
    }

    public static String getUuidOf(InetAddress ia) {
        Optional<Map.Entry> res;
        if (ia != null && (res = UUID_ADDRESS_ASSOCIATION.entrySet().stream().filter(entry -> ia.equals(entry.getValue())).findFirst()).isPresent()) {
            return (String)res.get().getKey();
        }
        return null;
    }

    private static void removeUuidOf(InetAddress ia) {
        if (ia != null) {
            while (UUID_ADDRESS_ASSOCIATION.values().remove(ia)) {
            }
        }
    }

    public static void calculateAllSpeeds() {
        HashMap<InetAddress, String> values = new HashMap<InetAddress, String>();
        for (Map.Entry<InetAddress, Renderer> entry : ADDRESS_RENDERER_ASSOCIATION.entrySet()) {
            Renderer r;
            InetAddress sa = entry.getKey();
            if (sa.isLoopbackAddress() || sa.isAnyLocalAddress() || (r = entry.getValue()).isOffline()) continue;
            values.put(sa, r.getRendererName());
        }
        for (Map.Entry<InetAddress, Renderer> entry : values.entrySet()) {
            SpeedStats.getSpeedInMBits(entry.getKey(), (String)((Object)entry.getValue()));
        }
    }

    public static void addWebPlayerRenderer(WebGuiRenderer renderer) {
        REACT_CLIENT_RENDERERS.put(renderer.getUUID(), renderer);
        PMS.get().setRendererFound(renderer);
    }

    public static WebGuiRenderer getWebPlayerRenderer(String uuid) {
        return REACT_CLIENT_RENDERERS.get(uuid);
    }

    public static boolean hasWebPlayerRenderer(String uuid) {
        return REACT_CLIENT_RENDERERS.containsKey(uuid);
    }

    public static void removeWebPlayerRenderer(String uuid) {
        Renderer renderer = REACT_CLIENT_RENDERERS.remove(uuid);
        if (renderer != null) {
            ConnectedRenderers.delete(renderer, 0L);
        }
    }

    public static boolean isValidUUID(String token) {
        try {
            UUID.fromString(token);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getRandomUUID() {
        String uuid = UUID.randomUUID().toString();
        while (ConnectedRenderers.getRendererByUUID(uuid) != null) {
            uuid = UUID.randomUUID().toString();
        }
        return uuid;
    }

    public static void markUpnpRenderer(String uuid, int property, Object value) {
        Renderer renderer = UUID_RENDERER_ASSOCIATION.get(uuid);
        switch (property) {
            case 0: {
                renderer.setActive((Boolean)value);
                break;
            }
            case 2: {
                renderer.setRenew((Boolean)value);
                break;
            }
            case 1: {
                renderer.setControls((Integer)value);
                break;
            }
        }
    }

    public static boolean hasUuidRenderer(String uuid) {
        return UUID_RENDERER_ASSOCIATION.containsKey(uuid);
    }

    public static Renderer addUuidRenderer(String uuid, Renderer renderer) {
        return UUID_RENDERER_ASSOCIATION.put(uuid, renderer);
    }

    public static Renderer getUuidRenderer(String uuid) {
        return UUID_RENDERER_ASSOCIATION.get(uuid);
    }

    public static Renderer getOrCreateUuidRenderer(String uuid) {
        if (!ConnectedRenderers.hasUuidRenderer(uuid)) {
            try {
                ConnectedRenderers.addUuidRenderer(uuid, new Renderer(uuid));
            }
            catch (ConfigurationException e) {
                LOGGER.error("Error instantiating item {}: {}", (Object)uuid, (Object)e.getMessage());
                LOGGER.trace("", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return ConnectedRenderers.getUuidRenderer(uuid);
    }

    public static List<Renderer> getUPnPRenderers(int type) {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (Renderer r : UUID_RENDERER_ASSOCIATION.values()) {
            if (!r.isActive() || !r.isControllable(type)) continue;
            renderers.add(r);
        }
        return renderers;
    }

    public static boolean hasUpNPRenderer(int type) {
        for (Renderer r : UUID_RENDERER_ASSOCIATION.values()) {
            if (!r.isControllable(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConnectedAVTransportPlayers() {
        return ConnectedRenderers.hasUpNPRenderer(1);
    }

    public static List<Renderer> getConnectedAVTransportPlayers() {
        return ConnectedRenderers.getUPnPRenderers(1);
    }

    public static List<Renderer> getConnectedControlPlayers() {
        return ConnectedRenderers.getConnectedRenderers(255);
    }

    public static boolean hasConnectedControlPlayers() {
        return ConnectedRenderers.hasConnectedRenderer(255);
    }

    public static boolean hasConnectedRenderer(int type) {
        for (Renderer r : ConnectedRenderers.getConnectedRenderers()) {
            if (!r.isControllable(type)) continue;
            return true;
        }
        return false;
    }

    public static List<Renderer> getConnectedRenderers(int type) {
        ArrayList<Renderer> renderers = new ArrayList<Renderer>();
        for (Renderer r : ConnectedRenderers.getConnectedRenderers()) {
            if (!r.isActive() || !r.isControllable(type)) continue;
            renderers.add(r);
        }
        return renderers;
    }
}

