/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.pms.platform.PlatformProgramPaths;
import net.pms.platform.PlatformUtils;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FFmpegProgramInfo;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import net.pms.util.ProgramExecutableType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsProgramPaths
extends PlatformProgramPaths {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsProgramPaths.class);
    private final FFmpegProgramInfo ffmpegInfo;
    private final ExternalProgramInfo mPlayerInfo;
    private final ExternalProgramInfo vlcInfo;
    private final ExternalProgramInfo mEncoderInfo;
    private final ExternalProgramInfo tsMuxeRInfo;
    private final ExternalProgramInfo flacInfo;
    private final ExternalProgramInfo dcRawInfo;
    private final ExternalProgramInfo aviSynthInfo;
    private final ExternalProgramInfo interFrameInfo;
    private final ExternalProgramInfo ffms2Info;
    private final ExternalProgramInfo directShowSourceInfo;
    private final ExternalProgramInfo mvtools2Info;
    private final ExternalProgramInfo depanInfo;
    private final ExternalProgramInfo masktools2Info;
    private final ExternalProgramInfo cropResizeInfo;
    private final ExternalProgramInfo convert2dTo3dInfo;
    private final ExternalProgramInfo youtubeDlInfo;
    private final Path mediaInfo;
    private final Path ctrlSender;
    private final Path taskKill;

    public WindowsProgramPaths() {
        Path vlcPath;
        Path ffmpeg = WindowsProgramPaths.resolve("ffmpeg.exe");
        try {
            if (!new FilePermissions(ffmpeg, new LinkOption[0]).isExecutable()) {
                LOGGER.trace("Insufficient permission to executable \"{}\"", (Object)ffmpeg);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.trace("Executable \"{}\" not found: {}", (Object)ffmpeg, (Object)e.getMessage());
        }
        this.ffmpegInfo = new FFmpegProgramInfo("FFmpeg", ProgramExecutableType.BUNDLED);
        this.ffmpegInfo.setPath(ProgramExecutableType.BUNDLED, ffmpeg);
        ffmpeg = FileUtil.findExecutableInOSPath(Paths.get("ffmpeg.exe", new String[0]));
        if (ffmpeg != null) {
            this.ffmpegInfo.setPath(ProgramExecutableType.INSTALLED, ffmpeg);
        }
        Path mPlayer = WindowsProgramPaths.resolve("mplayer.exe");
        this.mPlayerInfo = new ExternalProgramInfo("MPlayer", ProgramExecutableType.BUNDLED);
        this.mPlayerInfo.setPath(ProgramExecutableType.BUNDLED, mPlayer);
        mPlayer = FileUtil.findExecutableInOSPath(Paths.get("mplayer.exe", new String[0]));
        if (mPlayer != null) {
            this.mPlayerInfo.setPath(ProgramExecutableType.INSTALLED, mPlayer);
        }
        if ((vlcPath = PlatformUtils.INSTANCE.getVlcPath()) == null || !Files.exists(vlcPath, new LinkOption[0])) {
            vlcPath = FileUtil.findExecutableInOSPath(Paths.get("vlc.exe", new String[0]));
        }
        if (vlcPath != null) {
            this.vlcInfo = new ExternalProgramInfo("VLC", ProgramExecutableType.INSTALLED);
            this.vlcInfo.setPath(ProgramExecutableType.INSTALLED, vlcPath);
        } else {
            this.vlcInfo = new ExternalProgramInfo("VLC", null);
        }
        Path mEncoder = WindowsProgramPaths.resolve("mencoder.exe");
        this.mEncoderInfo = new ExternalProgramInfo("MEncoder", ProgramExecutableType.BUNDLED);
        this.mEncoderInfo.setPath(ProgramExecutableType.BUNDLED, mEncoder);
        mEncoder = FileUtil.findExecutableInOSPath(Paths.get("mencoder.exe", new String[0]));
        if (mEncoder != null) {
            this.mEncoderInfo.setPath(ProgramExecutableType.INSTALLED, mEncoder);
        }
        Path tsMuxeR = WindowsProgramPaths.resolve("tsMuxeR.exe");
        this.tsMuxeRInfo = new ExternalProgramInfo("tsMuxeR", ProgramExecutableType.BUNDLED);
        this.tsMuxeRInfo.setPath(ProgramExecutableType.BUNDLED, tsMuxeR);
        tsMuxeR = FileUtil.findExecutableInOSPath(Paths.get("tsMuxeR.exe", new String[0]));
        if (tsMuxeR != null) {
            this.tsMuxeRInfo.setPath(ProgramExecutableType.INSTALLED, tsMuxeR);
        }
        Path flac = WindowsProgramPaths.resolve("flac.exe");
        this.flacInfo = new ExternalProgramInfo("FLAC", ProgramExecutableType.BUNDLED);
        this.flacInfo.setPath(ProgramExecutableType.BUNDLED, flac);
        Path dcRaw = WindowsProgramPaths.resolve("dcrawMS.exe");
        this.dcRawInfo = new ExternalProgramInfo("DCRaw", ProgramExecutableType.BUNDLED);
        this.dcRawInfo.setPath(ProgramExecutableType.BUNDLED, dcRaw);
        dcRaw = FileUtil.findExecutableInOSPath(Paths.get("dcrawMS.exe", new String[0]));
        if (dcRaw != null) {
            this.dcRawInfo.setPath(ProgramExecutableType.INSTALLED, dcRaw);
        }
        Path aviSynth = WindowsProgramPaths.resolve("avisynth.dll");
        this.aviSynthInfo = new ExternalProgramInfo("AviSynth", ProgramExecutableType.BUNDLED);
        this.aviSynthInfo.setPath(ProgramExecutableType.BUNDLED, aviSynth);
        Path interframe = WindowsProgramPaths.resolve("interframe");
        this.interFrameInfo = new ExternalProgramInfo("InterFrame", ProgramExecutableType.BUNDLED);
        this.interFrameInfo.setPath(ProgramExecutableType.BUNDLED, interframe);
        Path cropResize = WindowsProgramPaths.resolve("avisynth/CropResize.avsi");
        this.cropResizeInfo = new ExternalProgramInfo("CropResize", ProgramExecutableType.BUNDLED);
        this.cropResizeInfo.setPath(ProgramExecutableType.BUNDLED, cropResize);
        Path convert2dTo3d = WindowsProgramPaths.resolve("avisynth/convert2dto3d.avsi");
        this.convert2dTo3dInfo = new ExternalProgramInfo("convert2dto3d", ProgramExecutableType.BUNDLED);
        this.convert2dTo3dInfo.setPath(ProgramExecutableType.BUNDLED, convert2dTo3d);
        Path ffms2 = WindowsProgramPaths.resolve("avisynth/ffms2.dll");
        this.ffms2Info = new ExternalProgramInfo("ffms2", ProgramExecutableType.BUNDLED);
        this.ffms2Info.setPath(ProgramExecutableType.BUNDLED, ffms2);
        Path directShowSource = WindowsProgramPaths.resolve("avisynth/DirectShowSource.dll");
        this.directShowSourceInfo = new ExternalProgramInfo("DirectShowSource", ProgramExecutableType.BUNDLED);
        this.directShowSourceInfo.setPath(ProgramExecutableType.BUNDLED, directShowSource);
        Path mvtools2 = WindowsProgramPaths.resolve("avisynth/mvtools2.dll");
        this.mvtools2Info = new ExternalProgramInfo("mvtools2", ProgramExecutableType.BUNDLED);
        this.mvtools2Info.setPath(ProgramExecutableType.BUNDLED, mvtools2);
        Path depan = WindowsProgramPaths.resolve("avisynth/DePan.dll");
        this.depanInfo = new ExternalProgramInfo("depan", ProgramExecutableType.BUNDLED);
        this.depanInfo.setPath(ProgramExecutableType.BUNDLED, depan);
        Path masktools2 = WindowsProgramPaths.resolve("avisynth/masktools2.dll");
        this.masktools2Info = new ExternalProgramInfo("masktools2", ProgramExecutableType.BUNDLED);
        this.masktools2Info.setPath(ProgramExecutableType.BUNDLED, masktools2);
        Path tmpCtrlSender = WindowsProgramPaths.resolve("ctrlsender.exe");
        try {
            if (!new FilePermissions(tmpCtrlSender, new LinkOption[0]).isExecutableFile()) {
                tmpCtrlSender = null;
            }
        }
        catch (FileNotFoundException e) {
            tmpCtrlSender = null;
        }
        this.ctrlSender = tmpCtrlSender;
        Path youtubeDl = WindowsProgramPaths.resolve("youtube-dl.exe");
        this.youtubeDlInfo = new ExternalProgramInfo("youtube-dl", ProgramExecutableType.BUNDLED);
        this.youtubeDlInfo.setPath(ProgramExecutableType.BUNDLED, youtubeDl);
        Path tmpMediaInfo = WindowsProgramPaths.resolve("mediainfo.dll");
        this.mediaInfo = Files.exists(tmpMediaInfo, new LinkOption[0]) ? tmpMediaInfo.getParent() : null;
        this.taskKill = FileUtil.findExecutableInOSPath(Paths.get("taskkill.exe", new String[0]));
    }

    @Override
    public FFmpegProgramInfo getFFmpeg() {
        return this.ffmpegInfo;
    }

    @Override
    public ExternalProgramInfo getMPlayer() {
        return this.mPlayerInfo;
    }

    @Override
    public ExternalProgramInfo getVLC() {
        return this.vlcInfo;
    }

    @Override
    public ExternalProgramInfo getMEncoder() {
        return this.mEncoderInfo;
    }

    @Override
    public ExternalProgramInfo getTsMuxeR() {
        return this.tsMuxeRInfo;
    }

    @Override
    public ExternalProgramInfo getFLAC() {
        return this.flacInfo;
    }

    @Override
    public ExternalProgramInfo getDCRaw() {
        return this.dcRawInfo;
    }

    @Override
    public ExternalProgramInfo getAviSynth() {
        return this.aviSynthInfo;
    }

    @Override
    public ExternalProgramInfo getInterFrame() {
        return this.interFrameInfo;
    }

    @Override
    public ExternalProgramInfo getFFMS2() {
        return this.ffms2Info;
    }

    @Override
    public ExternalProgramInfo getDirectShowSource() {
        return this.ffms2Info;
    }

    @Override
    public ExternalProgramInfo getMvtools2() {
        return this.mvtools2Info;
    }

    @Override
    public ExternalProgramInfo getDepan() {
        return this.depanInfo;
    }

    @Override
    public ExternalProgramInfo getMasktools2() {
        return this.masktools2Info;
    }

    @Override
    public ExternalProgramInfo getCropResize() {
        return this.cropResizeInfo;
    }

    @Override
    public ExternalProgramInfo getConvert2dTo3d() {
        return this.convert2dTo3dInfo;
    }

    @Override
    public ExternalProgramInfo getYoutubeDl() {
        return this.youtubeDlInfo;
    }

    public Path getMediaInfo() {
        return this.mediaInfo;
    }

    @Override
    public Path getCtrlSender() {
        return this.ctrlSender;
    }

    @Override
    public Path getTaskKill() {
        return this.taskKill;
    }

    @Nonnull
    public static List<String> getWindowsPathExtensions() {
        String[] extensions;
        ArrayList<String> result = new ArrayList<String>();
        String osPathExtensions = System.getenv("PATHEXT");
        if (StringUtils.isBlank(osPathExtensions)) {
            return result;
        }
        for (String extension : extensions = osPathExtensions.split(File.pathSeparator)) {
            result.add(extension.replace(".", ""));
        }
        return result;
    }
}

