/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.linux;

import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributes;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.pms.platform.linux.UnixMountPoint;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreedesktopTrash {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreedesktopTrash.class);
    private static final Object HOME_FOLDER_LOCK = new Object();
    private static final String INFO = "info";
    private static final String FILES = "files";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static Path homeFolder = null;
    private static final int S_ISVTX = 512;
    private static int unixUID = Integer.MIN_VALUE;
    private static final Object UNIX_UID_LOCK = new Object();

    private FreedesktopTrash() {
    }

    private static String generateRandomFileName(String fileName) {
        String suffix;
        String prefix;
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Invalid file name");
        }
        if (fileName.contains(".")) {
            int i = fileName.lastIndexOf(46);
            prefix = fileName.substring(0, i);
            suffix = fileName.substring(i);
        } else {
            prefix = fileName;
            suffix = "";
        }
        long n = RANDOM.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        return prefix + Long.toString(n) + suffix;
    }

    private static Path getVerifiedPath(String location) {
        Path path;
        if (location != null && !location.trim().isEmpty() && Files.exists(path = Paths.get(location, new String[0]), new LinkOption[0])) {
            return path.toAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path getHomeFolder() {
        Object object = HOME_FOLDER_LOCK;
        synchronized (object) {
            if (homeFolder == null) {
                homeFolder = FreedesktopTrash.getVerifiedPath(System.getenv("XDG_DATA_HOME"));
                if (homeFolder == null) {
                    homeFolder = FreedesktopTrash.getVerifiedPath(System.getenv("HOME"));
                }
                if (homeFolder == null) {
                    homeFolder = FreedesktopTrash.getVerifiedPath(System.getProperty("user.home"));
                }
            }
            return Paths.get(homeFolder.toString(), new String[0]);
        }
    }

    private static boolean verifyTrashFolder(Path path, boolean create) {
        FilePermissions permissions;
        try {
            permissions = new FilePermissions(path, new LinkOption[0]);
        }
        catch (FileNotFoundException e) {
            if (create) {
                LOGGER.trace("Trash folder \"{}\" doesn't exist, attempting to create it", (Object)path);
                try {
                    Files.createDirectories(path, new FileAttribute[0]);
                }
                catch (IOException e1) {
                    LOGGER.debug("Could not create user trash folder \"{}\": {}", (Object)path, (Object)e1.getMessage());
                    LOGGER.trace("", e1);
                    return false;
                }
                try {
                    permissions = new FilePermissions(path, new LinkOption[0]);
                }
                catch (FileNotFoundException e1) {
                    LOGGER.error("Impossible situation in verifyTrashFolder()", e1);
                    return false;
                }
            }
            LOGGER.trace("Trash folder \"{}\" doesn't exist", (Object)path);
            LOGGER.trace("", e);
            return false;
        }
        if (!(permissions.isBrowsable() && permissions.isWritable() && permissions.isFolder())) {
            if (!permissions.isFolder()) {
                LOGGER.debug("Trash folder \"{}\" is not a folder", (Object)path);
            } else {
                LOGGER.debug("Insufficient permissions for trash folder \"{}\": {}", (Object)path, (Object)permissions.toString());
            }
            return false;
        }
        return true;
    }

    private static Path getTrashFolder(Path path) throws FileUtil.InvalidFileSystemException, IOException {
        Path trashFolder;
        UnixMountPoint pathMountPoint;
        block23: {
            try {
                pathMountPoint = UnixMountPoint.getMountPoint(path);
            }
            catch (FileUtil.InvalidFileSystemException e) {
                throw new FileUtil.InvalidFileSystemException("Invalid file system for file: " + String.valueOf(path.toAbsolutePath()), e);
            }
            Path folder = FreedesktopTrash.getHomeFolder();
            if (folder != null) {
                UnixMountPoint homeMountPoint = null;
                try {
                    homeMountPoint = UnixMountPoint.getMountPoint(folder);
                }
                catch (FileUtil.InvalidFileSystemException e) {
                    LOGGER.trace(e.getMessage(), e);
                }
                if (pathMountPoint.equals(homeMountPoint)) {
                    Path trashFolder2 = Paths.get(folder.toString(), ".Trash");
                    if (!Files.exists(trashFolder2, new LinkOption[0])) {
                        trashFolder2 = Paths.get(folder.toString(), ".local/share/Trash");
                    }
                    if (FreedesktopTrash.verifyTrashFolder(trashFolder2, true)) {
                        return trashFolder2;
                    }
                    return null;
                }
            }
            trashFolder = Paths.get(pathMountPoint.getFolder(), ".Trash");
            if (Files.exists(trashFolder, LinkOption.NOFOLLOW_LINKS)) {
                if (!Files.isSymbolicLink(trashFolder)) {
                    try {
                        if (FreedesktopTrash.isUnixStickyBit(trashFolder)) {
                            if (FreedesktopTrash.verifyTrashFolder(trashFolder, false)) {
                                try {
                                    trashFolder = Paths.get(trashFolder.toString(), String.valueOf(FreedesktopTrash.getUnixUID()));
                                    if (FreedesktopTrash.verifyTrashFolder(trashFolder, true)) {
                                        return trashFolder;
                                    }
                                    LOGGER.trace("Could not read or create trash folder \"{}\", trying next option", (Object)trashFolder);
                                }
                                catch (IOException e) {
                                    LOGGER.trace("Could not determine user id while resolving trash folder, trying next option", e);
                                }
                            } else {
                                LOGGER.trace("Insufficient permissions for trash folder \"{}\", trying next option", (Object)trashFolder);
                            }
                            break block23;
                        }
                        LOGGER.trace("Trash folder \"{}\" doesn't have sticky bit set, trying next option", (Object)trashFolder);
                    }
                    catch (IOException e) {
                        LOGGER.trace("Could not determine sticky bit for trash folder \"" + String.valueOf(trashFolder) + "\", trying next option", e);
                    }
                } else {
                    LOGGER.trace("Trash folder \"{}\" is a symbolic link, trying next option");
                }
            } else {
                LOGGER.trace("Trash folder \"{}\" doesn't exist, trying next option", (Object)trashFolder);
            }
        }
        try {
            trashFolder = Paths.get(pathMountPoint.getFolder(), ".Trash-" + FreedesktopTrash.getUnixUID());
        }
        catch (IOException e) {
            throw new IOException("Could not determine user id while resolving trash folder: " + e.getMessage(), e);
        }
        if (FreedesktopTrash.verifyTrashFolder(trashFolder, true)) {
            return trashFolder;
        }
        LOGGER.debug("Unable to read or create trash folder \"{}\"", (Object)trashFolder);
        return null;
    }

    private static boolean verifyTrashStructure(Path trashPath) {
        String trashLocation = trashPath.toAbsolutePath().toString();
        return FreedesktopTrash.verifyTrashFolder(Paths.get(trashLocation, INFO), true) && FreedesktopTrash.verifyTrashFolder(Paths.get(trashLocation, FILES), true);
    }

    private static void moveToTrash(Path path) throws FileUtil.InvalidFileSystemException, IOException {
        if (path == null) {
            throw new NullPointerException("path cannot be null");
        }
        int limit = 10;
        FilePermissions pathPermissions = new FilePermissions(path = path.toAbsolutePath(), new LinkOption[0]);
        if (!pathPermissions.isReadable() || !pathPermissions.isWritable()) {
            throw new IOException("Insufficient permission to delete \"" + path.toString() + "\" - move to trash bin failed");
        }
        Path trashFolder = FreedesktopTrash.getTrashFolder(path);
        Path infoFolder = trashFolder.resolve(INFO);
        Path filesFolder = trashFolder.resolve(FILES);
        if (!FreedesktopTrash.verifyTrashFolder(infoFolder, true) || !FreedesktopTrash.verifyTrashFolder(filesFolder, true)) {
            throw new IOException("Could not move \"" + path.toString() + "\" to trash bin because of insufficient permissions for trash bin \"" + trashFolder.toString() + "\"");
        }
        ArrayList<Object> infoContent = new ArrayList<Object>();
        infoContent.add("[Trash Info]");
        infoContent.add("Path=" + URLEncoder.encode(path.toString(), Charset.defaultCharset().name()));
        infoContent.add("DeletionDate=" + new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss").format(new Date()));
        Path infoFile = path.getFileName();
        String fileName = infoFile != null ? infoFile.toString() : "";
        int count = 0;
        boolean created = false;
        while (!created && count < 10) {
            infoFile = infoFolder.resolve(fileName + ".trashinfo");
            try {
                Files.write(infoFile, infoContent, Charset.defaultCharset(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                created = true;
            }
            catch (IOException e) {
                fileName = FreedesktopTrash.generateRandomFileName(fileName);
                ++count;
            }
        }
        if (!created) {
            throw new IOException("Could not find a target filename for \"" + path.toString() + "\" in trash bin");
        }
        Path targetPath = filesFolder.resolve(fileName);
        if (Files.exists(targetPath, new LinkOption[0])) {
            throw new IOException("Could not move \"" + path.toString() + "\" to trash bin since the trash bin \"" + trashFolder.toString() + "\" is corrupted");
        }
        Files.move(path, targetPath, StandardCopyOption.ATOMIC_MOVE);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("{}{}\" moved to \"{}\"", Files.isDirectory(path, new LinkOption[0]) ? "Folder \"" : "File \"", path, targetPath);
        }
    }

    public static void moveToTrash(File file) throws FileUtil.InvalidFileSystemException, IOException {
        FreedesktopTrash.moveToTrash(file.toPath());
    }

    public static boolean isUnixStickyBit(Path path) throws IOException, FileUtil.InvalidFileSystemException {
        PosixFileAttributes attr = Files.readAttributes(path, PosixFileAttributes.class, new LinkOption[0]);
        try {
            Field stModeField = attr.getClass().getDeclaredField("st_mode");
            stModeField.setAccessible(true);
            int stMode = stModeField.getInt(attr);
            return (stMode & 0x200) > 0;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new FileUtil.InvalidFileSystemException("File is not on a Unix file system: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUnixUID() throws IOException {
        if (Platform.isAIX() || Platform.isFreeBSD() || Platform.isGNU() || Platform.iskFreeBSD() || Platform.isLinux() || Platform.isMac() || Platform.isNetBSD() || Platform.isOpenBSD() || Platform.isSolaris()) {
            Object object = UNIX_UID_LOCK;
            synchronized (object) {
                if (unixUID < 0) {
                    String response;
                    Process id = Runtime.getRuntime().exec(new String[]{"id", "-u"});
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(id.getInputStream(), Charset.defaultCharset()));){
                        response = reader.readLine();
                    }
                    try {
                        unixUID = Integer.parseInt(response);
                    }
                    catch (NumberFormatException e) {
                        throw new UnsupportedOperationException("Unexpected response from OS: " + response, e);
                    }
                }
                return unixUID;
            }
        }
        throw new UnsupportedOperationException("getUnixUID can only be called on Unix based OS'es");
    }
}

