/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform;

import com.sun.jna.Platform;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.pms.platform.linux.LinuxProgramPaths;
import net.pms.platform.mac.MacProgramPaths;
import net.pms.platform.windows.WindowsProgramPaths;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FFmpegProgramInfo;
import net.pms.util.FilePermissions;
import net.pms.util.PropertiesUtil;
import org.apache.commons.lang3.StringUtils;

public abstract class PlatformProgramPaths {
    @Nonnull
    private static final PlatformProgramPaths INSTANCE;
    protected static final Path BINARIES_FOLDER;
    protected static final Path PLATFORM_BINARIES_FOLDER;
    protected static final Path PLATFORM_DEVELOPMENT_BINARIES_FOLDER;

    @Nullable
    public abstract FFmpegProgramInfo getFFmpeg();

    @Nullable
    public abstract ExternalProgramInfo getMPlayer();

    @Nullable
    public abstract ExternalProgramInfo getVLC();

    @Nullable
    public abstract ExternalProgramInfo getMEncoder();

    @Nullable
    public abstract ExternalProgramInfo getTsMuxeR();

    @Nullable
    public abstract ExternalProgramInfo getFLAC();

    @Nullable
    public abstract ExternalProgramInfo getDCRaw();

    @Nullable
    public abstract ExternalProgramInfo getAviSynth();

    @Nullable
    public abstract ExternalProgramInfo getInterFrame();

    @Nullable
    public abstract ExternalProgramInfo getFFMS2();

    @Nullable
    public abstract ExternalProgramInfo getDirectShowSource();

    @Nullable
    public abstract ExternalProgramInfo getMvtools2();

    @Nullable
    public abstract ExternalProgramInfo getDepan();

    @Nullable
    public abstract ExternalProgramInfo getMasktools2();

    @Nullable
    public abstract ExternalProgramInfo getConvert2dTo3d();

    @Nullable
    public abstract ExternalProgramInfo getCropResize();

    @Nullable
    public abstract ExternalProgramInfo getYoutubeDl();

    @Nullable
    public Path getCtrlSender() {
        return null;
    }

    @Nullable
    public Path getTaskKill() {
        return null;
    }

    @Nonnull
    public static final PlatformProgramPaths get() {
        return INSTANCE;
    }

    @Nonnull
    protected static Path getBinariesFolder() {
        String path = PropertiesUtil.getProjectProperties().get("project.binaries.dir");
        try {
            if (StringUtils.isNotBlank(path)) {
                return Paths.get(path, new String[0]);
            }
        }
        catch (InvalidPathException e) {
            System.err.println("Invalid \"project.binaries.dir\":" + String.valueOf(e));
        }
        return Paths.get("", new String[0]);
    }

    public static Path resolve(String other) {
        Path otherPath = null;
        if (PLATFORM_DEVELOPMENT_BINARIES_FOLDER != null) {
            otherPath = PLATFORM_DEVELOPMENT_BINARIES_FOLDER.resolve(other);
        }
        if (otherPath == null || !Files.exists(otherPath, new LinkOption[0])) {
            otherPath = PLATFORM_BINARIES_FOLDER.resolve(other);
        }
        return otherPath;
    }

    static {
        BINARIES_FOLDER = PlatformProgramPaths.getBinariesFolder();
        String subPath = Platform.isWindows() ? "bin" : (Platform.isMac() ? "osx" : "linux");
        PLATFORM_BINARIES_FOLDER = BINARIES_FOLDER.resolve(subPath).toAbsolutePath();
        Path developmentBinaryFolder = Paths.get("target/bin", subPath);
        try {
            FilePermissions permission = new FilePermissions(developmentBinaryFolder, new LinkOption[0]);
            developmentBinaryFolder = permission.isBrowsable() ? developmentBinaryFolder.toAbsolutePath() : null;
        }
        catch (FileNotFoundException e) {
            developmentBinaryFolder = null;
        }
        PLATFORM_DEVELOPMENT_BINARIES_FOLDER = developmentBinaryFolder;
        INSTANCE = Platform.isWindows() ? new WindowsProgramPaths() : (Platform.isMac() ? new MacProgramPaths() : new LinuxProgramPaths());
    }
}

