/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipOutputStream;
import net.pms.PMS;
import net.pms.gui.GuiManager;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.util.DbgPacker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="LogsApiServlet", urlPatterns={"/v1/api/logs"}, displayName="Logs Api Servlet")
public class LogsApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogsApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Account account = AuthService.getAccountLoggedIn(req);
        if (account == null) {
            LogsApiServlet.respondUnauthorized(req, resp);
            return;
        }
        if (!account.havePermission(2048)) {
            LogsApiServlet.respondForbidden(req, resp);
            return;
        }
        try {
            String path;
            switch (path = req.getPathInfo() != null ? req.getPathInfo() : "/") {
                case "/": {
                    JsonObject result = new JsonObject();
                    result.addProperty("rootLogLevel", CONFIGURATION.getRootLogLevel());
                    result.addProperty("guiLogLevel", CONFIGURATION.getLoggingFilterLogsTab().toString());
                    result.addProperty("traceMode", PMS.getTraceMode());
                    result.addProperty("hasMoreLogLines", GuiManager.hasMoreLogLines());
                    JsonArray logLines = LogsApiServlet.getLogLines();
                    if (logLines != null) {
                        result.add("logs", logLines);
                    } else {
                        result.add("logs", new JsonArray());
                    }
                    LogsApiServlet.respond(req, resp, result.toString(), 200, "application/json", false);
                    break;
                }
                case "/packer": {
                    JsonArray itemsArray = new JsonArray();
                    for (File file : PMS.get().debugPacker().getFiles()) {
                        JsonObject fileObject = new JsonObject();
                        fileObject.addProperty("name", file.getName());
                        fileObject.addProperty("path", file.getAbsolutePath());
                        fileObject.addProperty("exists", file.exists());
                        itemsArray.add(fileObject);
                    }
                    LogsApiServlet.respond(req, resp, itemsArray.toString(), 200, "application/json", false);
                    break;
                }
                default: {
                    LOGGER.trace("LogsApiServlet request not available : {}", (Object)path);
                    LogsApiServlet.respondNotFound(req, resp);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in LogsApiServlet: {}", (Object)e.getMessage());
            LogsApiServlet.respondInternalServerError(req, resp);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Account account = AuthService.getAccountLoggedIn(req);
        if (account == null) {
            LogsApiServlet.respondUnauthorized(req, resp);
            return;
        }
        if (!account.havePermission(2048)) {
            LogsApiServlet.respondForbidden(req, resp);
            return;
        }
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/packer": {
                    JsonObject data = LogsApiServlet.getJsonObjectFromBody(req);
                    if (!data.has("items")) {
                        LogsApiServlet.respondBadRequest(req, resp);
                        return;
                    }
                    ArrayList<String> items = new ArrayList<String>();
                    for (Object item : data.getAsJsonArray("items")) {
                        items.add(((JsonElement)item).getAsString());
                    }
                    ArrayList<File> files = new ArrayList<File>();
                    for (File file : PMS.get().debugPacker().getFiles()) {
                        if (!items.contains(file.getAbsolutePath())) continue;
                        files.add(file);
                    }
                    if (files.isEmpty()) {
                        LogsApiServlet.respondBadRequest(req, resp);
                        return;
                    }
                    resp.setContentType("application/zip");
                    resp.setHeader("Accept-Ranges", "bytes");
                    resp.setHeader("Server", MediaServer.getServerName());
                    resp.setHeader("Connection", "keep-alive");
                    resp.setHeader("Transfer-Encoding", "chunked");
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"ums_dbg_" + dateFormat.format(new Date()) + ".zip\"");
                    AsyncContext async = req.startAsync();
                    try (ZipOutputStream zos = new ZipOutputStream(async.getResponse().getOutputStream());){
                        for (File file : files) {
                            LOGGER.debug("Packing {}", (Object)file.getAbsolutePath());
                            DbgPacker.writeToZip(zos, file);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error packing zip file: {}", (Object)e.getLocalizedMessage());
                    }
                    async.complete();
                    return;
                }
            }
            LOGGER.trace("LogsApiServlet request not available : {}", (Object)path);
            LogsApiServlet.respondNotFound(req, resp);
            return;
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in LogsApiServlet: {}", (Object)e.getMessage());
            LogsApiServlet.respondInternalServerError(req, resp);
        }
    }

    private static JsonArray getLogLines() {
        String[] logLines = GuiManager.getLogLines();
        return LogsApiServlet.getJsonArrayFromStringArray(logLines);
    }
}

