/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.ToNumberPolicy;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.pms.network.webguiserver.WebSocketSession;
import net.pms.network.webguiserver.servlets.SettingsApiServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketDispatcher.class);
    private static final Map<String, WebSocketSession> WS_SESSIONS = Collections.synchronizedMap(new HashMap());
    private static final List<String> ABOUT_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> ACCOUNT_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> HOME_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> LOGS_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> PLAYER_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> SETTINGS_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final List<String> SHARED_SESSIONS = Collections.synchronizedList(new LinkedList());
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy(ToNumberPolicy.LONG_OR_DOUBLE).create();
    private static final String ACTION_STRING = "action";
    private static final String DATA_STRING = "data";

    private WebSocketDispatcher() {
    }

    public static void add(Session session) {
        WS_SESSIONS.put(session.getId(), new WebSocketSession(session));
    }

    public static void remove(Session session) {
        WebSocketDispatcher.unsubscribe(session.getId());
        WS_SESSIONS.remove(session.getId());
    }

    public static void onMessage(Session session, String message) {
        JsonObject jsonMessage = WebSocketDispatcher.jsonObjectFromString(message);
        if (jsonMessage == null || !jsonMessage.has(ACTION_STRING) || !jsonMessage.get(ACTION_STRING).isJsonPrimitive()) {
            LOGGER.debug("Error onMessage session '{}' with message '{}'", (Object)session.getId(), (Object)message);
            return;
        }
        String action = jsonMessage.get(ACTION_STRING).getAsString();
        JsonElement data = jsonMessage.get(DATA_STRING);
        switch (action) {
            case "player_status": {
                WebSocketDispatcher.playerStatusHandler(session.getId(), data);
                break;
            }
            case "subscribe": {
                WebSocketDispatcher.subscribeHandler(session.getId(), data);
                break;
            }
            case "token": {
                WebSocketDispatcher.tokenHandler(session.getId(), data);
                break;
            }
            case "uuid": {
                WebSocketDispatcher.uuidHandler(session.getId(), data);
                break;
            }
            default: {
                LOGGER.debug("Unhandled action '{}' for session '{}' with message '{}'", action, session.getId(), message);
            }
        }
    }

    public static void broadcastMessage(String message) {
        for (WebSocketSession session : WS_SESSIONS.values()) {
            try {
                session.sendText(message);
            }
            catch (IOException e) {
                LOGGER.debug("Error broadcasting to '{}' with message : {}", (Object)session.getId(), (Object)message);
                LOGGER.trace("", e);
            }
        }
    }

    public static void broadcastMessageWithPermission(String message, int permission) {
        for (WebSocketSession session : WS_SESSIONS.values()) {
            if (!session.havePermission(permission)) continue;
            try {
                session.sendText(message);
            }
            catch (IOException e) {
                LOGGER.debug("Error broadcasting to '{}' with message : {}", (Object)session.getId(), (Object)message);
                LOGGER.trace("", e);
            }
        }
    }

    public static void broadcastMessageForUser(String message, int id) {
        for (WebSocketSession session : WS_SESSIONS.values()) {
            if (!session.isUserId(id)) continue;
            try {
                session.sendText(message);
            }
            catch (IOException e) {
                LOGGER.debug("Error broadcasting to '{}' with message : {}", (Object)session.getId(), (Object)message);
                LOGGER.trace("", e);
            }
        }
    }

    public static void broadcastAboutMessage(String message) {
        WebSocketDispatcher.broadcastMessage(ABOUT_SESSIONS, message);
    }

    public static void broadcastHomeMessage(String message) {
        WebSocketDispatcher.broadcastMessage(HOME_SESSIONS, message);
    }

    public static void broadcastLogsMessage(String message) {
        WebSocketDispatcher.broadcastMessage(LOGS_SESSIONS, message);
    }

    public static void broadcastSettingsMessage(String message) {
        WebSocketDispatcher.broadcastMessage(SETTINGS_SESSIONS, message);
    }

    public static void broadcastSharedMessage(String message) {
        WebSocketDispatcher.broadcastMessage(SHARED_SESSIONS, message);
    }

    public static boolean hasSession() {
        return !WS_SESSIONS.isEmpty();
    }

    public static boolean hasAboutSession() {
        return !ABOUT_SESSIONS.isEmpty();
    }

    public static boolean hasHomeSession() {
        return !HOME_SESSIONS.isEmpty();
    }

    public static boolean hasLogsSession() {
        return !LOGS_SESSIONS.isEmpty();
    }

    public static boolean hasSettingsSession() {
        return !SETTINGS_SESSIONS.isEmpty();
    }

    public static boolean hasSharedSession() {
        return !SHARED_SESSIONS.isEmpty();
    }

    public static void setRefreshSessions(List<Integer> ids) {
        if (WebSocketDispatcher.hasSession()) {
            for (int id : ids) {
                WebSocketDispatcher.setRefreshSession(id);
            }
        }
    }

    public static void setRefreshSession(int id) {
        WebSocketDispatcher.broadcastMessageForUser("{\"action\":\"refresh_session\"}", id);
    }

    public static void setUpdateAccounts() {
        WebSocketDispatcher.broadcastMessage("{\"action\":\"update_accounts\"}");
    }

    public static void setReloadable(boolean value) {
        WebSocketDispatcher.broadcastMessageWithPermission("{\"action\":\"set_reloadable\",\"data\":" + (value ? "true" : "false") + "}", 1024);
    }

    public static void setConfigurationChanged(String key) {
        if (WebSocketDispatcher.hasSession() && SettingsApiServlet.haveKey(key)) {
            WebSocketDispatcher.broadcastMessageWithPermission(SettingsApiServlet.getConfigurationUpdate(key), 1024);
        }
    }

    public static void setMemoryUsage(int maxMemory, int usedMemory, int dbCacheMemory, int bufferMemory) {
        if (WebSocketDispatcher.hasAboutSession()) {
            String json = "{\"action\":\"update_memory\",\"data\":{\"max\":" + maxMemory + ",\"used\":" + usedMemory + ",\"dbcache\":" + dbCacheMemory + ",\"buffer\":" + bufferMemory + "}}";
            WebSocketDispatcher.broadcastAboutMessage(json);
        }
    }

    public static void setMediaScanStatus(boolean running) {
        WebSocketDispatcher.broadcastMessageWithPermission("{\"action\":\"set_media_scan_status\",\"data\":" + (running ? "true" : "false") + "}", 1024);
    }

    public static void setStatusLine(String line) {
    }

    public static void appendLog(String msg) {
        if (WebSocketDispatcher.hasLogsSession()) {
            JsonObject result = new JsonObject();
            result.addProperty(ACTION_STRING, "log_line");
            result.addProperty(DATA_STRING, msg);
            WebSocketDispatcher.broadcastLogsMessage(result.toString());
        }
    }

    public static void notifyAll(String msgId, String message, String title, String color, boolean autoClose) {
        if (WebSocketDispatcher.hasSession()) {
            JsonObject jsonMessage = new JsonObject();
            jsonMessage.addProperty(ACTION_STRING, "notify");
            JsonObject data = new JsonObject();
            if (!StringUtils.isEmpty(msgId) && !StringUtils.isBlank(msgId)) {
                data.addProperty("id", msgId);
            }
            if (!StringUtils.isEmpty(message)) {
                data.addProperty("message", message);
            }
            if (!StringUtils.isEmpty(title)) {
                data.addProperty("title", title);
            }
            if (!StringUtils.isEmpty(color)) {
                data.addProperty("color", color);
            }
            data.addProperty("autoClose", autoClose);
            jsonMessage.add(DATA_STRING, data);
            WebSocketDispatcher.broadcastMessage(jsonMessage.toString());
        }
    }

    private static void broadcastMessage(List<String> list, String message) {
        Iterator<String> idIterator = list.iterator();
        while (idIterator.hasNext()) {
            String id = idIterator.next();
            WebSocketSession session = WS_SESSIONS.get(id);
            if (session == null) {
                idIterator.remove();
                continue;
            }
            try {
                session.sendText(message);
            }
            catch (IOException e) {
                LOGGER.debug("Error broadcasting to '{}' with message : {}", (Object)id, (Object)message);
                LOGGER.trace("", e);
            }
        }
    }

    private static void unsubscribe(String id) {
        ABOUT_SESSIONS.remove(id);
        ACCOUNT_SESSIONS.remove(id);
        HOME_SESSIONS.remove(id);
        LOGS_SESSIONS.remove(id);
        PLAYER_SESSIONS.remove(id);
        SETTINGS_SESSIONS.remove(id);
        SHARED_SESSIONS.remove(id);
    }

    private static void subscribeHandler(String id, JsonElement data) {
        WebSocketDispatcher.unsubscribe(id);
        String subscribing = null;
        if (data != null && data.isJsonPrimitive()) {
            switch (subscribing = data.getAsString()) {
                case "": {
                    LOGGER.debug("unsubscribing for session '{}'", (Object)id);
                    break;
                }
                case "About": {
                    ABOUT_SESSIONS.add(id);
                    break;
                }
                case "Accounts": {
                    ACCOUNT_SESSIONS.add(id);
                    break;
                }
                case "Home": {
                    HOME_SESSIONS.add(id);
                    break;
                }
                case "Logs": {
                    LOGS_SESSIONS.add(id);
                    break;
                }
                case "Player": {
                    PLAYER_SESSIONS.add(id);
                    break;
                }
                case "ServerSettings": {
                    SETTINGS_SESSIONS.add(id);
                    break;
                }
                case "SharedContent": {
                    SHARED_SESSIONS.add(id);
                    break;
                }
                default: {
                    LOGGER.debug("Unhandled subscribing '{}' for session '{}'", (Object)subscribing, (Object)id);
                }
            }
        }
        WebSocketDispatcher.sessionSubscribe(id, subscribing);
    }

    private static void sessionSubscribe(String id, String subscribing) {
        WebSocketSession session = WS_SESSIONS.get(id);
        if (session == null) {
            return;
        }
        session.setSubscribe(subscribing);
    }

    private static void tokenHandler(String id, JsonElement data) {
        WebSocketSession session = WS_SESSIONS.get(id);
        if (session == null) {
            return;
        }
        String token = null;
        if (data != null && data.isJsonPrimitive()) {
            token = data.getAsString();
        }
        session.setToken(token);
    }

    private static void uuidHandler(String id, JsonElement data) {
        WebSocketSession session = WS_SESSIONS.get(id);
        if (session == null) {
            return;
        }
        String uuid = null;
        if (data != null && data.isJsonPrimitive()) {
            uuid = data.getAsString();
        }
        session.setPlayerUuid(uuid);
    }

    private static void playerStatusHandler(String id, JsonElement data) {
        WebSocketSession session = WS_SESSIONS.get(id);
        if (session == null) {
            return;
        }
        if (data != null) {
            Map status = GSON.fromJson(data, HashMap.class);
            session.setPlayerStatus(status);
        }
    }

    private static JsonObject jsonObjectFromString(String str) {
        JsonObject jObject = null;
        try {
            JsonElement jElem = GSON.fromJson(str, JsonElement.class);
            if (jElem != null && jElem.isJsonObject()) {
                jObject = jElem.getAsJsonObject();
            }
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            // empty catch block
        }
        return jObject;
    }
}

