/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.mdns;

import java.io.IOException;
import java.net.InetAddress;
import javax.jmdns.JmDNS;
import net.pms.PMS;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.mediaserver.mdns.chromecast.ChromecastServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDNS {
    private static final Logger LOGGER = LoggerFactory.getLogger(MDNS.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static JmDNS jmDNS;

    private MDNS() {
    }

    public static boolean start(InetAddress inetAddress) {
        if (jmDNS == null && CONFIGURATION.useChromecastExt()) {
            if (RendererConfigurations.getRendererConfigurationByName("Chromecast") != null) {
                try {
                    LOGGER.info("Starting mDNS service (JmDNS version {}) on host {}", (Object)JmDNS.VERSION, (Object)inetAddress.getHostAddress());
                    jmDNS = JmDNS.create(inetAddress);
                    ChromecastServiceListener.addService(jmDNS);
                    LOGGER.info("mDNS Chromecast service started");
                }
                catch (IOException e) {
                    LOGGER.info("Can't create mDNS Chromecast service: {}", (Object)e.getMessage());
                    LOGGER.trace("The error was: " + String.valueOf(e));
                    return false;
                }
            } else {
                LOGGER.info("No Chromecast renderer found. Please enable one and restart.");
            }
        }
        return true;
    }

    public static void stop() {
        if (jmDNS != null) {
            Object hostname = "";
            try {
                hostname = " on host " + jmDNS.getInetAddress().getHostAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.info("Stopping mDNS service{}", hostname);
            try {
                jmDNS.close();
                LOGGER.info("mDNS service stopped");
            }
            catch (IOException e) {
                LOGGER.debug("mDNS service failed to stop with error: {}", e);
            }
            finally {
                jmDNS = null;
            }
        }
    }
}

