/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import java.io.ByteArrayInputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import net.pms.PMS;
import org.jupnp.http.Headers;
import org.jupnp.model.ServerClientTokens;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.DatagramProcessorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsDatagramProcessor
extends DatagramProcessorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatagramProcessorImpl.class);
    private static final String SERVER_HTTP_TOKEN = new ServerClientTokens("UMS", PMS.getVersion()).getHttpToken();

    @Override
    public IncomingDatagramMessage read(InetAddress receivedOnAddress, DatagramPacket datagram) throws UnsupportedDataException {
        try {
            ByteArrayInputStream is;
            String[] startLine;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Reading message data from: {}:{}\n{}\n{}\n{}", datagram.getAddress(), datagram.getPort(), "===================================== DATAGRAM BEGIN ============================================", new String(datagram.getData()).trim(), "-===================================== DATAGRAM END =============================================");
            }
            if ((startLine = Headers.readLine(is = new ByteArrayInputStream(datagram.getData())).split(" "))[0].startsWith("HTTP/1.")) {
                return this.readResponseMessage(receivedOnAddress, datagram, is, Integer.parseInt(startLine[1]), startLine[2], startLine[0]);
            }
            return this.readRequestMessage(receivedOnAddress, datagram, is, startLine[0], startLine[2]);
        }
        catch (Exception ex) {
            throw new UnsupportedDataException("Could not parse headers: " + String.valueOf(ex), ex, datagram.getData());
        }
    }

    @Override
    public DatagramPacket write(OutgoingDatagramMessage message) throws UnsupportedDataException {
        if (message.getHeaders().containsKey(UpnpHeader.Type.SERVER)) {
            message.getHeaders().set(UpnpHeader.Type.SERVER.getHttpName(), SERVER_HTTP_TOKEN);
        }
        StringBuilder statusLine = new StringBuilder();
        Object operation = message.getOperation();
        if (operation instanceof UpnpRequest) {
            UpnpRequest requestOperation = (UpnpRequest)operation;
            statusLine.append(requestOperation.getHttpMethodName()).append(" * ");
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append("\r\n");
        } else if (operation instanceof UpnpResponse) {
            UpnpResponse responseOperation = (UpnpResponse)operation;
            statusLine.append("HTTP/1.").append(((UpnpOperation)operation).getHttpMinorVersion()).append(" ");
            statusLine.append(responseOperation.getStatusCode()).append(" ").append(responseOperation.getStatusMessage());
            statusLine.append("\r\n");
        } else {
            throw new UnsupportedDataException("Message operation is not request or response, don't know how to process: " + String.valueOf(message));
        }
        StringBuilder messageData = new StringBuilder();
        messageData.append((CharSequence)statusLine);
        messageData.append(message.getHeaders().toString()).append("\r\n");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Writing message data for {} to: {}:{}\n{}\n{}\n{}", message, message.getDestinationAddress(), message.getDestinationPort(), "===================================== DATAGRAM BEGIN ============================================", messageData.toString().substring(0, messageData.length() - 2), "-===================================== DATAGRAM END =============================================");
        }
        byte[] data = messageData.toString().getBytes(StandardCharsets.US_ASCII);
        LOGGER.trace("Writing new datagram packet with " + data.length + " bytes for: " + String.valueOf(message));
        return new DatagramPacket(data, data.length, message.getDestinationAddress(), message.getDestinationPort());
    }
}

