/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.transport.impl;

import jakarta.servlet.Servlet;
import java.io.IOException;
import java.net.InetAddress;
import net.pms.network.mediaserver.jupnp.transport.async.JakartaAsyncServlet;
import net.pms.network.mediaserver.jupnp.transport.impl.JakartaServletStreamServerConfigurationImpl;
import org.jupnp.transport.Router;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaServletStreamServerImpl
implements StreamServer<JakartaServletStreamServerConfigurationImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaServletStreamServerImpl.class);
    protected final JakartaServletStreamServerConfigurationImpl configuration;
    protected int localPort;

    public JakartaServletStreamServerImpl(JakartaServletStreamServerConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public JakartaServletStreamServerConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, Router router) throws InitializationException {
        try {
            LOGGER.debug("Setting executor service on servlet container adapter");
            this.configuration.getServletContainerAdapter().setExecutorService(router.getConfiguration().getStreamServerExecutorService());
            LOGGER.debug("Adding connector: {}:{}", (Object)bindAddress, (Object)this.configuration.getListenPort());
            this.localPort = this.configuration.getServletContainerAdapter().addConnector(bindAddress.getHostAddress(), this.configuration.getListenPort());
            String contextPath = router.getConfiguration().getNamespace().getBasePath().getPath();
            Servlet servlet = this.createAsyncServlet(router);
            this.configuration.getServletContainerAdapter().registerServlet(contextPath, servlet);
        }
        catch (IOException e) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName(), e);
        }
    }

    @Override
    public synchronized int getPort() {
        return this.localPort;
    }

    @Override
    public synchronized void stop() {
        this.configuration.getServletContainerAdapter().stopIfRunning();
    }

    @Override
    public void run() {
        this.configuration.getServletContainerAdapter().startIfNotRunning();
    }

    protected Servlet createAsyncServlet(Router router) {
        return new JakartaAsyncServlet(router, this.configuration);
    }
}

