/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Property;

public class PropertyList {
    private final List<Property<?>> properties = new ArrayList();

    public PropertyList set(Collection<Property<?>> properties) {
        this.properties.clear();
        return this.addAll(properties);
    }

    public List<Property<?>> get() {
        return this.properties;
    }

    public PropertyList addAll(Collection<Property<?>> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties.addAll(properties);
        }
        return this;
    }

    public PropertyList addAll(Property<?>[] properties) {
        if (properties != null && properties.length > 0) {
            for (Property<?> property : properties) {
                this.add(property);
            }
        }
        return this;
    }

    public PropertyList add(Property<?> property) {
        if (property != null) {
            this.properties.add(property);
        }
        return this;
    }

    public PropertyList remove(Class<?> propertyClass) {
        Iterator<Property<?>> it = this.properties.iterator();
        while (it.hasNext()) {
            Property<?> property = it.next();
            if (!propertyClass.equals(property.getClass())) continue;
            it.remove();
        }
        return this;
    }

    public PropertyList set(Property<?> property) {
        if (property != null) {
            this.remove(property.getClass());
            this.add(property);
        }
        return this;
    }

    public <T> T get(Class<T> propertyClass) {
        for (Property<?> property : this.properties) {
            if (!propertyClass.equals(property.getClass())) continue;
            return (T)property;
        }
        return null;
    }

    public <T> List<T> getAll(Class<T> propertyClass) {
        ArrayList list = new ArrayList();
        for (Property<?> property : this.properties) {
            if (!propertyClass.equals(property.getClass())) continue;
            list.add(property);
        }
        return list;
    }

    public <V> Property<V>[] getPropertiesInstanceOf(Class<?> baseClass) {
        ArrayList list = new ArrayList();
        for (Property<?> property : this.properties) {
            if (!baseClass.isInstance(property)) continue;
            list.add(property);
        }
        return (Property[])list.toArray(Property[]::new);
    }

    public boolean hasProperty(Class<?> propertyClass) {
        for (Property<?> property : this.properties) {
            if (!propertyClass.equals(property.getClass())) continue;
            return true;
        }
        return false;
    }

    public <V> V getValue(Class<? extends Property<V>> propertyClass) {
        for (Property<?> property : this.properties) {
            if (!propertyClass.equals(property.getClass())) continue;
            return (V)property.getValue();
        }
        return null;
    }

    public <V> List<V> getValues(Class<? extends Property<V>> propertyClass) {
        ArrayList<V> list = new ArrayList<V>();
        for (Property<V> property : this.getAll(propertyClass)) {
            list.add(property.getValue());
        }
        return list;
    }
}

