/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.Result;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.BaseObject;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Desc;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Album;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.GenreContainer;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MovieGenre;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicAlbum;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicArtist;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicGenre;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Person;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.PhotoAlbum;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.PlaylistContainer;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.StorageFolder;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.StorageSystem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.StorageVolume;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.AudioBook;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.AudioBroadcast;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.AudioItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.BookmarkItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.ImageItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Movie;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.MusicTrack;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.MusicVideoClip;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Photo;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.PlaylistItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.TextItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.VideoBroadcast;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.VideoItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.WriteStatusValue;
import org.jupnp.model.types.Datatype;
import org.jupnp.model.types.InvalidValueException;
import org.jupnp.support.model.ProtocolInfo;
import org.jupnp.util.io.IO;
import org.jupnp.xml.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Parser
extends SAXParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);

    public Result parseResource(String resource) throws Exception {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);){
            Result result = this.parse(IO.readLines(is));
            return result;
        }
    }

    public Result parse(String xml) throws Exception {
        if (xml == null || xml.length() == 0) {
            throw new RuntimeException("Null or empty XML");
        }
        Result content = new Result();
        this.createRootHandler(content, this);
        LOGGER.trace("Parsing DIDL XML content");
        this.parse(new InputSource(new StringReader(xml)));
        return content;
    }

    protected ResultHandler createRootHandler(Result instance, SAXParser parser) {
        return new ResultHandler(instance, parser);
    }

    protected ContainerHandler createContainerHandler(Container instance, SAXParser.Handler<?> parent) {
        return new ContainerHandler(instance, parent);
    }

    protected ItemHandler createItemHandler(Item instance, SAXParser.Handler<?> parent) {
        return new ItemHandler(instance, parent);
    }

    protected ResHandler createResHandler(Res instance, SAXParser.Handler<?> parent) {
        return new ResHandler(instance, parent);
    }

    protected DescHandler createDescHandler(Desc instance, SAXParser.Handler<?> parent) {
        return new DescHandler(instance, parent);
    }

    protected Container createContainer(Attributes attributes) {
        Container container = new Container();
        container.setId(attributes.getValue("id"));
        container.setParentID(attributes.getValue("parentID"));
        if (attributes.getValue("childCount") != null) {
            container.setChildCount(Long.valueOf(attributes.getValue("childCount")));
        }
        try {
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                container.setRestricted(value);
            }
            if ((value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("searchable"))) != null) {
                container.setSearchable(value);
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return container;
    }

    protected Item createItem(Attributes attributes) {
        Item item = new Item();
        item.setId(attributes.getValue("id"));
        item.setParentID(attributes.getValue("parentID"));
        try {
            Boolean value = (Boolean)Datatype.Builtin.BOOLEAN.getDatatype().valueOf(attributes.getValue("restricted"));
            if (value != null) {
                item.setRestricted(value);
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        if (attributes.getValue("refID") != null) {
            item.setRefID(attributes.getValue("refID"));
        }
        return item;
    }

    protected Res createResource(Attributes attributes) {
        Res res = new Res();
        if (attributes.getValue("importUri") != null) {
            res.setImportUri(URI.create(attributes.getValue("importUri")));
        }
        try {
            res.setProtocolInfo(new ProtocolInfo(attributes.getValue("protocolInfo")));
        }
        catch (InvalidValueException ex) {
            LOGGER.warn("In DIDL content, invalid resource protocol info: " + ex.getMessage());
            return null;
        }
        if (attributes.getValue("size") != null) {
            res.setSize(UnsignedLong.valueOf(attributes.getValue("size")));
        }
        if (attributes.getValue("duration") != null) {
            res.setDuration(attributes.getValue("duration"));
        }
        if (attributes.getValue("bitrate") != null) {
            res.setBitrate(UnsignedInteger.valueOf(attributes.getValue("bitrate")));
        }
        if (attributes.getValue("sampleFrequency") != null) {
            res.setSampleFrequency(UnsignedInteger.valueOf(attributes.getValue("sampleFrequency")));
        }
        if (attributes.getValue("bitsPerSample") != null) {
            res.setBitsPerSample(UnsignedInteger.valueOf(attributes.getValue("bitsPerSample")));
        }
        if (attributes.getValue("nrAudioChannels") != null) {
            res.setNrAudioChannels(UnsignedInteger.valueOf(attributes.getValue("nrAudioChannels")));
        }
        if (attributes.getValue("colorDepth") != null) {
            res.setColorDepth(UnsignedInteger.valueOf(attributes.getValue("colorDepth")));
        }
        if (attributes.getValue("protection") != null) {
            res.setProtection(attributes.getValue("protection"));
        }
        if (attributes.getValue("resolution") != null) {
            res.setResolution(attributes.getValue("resolution"));
        }
        return res;
    }

    protected Desc createDescription(Attributes attributes) {
        Desc desc = new Desc();
        desc.setId(attributes.getValue("id"));
        if (attributes.getValue("type") != null) {
            desc.setType(attributes.getValue("type"));
        }
        if (attributes.getValue("nameSpace") != null) {
            desc.setNameSpace(attributes.getValue("nameSpace"));
        }
        return desc;
    }

    protected Item enhanceItem(Item item) {
        String genericType = item.getUpnpClassName();
        if (null == genericType) {
            return item;
        }
        return switch (genericType) {
            case "object.item" -> item;
            case "object.item.audioItem" -> (AudioItem)item;
            case "object.item.audioItem.musicTrack" -> (MusicTrack)item;
            case "object.item.audioItem.audioBook" -> (AudioBook)item;
            case "object.item.audioItem.audioBroadcast" -> (AudioBroadcast)item;
            case "object.item.bookmarkItem" -> (BookmarkItem)item;
            case "object.item.imageItem" -> (ImageItem)item;
            case "object.item.imageItem.photo" -> (Photo)item;
            case "object.item.playlistItem" -> (PlaylistItem)item;
            case "object.item.textItem" -> (TextItem)item;
            case "object.item.videoItem" -> (VideoItem)item;
            case "object.item.videoItem.movie" -> (Movie)item;
            case "object.item.videoItem.musicVideoClip" -> (MusicVideoClip)item;
            case "object.item.videoItem.videoBroadcast" -> (VideoBroadcast)item;
            default -> item;
        };
    }

    protected Container enhanceContainer(Container container) {
        String genericType = container.getUpnpClassName();
        if (genericType == null) {
            return container;
        }
        return switch (genericType) {
            case "object.container" -> container;
            case "object.container.album" -> (Album)container;
            case "object.container.album.musicAlbum" -> (MusicAlbum)container;
            case "object.container.album.photoAlbum" -> (PhotoAlbum)container;
            case "object.container.genre" -> (GenreContainer)container;
            case "object.container.genre.movieGenre" -> (MovieGenre)container;
            case "object.container.genre.musicGenre" -> (MusicGenre)container;
            case "object.container.person" -> (Person)container;
            case "object.container.person.musicArtist" -> (MusicArtist)container;
            case "object.container.playlistContainer" -> (PlaylistContainer)container;
            case "object.container.storageFolder" -> (StorageFolder)container;
            case "object.container.storageSystem" -> (StorageSystem)container;
            case "object.container.storageVolume" -> (StorageVolume)container;
            default -> container;
        };
    }

    public class ResultHandler
    extends SAXParser.Handler<Result> {
        ResultHandler(Result instance, SAXParser parser) {
            super(instance, parser);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            switch (localName) {
                case "container": {
                    Container container = Parser.this.createContainer(attributes);
                    ((Result)this.getInstance()).addContainer(container);
                    Parser.this.createContainerHandler(container, this);
                    break;
                }
                case "item": {
                    Item item = Parser.this.createItem(attributes);
                    ((Result)this.getInstance()).addItem(item);
                    Parser.this.createItemHandler(item, this);
                    break;
                }
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "DIDL-Lite".equals(localName);
        }
    }

    public class ContainerHandler
    extends DIDLObjectHandler<Container> {
        public ContainerHandler(Container instance, SAXParser.Handler<?> parent) {
            super(Parser.this, (BaseObject)instance, parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            switch (localName) {
                case "desc": {
                    Desc desc = Parser.this.createDescription(attributes);
                    if (desc == null) break;
                    ((Container)this.getInstance()).addDescription(desc);
                    Parser.this.createDescHandler(desc, this);
                    break;
                }
                case "res": {
                    Res res = Parser.this.createResource(attributes);
                    if (res == null) break;
                    ((Container)this.getInstance()).addResource(res);
                    Parser.this.createResHandler(res, this);
                    break;
                }
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "container".equals(localName)) {
                if (((Container)this.getInstance()).getTitle() == null) {
                    LOGGER.warn("In DIDL content, missing 'dc:title' element for container: " + ((Container)this.getInstance()).getId());
                }
                if (((Container)this.getInstance()).getUpnpClassName() == null) {
                    LOGGER.warn("In DIDL content, missing 'upnp:class' element for container: " + ((Container)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    public class ItemHandler
    extends DIDLObjectHandler<Item> {
        public ItemHandler(Item instance, SAXParser.Handler<?> parent) {
            super(Parser.this, (BaseObject)instance, parent);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Desc desc;
            super.startElement(uri, localName, qName, attributes);
            if (!"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri)) {
                return;
            }
            if (localName.equals("res")) {
                Res res = Parser.this.createResource(attributes);
                if (res != null) {
                    ((Item)this.getInstance()).addResource(res);
                    Parser.this.createResHandler(res, this);
                }
            } else if (localName.equals("desc") && (desc = Parser.this.createDescription(attributes)) != null) {
                ((Item)this.getInstance()).addDescription(desc);
                Parser.this.createDescHandler(desc, this);
            }
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            if ("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "item".equals(localName)) {
                if (((Item)this.getInstance()).getTitle() == null) {
                    LOGGER.warn("In DIDL content, missing 'dc:title' element for item: " + ((Item)this.getInstance()).getId());
                }
                if (((Item)this.getInstance()).getUpnpClassName() == null) {
                    LOGGER.warn("In DIDL content, missing 'upnp:class' element for item: " + ((Item)this.getInstance()).getId());
                }
                return true;
            }
            return false;
        }
    }

    protected class ResHandler
    extends SAXParser.Handler<Res> {
        public ResHandler(Res instance, SAXParser.Handler<?> parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "res".equals(localName);
        }
    }

    public class DescHandler
    extends SAXParser.Handler<Desc> {
        public DescHandler(Desc instance, SAXParser.Handler<?> parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
        }

        @Override
        protected boolean isLastElement(String uri, String localName, String qName) {
            return "urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/".equals(uri) && "desc".equals(localName);
        }
    }

    public static abstract class DIDLObjectHandler<I extends BaseObject>
    extends SAXParser.Handler<I> {
        final /* synthetic */ Parser this$0;

        protected DIDLObjectHandler(I instance, SAXParser.Handler<?> parent) {
            this.this$0 = this$0;
            super(instance, parent);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (localName == null) {
                return;
            }
            if ("http://purl.org/dc/elements/1.1/".equals(uri)) {
                switch (localName) {
                    case "title": {
                        ((BaseObject)this.getInstance()).setTitle(this.getCharacters());
                        break;
                    }
                    case "creator": {
                        ((BaseObject)this.getInstance()).setCreator(this.getCharacters());
                        break;
                    }
                    case "description": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Description(this.getCharacters()));
                        break;
                    }
                    case "publisher": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Publisher(this.getCharacters()));
                        break;
                    }
                    case "contributor": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Contributor(this.getCharacters()));
                        break;
                    }
                    case "date": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Date(this.getCharacters()));
                        break;
                    }
                    case "language": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Language(this.getCharacters()));
                        break;
                    }
                    case "rights": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Rights(this.getCharacters()));
                        break;
                    }
                    case "relation": {
                        ((BaseObject)this.getInstance()).getProperties().add(new DC.Relation(URI.create(this.getCharacters())));
                        break;
                    }
                }
            } else if ("urn:schemas-upnp-org:metadata-1-0/upnp/".equals(uri)) {
                switch (localName) {
                    case "writeStatus": {
                        try {
                            ((BaseObject)this.getInstance()).setWriteStatus(WriteStatusValue.valueOf(this.getCharacters()));
                        }
                        catch (Exception ex) {
                            LOGGER.info("Ignoring invalid writeStatus value: " + this.getCharacters());
                        }
                        break;
                    }
                    case "class": {
                        ((BaseObject)this.getInstance()).setUpnpClass(new UPNP.Class(this.getCharacters(), this.getAttributes().getValue("name")));
                        break;
                    }
                    case "artist": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Artist(this.getCharacters(), this.getAttributes().getValue("role")));
                        break;
                    }
                    case "actor": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Actor(this.getCharacters(), this.getAttributes().getValue("role")));
                        break;
                    }
                    case "author": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Author(this.getCharacters(), this.getAttributes().getValue("role")));
                        break;
                    }
                    case "producer": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Producer(this.getCharacters()));
                        break;
                    }
                    case "director": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Director(this.getCharacters()));
                        break;
                    }
                    case "longDescription": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.LongDescription(this.getCharacters()));
                        break;
                    }
                    case "storageUsed": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.StorageUsed(Long.valueOf(this.getCharacters())));
                        break;
                    }
                    case "storageTotal": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.StorageTotal(Long.valueOf(this.getCharacters())));
                        break;
                    }
                    case "storageFree": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.StorageFree(Long.valueOf(this.getCharacters())));
                        break;
                    }
                    case "storageMaxPartition": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.StorageMaxPartition(Long.valueOf(this.getCharacters())));
                        break;
                    }
                    case "storageMedium": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.StorageMedium(this.getCharacters()));
                        break;
                    }
                    case "genre": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Genre(this.getCharacters()));
                        break;
                    }
                    case "album": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Album(this.getCharacters()));
                        break;
                    }
                    case "playlist": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Playlist(this.getCharacters()));
                        break;
                    }
                    case "region": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Region(this.getCharacters()));
                        break;
                    }
                    case "rating": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Rating(this.getCharacters()));
                        break;
                    }
                    case "toc": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Toc(this.getCharacters()));
                        break;
                    }
                    case "albumArtURI": {
                        UPNP.AlbumArtURI albumArtURI = new UPNP.AlbumArtURI(URI.create(this.getCharacters()));
                        Attributes albumArtURIAttributes = this.getAttributes();
                        for (int i = 0; i < albumArtURIAttributes.getLength(); ++i) {
                            if (!"profileID".equals(albumArtURIAttributes.getLocalName(i))) continue;
                            albumArtURI.setProfileID(albumArtURIAttributes.getValue(i));
                        }
                        ((BaseObject)this.getInstance()).getProperties().add(albumArtURI);
                        break;
                    }
                    case "artistDiscographyURI": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.ArtistDiscographyURI(URI.create(this.getCharacters())));
                        break;
                    }
                    case "lyricsURI": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.LyricsURI(URI.create(this.getCharacters())));
                        break;
                    }
                    case "icon": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.Icon(URI.create(this.getCharacters())));
                        break;
                    }
                    case "radioCallSign": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.RadioCallSign(this.getCharacters()));
                        break;
                    }
                    case "radioStationID": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.RadioStationID(this.getCharacters()));
                        break;
                    }
                    case "radioBand": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.RadioBand(this.getCharacters()));
                        break;
                    }
                    case "channelNr": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.ChannelNr(Integer.valueOf(this.getCharacters())));
                        break;
                    }
                    case "channelName": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.ChannelName(this.getCharacters()));
                        break;
                    }
                    case "scheduledStartTime": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.ScheduledStartTime(this.getCharacters()));
                        break;
                    }
                    case "scheduledEndTime": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.ScheduledEndTime(this.getCharacters()));
                        break;
                    }
                    case "DVDRegionCode": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.DVDRegionCode(Integer.valueOf(this.getCharacters())));
                        break;
                    }
                    case "originalTrackNumber": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.OriginalTrackNumber(Integer.valueOf(this.getCharacters())));
                        break;
                    }
                    case "userAnnotation": {
                        ((BaseObject)this.getInstance()).getProperties().add(new UPNP.UserAnnotation(this.getCharacters()));
                        break;
                    }
                    default: {
                        LOGGER.warn("In DIDL content, missing 'upnp:{}' element with value: {}", (Object)localName, (Object)this.getCharacters());
                    }
                }
            }
        }
    }
}

