/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.model.meta;

import java.net.URI;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.mediaserver.jupnp.model.meta.UmsRemoteClientInfo;
import net.pms.util.PropertiesUtil;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.profile.DeviceDetailsProvider;
import org.jupnp.model.profile.RemoteClientInfo;
import org.jupnp.model.types.DLNACaps;
import org.jupnp.model.types.DLNADoc;

public class UmsDeviceDetailsProvider
implements DeviceDetailsProvider {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String MANUFACTURER_NAME = "Universal Media Server";
    private static final String MANUFACTURER_URL = "https://www.universalmediaserver.com/";
    private static final ManufacturerDetails MANUFACTURER_DETAILS = new ManufacturerDetails("Universal Media Server", "https://www.universalmediaserver.com/");
    private static final String MODEL_NUMBER = PropertiesUtil.getProjectProperties().get("project.version");
    private static final DLNADoc[] DLNA_DOCS = new DLNADoc[]{new DLNADoc("DMS", DLNADoc.Version.V1_5), new DLNADoc("M-DMS", DLNADoc.Version.V1_5)};
    private static final DLNACaps DLNA_CAPS = new DLNACaps(new String[0]);
    private static final DLNACaps SEC_CAP = new DLNACaps(new String[]{"smi", "DCM10", "getMediaInfo.sec", "getCaptionInfo.sec"});

    @Override
    public DeviceDetails provide(RemoteClientInfo info) {
        UmsRemoteClientInfo umsinfo = new UmsRemoteClientInfo(info);
        Object friendlyName = CONFIGURATION.getServerDisplayName();
        if (umsinfo.isXbox360Request()) {
            friendlyName = (String)friendlyName + " : Windows Media Connect";
        }
        String modelName = umsinfo.isXbox360Request() ? "Windows Media Connect" : PMS.NAME;
        String modelDescription = CONFIGURATION.getServerName() + " - UPnP/AV 1.0 Compliant Media Server";
        String modelNumber = umsinfo.isXbox360Request() ? "1" : MODEL_NUMBER;
        ModelDetails modelDetails = new ModelDetails(modelName, modelDescription, modelNumber, MANUFACTURER_URL);
        URI presentationURI = null;
        if (umsinfo.getLocalAddress() != null) {
            String webInterfaceUrl = "http" + (CONFIGURATION.getWebPlayerHttps() ? "s" : "") + "://" + umsinfo.getLocalAddress().getHostAddress() + ":" + CONFIGURATION.getWebPlayerServerPort();
            presentationURI = URI.create(webInterfaceUrl);
        }
        return new DeviceDetails(null, (String)friendlyName, MANUFACTURER_DETAILS, modelDetails, null, null, presentationURI, DLNA_DOCS, DLNA_CAPS, SEC_CAP);
    }
}

