/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.controlpoint;

import net.pms.renderers.JUPnPDeviceHelper;
import org.jupnp.controlpoint.SubscriptionCallback;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.GENASubscription;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsSubscriptionCallback
extends SubscriptionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsSubscriptionCallback.class);
    private final String uuid;

    public UmsSubscriptionCallback(Service s) {
        super(s);
        this.uuid = ((DeviceIdentity)((Device)s.getDevice()).getIdentity()).getUdn().getIdentifierString();
    }

    @Override
    public void eventReceived(GENASubscription subscription) {
        JUPnPDeviceHelper.markRenderer(this.uuid, 0, true);
        if (subscription.getCurrentValues().containsKey("LastChange")) {
            JUPnPDeviceHelper.xml2d(this.uuid, ((Object)subscription.getCurrentValues().get("LastChange")).toString(), null);
        }
    }

    @Override
    public void established(GENASubscription sub) {
        LOGGER.debug("Subscription established: {} on {}", (Object)((Service)sub.getService()).getServiceId().getId(), (Object)JUPnPDeviceHelper.getFriendlyName(this.uuid));
    }

    @Override
    public void failed(GENASubscription sub, UpnpResponse response, Exception ex, String defaultMsg) {
        LOGGER.debug("Subscription failed: {} on {}: {}", ((Service)sub.getService()).getServiceId().getId(), JUPnPDeviceHelper.getFriendlyName(this.uuid), defaultMsg.split(": ", 2)[1]);
    }

    @Override
    public void failed(GENASubscription sub, UpnpResponse response, Exception ex) {
        LOGGER.debug("Subscription failed: {} on {}: {}", ((Service)sub.getService()).getServiceId().getId(), JUPnPDeviceHelper.getFriendlyName(this.uuid), SubscriptionCallback.createDefaultFailureMessage(response, ex).split(": ", 2)[1]);
    }

    @Override
    public void ended(GENASubscription sub, CancelReason reason, UpnpResponse response) {
        if (reason != null) {
            LOGGER.debug("Subscription cancelled: {} on {}: {}", new Object[]{((Service)sub.getService()).getServiceId().getId(), this.uuid, reason});
        }
        JUPnPDeviceHelper.markRenderer(this.uuid, 2, true);
    }

    @Override
    public void eventsMissed(GENASubscription sub, int numberOfMissedEvents) {
        LOGGER.debug("Missed events: {} for subscription {} on {}", numberOfMissedEvents, ((Service)sub.getService()).getServiceId().getId(), JUPnPDeviceHelper.getFriendlyName(this.uuid));
    }
}

