/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.handlers.nextcpapi;

import java.nio.charset.StandardCharsets;
import net.pms.network.mediaserver.handlers.nextcpapi.FolderScanner;
import net.pms.network.mediaserver.handlers.nextcpapi.LikeMusic;
import net.pms.network.mediaserver.handlers.nextcpapi.NextcpApiResponseHandler;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNextcpApiHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractNextcpApiHandler.class);

    protected AbstractNextcpApiHandler() {
    }

    public static boolean validApiKeyPresent(String nextcpApiKey, String givenApiKey) {
        boolean result = true;
        try {
            byte[] givenApiKeyHash = DigestUtils.sha256(givenApiKey.getBytes(StandardCharsets.UTF_8));
            byte[] nextcpApiKeyHash = DigestUtils.sha256(nextcpApiKey.getBytes(StandardCharsets.UTF_8));
            int pos = 0;
            for (byte b : nextcpApiKeyHash) {
                result = result && b == givenApiKeyHash[pos++];
            }
            LOGGER.debug("validApiKeyPresent : " + result);
            return result;
        }
        catch (RuntimeException e) {
            LOGGER.error("cannot hash api key", e);
            return false;
        }
    }

    public static NextcpApiResponseHandler getApiResponseHandler(String apiType) {
        switch (apiType) {
            case "folderscanner": {
                return new FolderScanner();
            }
            case "like": {
                return new LikeMusic();
            }
        }
        throw new RuntimeException("No nextcp api Handler found");
    }
}

