/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.platform.IPlatformUtils;
import net.pms.platform.PlatformUtils;
import net.pms.util.SimpleThreadFactory;
import net.pms.util.UMSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedStats {
    private static final ExecutorService BACKGROUND_EXECUTOR = Executors.newCachedThreadPool(new SimpleThreadFactory("SpeedStats background worker", "SpeedStats background workers group", 5));
    private static final Logger LOGGER;
    private static final Map<String, Future<Integer>> SPEED_STATS;

    private SpeedStats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<Integer> getSpeedInMBitsStored(InetAddress addr) {
        Map<String, Future<Integer>> map = SPEED_STATS;
        synchronized (map) {
            return SPEED_STATS.get(addr.getHostAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<Integer> getSpeedInMBits(InetAddress addr, String rendererName) {
        Map<String, Future<Integer>> map = SPEED_STATS;
        synchronized (map) {
            Future<Integer> value = SPEED_STATS.get(addr.getHostAddress());
            if (value != null) {
                return value;
            }
            value = BACKGROUND_EXECUTOR.submit(new MeasureSpeed(addr, rendererName));
            SPEED_STATS.put(addr.getHostAddress(), value);
            return value;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("SpeedStats Executor Shutdown Hook"){

            @Override
            public void run() {
                BACKGROUND_EXECUTOR.shutdownNow();
            }
        });
        LOGGER = LoggerFactory.getLogger(SpeedStats.class);
        SPEED_STATS = new HashMap<String, Future<Integer>>();
    }

    private static class MeasureSpeed
    implements Callable<Integer> {
        private final InetAddress addr;
        private final String rendererName;

        public MeasureSpeed(InetAddress addr, String rendererName) {
            this.addr = addr;
            this.rendererName = rendererName != null ? rendererName.replaceAll("\n", "") : "Unknown";
        }

        @Override
        public Integer call() throws Exception {
            try {
                return this.doCall();
            }
            catch (Exception e) {
                LOGGER.warn("Error measuring network throughput : " + e.getMessage(), e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer doCall() throws Exception {
            String ip = this.addr.getHostAddress();
            LOGGER.info("Checking IP: {} for {}", (Object)ip, (Object)this.rendererName);
            String hostname = this.addr.getCanonicalHostName();
            Map<String, Future<Integer>> map = SPEED_STATS;
            synchronized (map) {
                Future<Integer> otherTask = SPEED_STATS.get(hostname);
                if (otherTask != null) {
                    try {
                        Integer value = otherTask.get(200L, TimeUnit.MILLISECONDS);
                        if (value != null) {
                            return value;
                        }
                    }
                    catch (TimeoutException e) {
                        LOGGER.trace("We couldn't get the value based on the canonical name");
                    }
                }
            }
            if (!ip.equals(hostname)) {
                LOGGER.info("Renderer {} found on address: {} ({})", this.rendererName, hostname, ip);
            } else {
                LOGGER.info("Renderer {} found on address: {}", (Object)this.rendererName, (Object)ip);
            }
            int[] sizes = new int[]{512, 1476, 9100, 32000, 64000};
            double bps = 0.0;
            int cnt = 0;
            for (int i = 0; i < sizes.length; ++i) {
                double p = this.doPing(sizes[i]);
                if (p == 0.0) continue;
                bps += p;
                ++cnt;
            }
            double speedInMbits1 = bps / (double)(cnt * 1000000);
            LOGGER.info("Renderer {} has an estimated network speed of {} Mb/s", (Object)this.rendererName, (Object)speedInMbits1);
            int speedInMbits = (int)speedInMbits1;
            if (speedInMbits1 < 1.0) {
                speedInMbits = -1;
            }
            Map<String, Future<Integer>> map2 = SPEED_STATS;
            synchronized (map2) {
                CompletedFuture<Integer> result = new CompletedFuture<Integer>(speedInMbits);
                SPEED_STATS.put(ip, result);
                SPEED_STATS.put(hostname, result);
            }
            return speedInMbits;
        }

        private double doPing(int size) {
            OutputParams op = new OutputParams(null);
            op.setLog(true);
            op.setMaxBufferSize(1.0);
            IPlatformUtils sysUtil = PlatformUtils.INSTANCE;
            ProcessWrapperImpl pw = new ProcessWrapperImpl(sysUtil.getPingCommand(this.addr.getHostAddress(), 5, size), op, true, false);
            Runnable r = () -> {
                UMSUtils.sleep(3000);
                pw.stopProcess();
            };
            Thread failsafe = new Thread(r, "SpeedStats Failsafe");
            failsafe.start();
            pw.runInSameThread();
            List<String> ls = pw.getOtherResults();
            double time = 0.0;
            int c = 0;
            for (String line : ls) {
                String timeString = sysUtil.parsePingLine(line);
                if (timeString == null) continue;
                try {
                    time += Double.parseDouble(timeString);
                    ++c;
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Could not estimate network speed from time: \"" + timeString + "\"");
                }
            }
            if (c > 0) {
                int frags = sysUtil.getPingPacketFragments(size);
                LOGGER.debug("Estimated speed from ICMP packet size {} in {} fragment(s) is {} bit/s", size, frags, (double)((size + 8 + frags * 32) * 8000 * 2) / (time /= (double)c));
                return (double)((size + 8 + frags * 32) * 8000 * 2) / time;
            }
            return time;
        }
    }

    static class CompletedFuture<X>
    implements Future<X> {
        X value;

        public CompletedFuture(X value) {
            this.value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public X get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        @Override
        public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }
}

