/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.pms.dlna.DLNAThumbnail;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.Format;
import net.pms.formats.audio.M4A;
import net.pms.formats.audio.MKA;
import net.pms.formats.audio.MP3;
import net.pms.formats.audio.OGA;
import net.pms.formats.audio.RA;
import net.pms.formats.audio.THREEG2A;
import net.pms.formats.audio.THREEGA;
import net.pms.formats.audio.WMA;
import net.pms.image.ImageInfo;
import net.pms.media.MediaType;
import net.pms.media.audio.MediaAudio;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.media.chapter.MediaChapter;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.StringUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;

public class MediaInfo
implements Cloneable {
    public static final long ENDFILE_POS = 99999475712L;
    protected static final Map<String, AudioVariantInfo> AUDIO_OR_VIDEO_CONTAINERS = MediaInfo.getAudioOrVideoContainers();
    private final AtomicBoolean parsing = new AtomicBoolean(false);
    private Long fileId;
    private String resourceId;
    private String lastParser;
    private Double durationSec;
    private int bitrate;
    private long size;
    private Double frameRate;
    private String container;
    private String title;
    private String aspectRatioDvdIso;
    private Long thumbnailId = null;
    private ThumbnailSource thumbnailSource = ThumbnailSource.UNKNOWN;
    private MediaVideoMetadata videoMetadata;
    private MediaAudioMetadata audioMetadata;
    private int imageCount = 0;
    private volatile ImageInfo imageInfo = null;
    private MediaVideo defaultVideoTrack;
    private MediaAudio defaultAudioTrack;
    private List<MediaVideo> videoTracks = new ArrayList<MediaVideo>();
    private List<MediaAudio> audioTracks = new ArrayList<MediaAudio>();
    private List<MediaSubtitle> subtitleTracks = new ArrayList<MediaSubtitle>();
    private List<MediaChapter> chapters = new ArrayList<MediaChapter>();
    private String mimeType;
    private Integer dvdtrack;
    private long lastExternalLookup = 0L;

    public void resetParser() {
        this.lastParser = null;
        this.defaultAudioTrack = null;
        this.defaultVideoTrack = null;
        this.videoTracks.clear();
        this.audioTracks.clear();
        this.subtitleTracks.clear();
        this.chapters.clear();
        this.imageInfo = null;
        this.imageCount = 0;
    }

    public Long getFileId() {
        return this.fileId;
    }

    public void setFileId(Long value) {
        this.fileId = value;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String value) {
        this.resourceId = value;
    }

    public int getVideoTrackCount() {
        return this.videoTracks.size();
    }

    public int getAudioTrackCount() {
        return this.audioTracks.size();
    }

    public int getSubtitleTrackCount() {
        return this.subtitleTracks.size();
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int value) {
        this.imageCount = value;
    }

    public int getSubTrackCount() {
        return this.subtitleTracks.size();
    }

    public boolean isVideo() {
        return MediaType.VIDEO == this.getMediaType();
    }

    public boolean isAudio() {
        return MediaType.AUDIO == this.getMediaType();
    }

    public boolean hasAudio() {
        return this.defaultAudioTrack != null;
    }

    public boolean isSLS() {
        return this.audioTracks.size() == 2 && (this.audioTracks.get(0).isAACLC() || this.audioTracks.get(0).isERBSAC()) && this.audioTracks.get(1).isSLS();
    }

    public MediaType getMediaType() {
        if (this.defaultVideoTrack != null) {
            return MediaType.VIDEO;
        }
        int audioTracksSize = this.audioTracks.size();
        if (audioTracksSize == 0 && this.imageCount > 0) {
            return MediaType.IMAGE;
        }
        if (audioTracksSize == 1 || this.isSLS()) {
            return MediaType.AUDIO;
        }
        return MediaType.UNKNOWN;
    }

    public boolean isImage() {
        return MediaType.IMAGE == this.getMediaType();
    }

    public boolean waitMediaParsing(int seconds) {
        int i = 0;
        while (this.isParsing()) {
            if (i == seconds) {
                return false;
            }
            UMSUtils.sleep(1000);
            ++i;
        }
        return true;
    }

    public int getFrameNumbers() {
        return (int)(this.getDurationInSeconds() * this.frameRate);
    }

    public void setDuration(Double d) {
        this.durationSec = d;
    }

    public Double getDuration() {
        return this.durationSec;
    }

    public double getDurationInSeconds() {
        return Optional.ofNullable(this.durationSec).orElse(0.0);
    }

    public String getDurationString() {
        return this.durationSec != null ? StringUtil.formatDLNADuration(this.durationSec) : null;
    }

    public int getBitRate() {
        return this.bitrate;
    }

    public void setBitRate(int bitrate) {
        this.bitrate = bitrate;
    }

    public int getRealVideoBitrate() {
        if (this.bitrate > 0) {
            return this.bitrate / 8;
        }
        int realBitrate = 10000000;
        if (this.getDurationInSeconds() > 0.0) {
            realBitrate = (int)((double)this.size / this.getDurationInSeconds());
        }
        return realBitrate;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(Double frameRate) {
        this.frameRate = frameRate;
    }

    public boolean hasVideoMetadata() {
        return this.videoMetadata != null;
    }

    public MediaVideoMetadata getVideoMetadata() {
        return this.videoMetadata;
    }

    public void setVideoMetadata(MediaVideoMetadata value) {
        this.videoMetadata = value;
    }

    public boolean hasAudioMetadata() {
        return this.audioMetadata != null;
    }

    public MediaAudioMetadata getAudioMetadata() {
        return this.audioMetadata;
    }

    public void setAudioMetadata(MediaAudioMetadata value) {
        this.audioMetadata = value;
    }

    public String getAspectRatioDvdIso() {
        return this.aspectRatioDvdIso;
    }

    public void setAspectRatioDvdIso(String aspectRatio) {
        this.aspectRatioDvdIso = aspectRatio;
    }

    public DLNAThumbnail getThumbnail() {
        return ThumbnailStore.getThumbnail(this.thumbnailId);
    }

    public Long getThumbnailId() {
        return this.thumbnailId;
    }

    public void setThumbnailId(Long thumbnailId) {
        this.thumbnailId = thumbnailId;
    }

    public ThumbnailSource getThumbnailSource() {
        return this.thumbnailSource;
    }

    public void setThumbnailSource(ThumbnailSource value) {
        this.thumbnailSource = value;
    }

    public void setThumbnailSource(String value) {
        this.thumbnailSource = ThumbnailSource.valueOfName(value);
    }

    public boolean isThumbnailReady() {
        return this.getThumbnail() != null;
    }

    public DLNAThumbnailInputStream getThumbnailInputStream() {
        DLNAThumbnail thumb = this.getThumbnail();
        return thumb != null ? new DLNAThumbnailInputStream(thumb) : null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public synchronized List<MediaVideo> getVideoTracks() {
        return this.videoTracks;
    }

    public synchronized MediaVideo getDefaultVideoTrack() {
        return this.defaultVideoTrack;
    }

    public synchronized boolean hasVideoTrack() {
        return !this.videoTracks.isEmpty();
    }

    public synchronized void setVideoTracks(List<MediaVideo> videoTracks) {
        if (videoTracks == null) {
            this.videoTracks.clear();
        } else {
            this.videoTracks = videoTracks;
        }
        this.defaultVideoTrack = null;
        for (MediaVideo videoTrack : this.videoTracks) {
            if (this.defaultVideoTrack == null || !this.defaultVideoTrack.isDefault() && videoTrack.isDefault()) {
                this.defaultVideoTrack = videoTrack;
            }
            if (!this.defaultVideoTrack.isDefault()) continue;
            break;
        }
    }

    public synchronized void addVideoTrack(MediaVideo videoTrack) {
        this.videoTracks.add(videoTrack);
        if (this.defaultVideoTrack == null || !this.defaultVideoTrack.isDefault() && videoTrack.isDefault()) {
            this.defaultVideoTrack = videoTrack;
        }
    }

    public synchronized void replaceVideoTrack(MediaVideo videoTrack, int id) {
        this.videoTracks.set(id, videoTrack);
        if (this.defaultVideoTrack == null || !this.defaultVideoTrack.isDefault() && videoTrack.isDefault()) {
            this.defaultVideoTrack = videoTrack;
        }
    }

    public synchronized List<MediaAudio> getAudioTracks() {
        return this.audioTracks;
    }

    public synchronized MediaAudio getDefaultAudioTrack() {
        return this.defaultAudioTrack;
    }

    public synchronized void setAudioTracks(List<MediaAudio> audioTracks) {
        if (audioTracks == null) {
            this.audioTracks.clear();
        } else {
            this.audioTracks = audioTracks;
        }
        this.defaultAudioTrack = null;
        for (MediaAudio audioTrack : this.audioTracks) {
            if (this.defaultAudioTrack == null || !this.defaultAudioTrack.isDefault() && audioTrack.isDefault()) {
                this.defaultAudioTrack = audioTrack;
            }
            if (!this.defaultAudioTrack.isDefault()) continue;
            break;
        }
    }

    public synchronized void addAudioTrack(MediaAudio audioTrack) {
        this.audioTracks.add(audioTrack);
        if (this.defaultAudioTrack == null || audioTrack.isDefault()) {
            this.defaultAudioTrack = audioTrack;
        }
    }

    public synchronized List<MediaSubtitle> getSubtitlesTracks() {
        return this.subtitleTracks;
    }

    public synchronized void setSubtitlesTracks(List<MediaSubtitle> subtitlesTracks) {
        this.subtitleTracks = subtitlesTracks;
    }

    public synchronized void addSubtitlesTrack(MediaSubtitle subtitlesTrack) {
        this.subtitleTracks.add(subtitlesTrack);
    }

    public synchronized List<MediaChapter> getChapters() {
        return this.chapters;
    }

    public synchronized void setChapters(List<MediaChapter> chapters) {
        this.chapters = chapters;
    }

    public synchronized boolean hasChapters() {
        return !this.chapters.isEmpty();
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public boolean isMpegTS() {
        return this.container != null && this.container.equals("mpegts");
    }

    public String getMediaParser() {
        return this.lastParser;
    }

    public void setMediaParser(String lastParser) {
        this.lastParser = lastParser;
    }

    public boolean isMediaParsed() {
        return this.lastParser != null;
    }

    public Integer getDvdtrack() {
        return this.dvdtrack;
    }

    public void setDvdtrack(Integer dvdtrack) {
        this.dvdtrack = dvdtrack;
    }

    public boolean isSecondaryFormatValid() {
        return this.isAudio() && this.defaultAudioTrack.getBitDepth() == 24 && this.defaultAudioTrack.getSampleRate() > 48000;
    }

    public boolean isParsing() {
        return this.parsing.get();
    }

    public void setParsing(boolean parsing) {
        this.parsing.set(parsing);
    }

    public long getLastExternalLookup() {
        return this.lastExternalLookup;
    }

    public void setLastExternalLookup(long lastExternalLookup) {
        this.lastExternalLookup = lastExternalLookup;
    }

    public int getHeight() {
        return switch (this.getMediaType()) {
            case MediaType.VIDEO -> this.defaultVideoTrack.getHeight();
            case MediaType.IMAGE -> this.imageInfo.getHeight();
            default -> 0;
        };
    }

    public int getWidth() {
        return switch (this.getMediaType()) {
            case MediaType.VIDEO -> this.defaultVideoTrack.getWidth();
            case MediaType.IMAGE -> this.imageInfo.getWidth();
            default -> 0;
        };
    }

    public boolean isAudioOrVideoContainer() {
        return MediaInfo.isAudioOrVideoContainer(this.container);
    }

    public Format getAudioVariantFormat() {
        return MediaInfo.getAudioVariantFormat(this.container);
    }

    public String getAudioVariantFormatConfigurationString() {
        return MediaInfo.getAudioVariantFormatConfigurationString(this.container);
    }

    private AudioVariantInfo getAudioVariant() {
        return MediaInfo.getAudioVariant(this.container);
    }

    private void appendVideoTracks(StringBuilder sb) {
        sb.append(", Video Tracks: ").append(this.getVideoTrackCount());
        for (MediaVideo video : this.videoTracks) {
            if (!video.equals(this.videoTracks.get(0))) {
                sb.append(",");
            }
            sb.append(" [").append(video).append("]");
        }
    }

    private void appendAudioTracks(StringBuilder sb) {
        sb.append(", Audio Tracks: ").append(this.getAudioTrackCount());
        for (MediaAudio audio : this.audioTracks) {
            if (!audio.equals(this.audioTracks.get(0))) {
                sb.append(",");
            }
            sb.append(" [").append(audio).append("]");
        }
    }

    private void appendSubtitleTracks(StringBuilder sb) {
        sb.append(", Subtitle Tracks: ").append(this.getSubTrackCount());
        for (MediaSubtitle subtitleTrack : this.subtitleTracks) {
            if (!subtitleTrack.equals(this.subtitleTracks.get(0))) {
                sb.append(",");
            }
            sb.append(" [").append(subtitleTrack).append("]");
        }
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.getContainer() != null) {
            result.addProperty("container", this.getContainer().toUpperCase(Locale.ROOT));
        }
        result.addProperty("size", this.getSize());
        if (this.isVideo()) {
            result.addProperty("mediaType", "video");
            result.addProperty("bitrate", this.getBitRate());
            if (StringUtils.isNotBlank(this.getTitle())) {
                result.addProperty("title", this.getTitle());
            }
            if (this.getFrameRate() != null) {
                result.addProperty("framerate", this.getFrameRate());
            }
            result.addProperty("duration", this.getDurationString());
            if (this.getVideoTrackCount() > 0) {
                JsonArray videotracks = new JsonArray();
                for (MediaVideo video : this.getVideoTracks()) {
                    videotracks.add(video.toJson());
                }
                result.add("videotracks", videotracks);
            }
            if (this.getAudioTrackCount() > 0) {
                audiotracks = new JsonArray();
                for (MediaAudio audio : this.getAudioTracks()) {
                    audiotracks.add(audio.toJson());
                }
                result.add("audiotracks", audiotracks);
            }
            if (this.getSubtitleTrackCount() > 0) {
                JsonArray subtitlestracks = new JsonArray();
                for (MediaSubtitle subtitlesTrack : this.getSubtitlesTracks()) {
                    subtitlestracks.add(subtitlesTrack.toJson());
                }
                result.add("subtitlestracks", subtitlestracks);
            }
        } else if (this.getAudioTrackCount() > 0) {
            result.addProperty("mediaType", "audio");
            result.addProperty("bitrate", this.getBitRate());
            result.addProperty("duration", this.getDurationString());
            audiotracks = new JsonArray();
            for (MediaAudio audio : this.getAudioTracks()) {
                audiotracks.add(audio.toJson());
            }
            result.add("audiotracks", audiotracks);
        }
        if (this.getImageCount() > 0) {
            if (this.getImageCount() > 1) {
                result.addProperty("images", this.getImageCount());
            }
            if (this.getImageInfo() != null) {
                result.add("image", this.getImageInfo().toJson());
            } else {
                JsonObject image = new JsonObject();
                image.addProperty("resolution", this.getWidth() + "x" + this.getHeight());
                result.add("image", image);
            }
        }
        if (this.getThumbnail() != null && this.getThumbnail().getImageInfo() != null) {
            result.add("thumbnail", this.getThumbnail().getImageInfo().toJson());
        }
        result.addProperty("mimetype", this.getMimeType());
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.getContainer() != null) {
            result.append("Container: ").append(this.getContainer().toUpperCase(Locale.ROOT)).append(", ");
        }
        result.append("Size: ").append(this.getSize());
        if (this.isVideo()) {
            result.append(", Overall Bitrate: ").append(this.getBitRate());
            if (StringUtils.isNotBlank(this.getTitle())) {
                result.append(", File Title from Metadata: ").append(this.getTitle());
            }
            if (this.frameRate != null) {
                result.append(", Frame Rate: ").append(this.getFrameRate());
            }
            result.append(", Duration: ").append(this.getDurationString());
            this.appendVideoTracks(result);
            if (this.getAudioTrackCount() > 0) {
                this.appendAudioTracks(result);
            }
            if (this.subtitleTracks != null && !this.subtitleTracks.isEmpty()) {
                this.appendSubtitleTracks(result);
            }
            if (this.hasVideoMetadata()) {
                if (StringUtils.isNotBlank(this.videoMetadata.getIMDbID())) {
                    result.append(", IMDb ID: ").append(this.videoMetadata.getIMDbID());
                }
                if (this.videoMetadata.getYear() != null) {
                    result.append(", Year: ").append(this.videoMetadata.getYear());
                }
                if (StringUtils.isNotBlank(this.videoMetadata.getTitle())) {
                    result.append(", Movie/TV series name: ").append(this.videoMetadata.getTitle());
                }
                if (this.videoMetadata.isTvEpisode()) {
                    result.append(", TV season: ").append(this.videoMetadata.getTvSeason());
                    result.append(", TV episode number: ").append(this.videoMetadata.getTvEpisodeNumber());
                    if (StringUtils.isNotBlank(this.videoMetadata.getTvEpisodeName())) {
                        result.append(", TV episode name: ").append(this.videoMetadata.getTvEpisodeName());
                    }
                }
            }
        } else if (this.getAudioTrackCount() > 0) {
            result.append(", Overall Bitrate: ").append(this.getBitRate());
            result.append(", Duration: ").append(this.getDurationString());
            this.appendAudioTracks(result);
            if (this.hasAudioMetadata()) {
                if (StringUtils.isNotBlank(this.audioMetadata.getArtist())) {
                    result.append(", Artist: ").append(this.audioMetadata.getArtist());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getComposer())) {
                    result.append(", Composer: ").append(this.audioMetadata.getComposer());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getConductor())) {
                    result.append(", Conductor: ").append(this.audioMetadata.getConductor());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getAlbum())) {
                    result.append(", Album: ").append(this.audioMetadata.getAlbum());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getAlbumArtist())) {
                    result.append(", Album Artist: ").append(this.audioMetadata.getAlbumArtist());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getSongname())) {
                    result.append(", Track Name: ").append(this.audioMetadata.getSongname());
                }
                if (this.audioMetadata.getYear() != 0) {
                    result.append(", Year: ").append(this.audioMetadata.getYear());
                }
                if (this.audioMetadata.getTrack() != 0) {
                    result.append(", Track: ").append(this.audioMetadata.getTrack());
                }
                if (StringUtils.isNotBlank(this.audioMetadata.getGenre())) {
                    result.append(", Genre: ").append(this.audioMetadata.getGenre());
                }
            }
        }
        if (this.getImageCount() > 0) {
            if (this.getImageCount() > 1) {
                result.append(", Images: ").append(this.getImageCount());
            }
            if (this.getImageInfo() != null) {
                result.append(", ").append(this.getImageInfo());
            } else {
                result.append(", Image Width: ").append(this.getWidth());
                result.append(", Image Height: ").append(this.getHeight());
            }
        }
        if (this.getThumbnail() != null) {
            result.append(", ").append(this.getThumbnail());
        }
        if (this.getMimeType() != null) {
            result.append(", Mime Type: ").append(this.getMimeType());
        }
        return result.toString();
    }

    public MediaInfo clone() throws CloneNotSupportedException {
        MediaInfo mediaCloned = (MediaInfo)super.clone();
        mediaCloned.setVideoTracks(new ArrayList<MediaVideo>());
        for (MediaVideo video : this.videoTracks) {
            mediaCloned.addVideoTrack(video.clone());
        }
        mediaCloned.setAudioTracks(new ArrayList<MediaAudio>());
        for (MediaAudio audio : this.audioTracks) {
            mediaCloned.addAudioTrack((MediaAudio)audio.clone());
        }
        mediaCloned.setSubtitlesTracks(new ArrayList<MediaSubtitle>());
        for (MediaSubtitle sub : this.subtitleTracks) {
            mediaCloned.addSubtitlesTrack((MediaSubtitle)sub.clone());
        }
        return mediaCloned;
    }

    public static boolean isLossless(String codecA) {
        return codecA != null && (codecA.contains("pcm") || codecA.startsWith("dts") || codecA.equals("dca") || codecA.contains("flac")) && !codecA.contains("pcm_u8") && !codecA.contains("pcm_s8");
    }

    private static boolean isAudioOrVideoContainer(String container) {
        if (StringUtils.isBlank(container)) {
            return false;
        }
        for (Map.Entry<String, AudioVariantInfo> entry : AUDIO_OR_VIDEO_CONTAINERS.entrySet()) {
            if (!container.equals(entry.getKey()) && !container.equals(entry.getValue().getFormatConfiguration())) continue;
            return true;
        }
        return false;
    }

    private static Format getAudioVariantFormat(String container) {
        if (StringUtils.isBlank(container)) {
            return null;
        }
        for (Map.Entry<String, AudioVariantInfo> entry : AUDIO_OR_VIDEO_CONTAINERS.entrySet()) {
            if (!container.equals(entry.getKey()) && !container.equals(entry.getValue().getFormatConfiguration())) continue;
            return entry.getValue().getFormat();
        }
        return null;
    }

    private static String getAudioVariantFormatConfigurationString(String container) {
        if (StringUtils.isBlank(container)) {
            return null;
        }
        for (Map.Entry<String, AudioVariantInfo> entry : AUDIO_OR_VIDEO_CONTAINERS.entrySet()) {
            if (!container.equals(entry.getKey()) && !container.equals(entry.getValue().getFormatConfiguration())) continue;
            return entry.getValue().getFormatConfiguration();
        }
        return null;
    }

    private static AudioVariantInfo getAudioVariant(String container) {
        if (StringUtils.isBlank(container)) {
            return null;
        }
        for (Map.Entry<String, AudioVariantInfo> entry : AUDIO_OR_VIDEO_CONTAINERS.entrySet()) {
            if (!container.equals(entry.getKey()) && !container.equals(entry.getValue().getFormatConfiguration())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Map<String, AudioVariantInfo> getAudioOrVideoContainers() {
        HashMap<String, AudioVariantInfo> mutableAudioOrVideoContainers = new HashMap<String, AudioVariantInfo>();
        mutableAudioOrVideoContainers.put("mp4", new AudioVariantInfo(new M4A(), "m4a"));
        mutableAudioOrVideoContainers.put("mkv", new AudioVariantInfo(new MKA(), "mka"));
        mutableAudioOrVideoContainers.put("ogg", new AudioVariantInfo(new OGA(), "oga"));
        mutableAudioOrVideoContainers.put("rm", new AudioVariantInfo(new RA(), "ra"));
        mutableAudioOrVideoContainers.put("mpeg1", new AudioVariantInfo(new MP3(), "mpa"));
        mutableAudioOrVideoContainers.put("mpeg2", new AudioVariantInfo(new MP3(), "mpa"));
        mutableAudioOrVideoContainers.put("3gp", new AudioVariantInfo(new THREEGA(), "3ga"));
        mutableAudioOrVideoContainers.put("3g2", new AudioVariantInfo(new THREEG2A(), "3ga"));
        mutableAudioOrVideoContainers.put("webm", new AudioVariantInfo(new MKA(), "weba"));
        mutableAudioOrVideoContainers.put("wmv", new AudioVariantInfo(new WMA(), "wma"));
        return Collections.unmodifiableMap(mutableAudioOrVideoContainers);
    }

    public static class AudioVariantInfo {
        protected final Format format;
        protected final String formatConfiguration;

        public AudioVariantInfo(Format format, String formatConfiguration) {
            this.format = format;
            this.formatConfiguration = formatConfiguration;
        }

        public Format getFormat() {
            return this.format;
        }

        public String getFormatConfiguration() {
            return this.formatConfiguration;
        }
    }
}

