/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGobbler
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamGobbler.class);
    BufferedReader in;
    private boolean logging;

    public StreamGobbler(InputStream in, boolean enableLogging) {
        this.in = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        this.logging = enableLogging;
    }

    public StreamGobbler(InputStream in) {
        this(in, false);
    }

    @Override
    public void run() {
        try {
            StreamGobbler.doGobble(this.in, this.logging);
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception while gobbling stream: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void consumeThrow(InputStream in, boolean enableLogging) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StreamGobbler.doGobble(reader, enableLogging);
    }

    public static void consume(InputStream in, boolean enableLogging) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            StreamGobbler.doGobble(reader, enableLogging);
        }
        catch (IOException e) {
            LOGGER.debug("Caught exception while gobbling stream: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void consume(InputStream in) {
        StreamGobbler.consume(in, false);
    }

    private static void doGobble(BufferedReader reader, boolean enableLogging) throws IOException {
        try (BufferedReader bufferedReader = reader;){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!enableLogging || line.startsWith("100")) continue;
                LOGGER.trace(line);
            }
        }
    }
}

