/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import net.pms.io.ByteProcessWrapperConsumer;
import net.pms.io.ByteProcessWrapperResult;
import net.pms.io.ListProcessWrapperConsumer;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.NullProcessWrapperConsumer;
import net.pms.io.ProcessWrapperConsumer;
import net.pms.io.ProcessWrapperResult;
import net.pms.service.Services;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessWrapper<C extends ProcessWrapperConsumer<R, T>, R extends ProcessWrapperResult<T>, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleProcessWrapper.class);
    protected final C consumer;

    @Nonnull
    public static ListProcessWrapperResult runProcessListOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return (ListProcessWrapperResult)new SimpleProcessWrapper(new ListProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    @Nonnull
    public static ListProcessWrapperResult runProcessListOutput(long timeoutMS, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return (ListProcessWrapperResult)new SimpleProcessWrapper(new ListProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    @Nonnull
    public static ListProcessWrapperResult runProcessListOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) throws InterruptedException {
        return (ListProcessWrapperResult)new SimpleProcessWrapper(new ListProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public static ListProcessWrapperResult runProcessListOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) throws InterruptedException {
        return (ListProcessWrapperResult)new SimpleProcessWrapper(new ListProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    @Nonnull
    public static ByteProcessWrapperResult runProcessByteOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return (ByteProcessWrapperResult)new SimpleProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    @Nonnull
    public static ByteProcessWrapperResult runProcessByteOutput(long timeoutMS, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return (ByteProcessWrapperResult)new SimpleProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    @Nonnull
    public static ByteProcessWrapperResult runProcessByteOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) throws InterruptedException {
        return (ByteProcessWrapperResult)new SimpleProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public static ByteProcessWrapperResult runProcessByteOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) throws InterruptedException {
        return (ByteProcessWrapperResult)new SimpleProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    public static void runProcessNullOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) throws InterruptedException {
        new SimpleProcessWrapper(new NullProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    public static void runProcessNullOutput(long timeoutMS, long terminateTimeoutMS, String ... command) throws InterruptedException {
        new SimpleProcessWrapper(new NullProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    public static void runProcessNullOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) throws InterruptedException {
        new SimpleProcessWrapper(new NullProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    public static void runProcessNullOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) throws InterruptedException {
        new SimpleProcessWrapper(new NullProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    public SimpleProcessWrapper(C consumer) {
        this.consumer = consumer;
    }

    public SimpleProcessWrapper(Class<C> consumer) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.consumer = (ProcessWrapperConsumer)consumer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Nonnull
    public R runProcess(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return this.runProcess(Arrays.asList(command), timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public R runProcess(long timeoutMS, long terminateTimeoutMS, String ... command) throws InterruptedException {
        return this.runProcess(Arrays.asList(command), timeoutMS, terminateTimeoutMS);
    }

    @Nonnull
    public R runProcess(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) throws InterruptedException {
        return this.runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public R runProcess(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) throws InterruptedException {
        boolean interrupted;
        Process process;
        Path executable;
        if (command.isEmpty()) {
            throw new IllegalArgumentException("command can't be null or empty");
        }
        String executableName = StringUtils.isNotBlank(command.get(0)) ? ((executable = Paths.get(command.get(0), new String[0]).getFileName()) != null ? executable.toString() : command.get(0)) : command.get(0);
        boolean manageProcess = timeoutMS > 0L;
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.environment().put("LC_ALL", "C");
        processBuilder.redirectErrorStream(true);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Executing \"{}\"", (Object)StringUtils.join(command, " "));
        }
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            LOGGER.debug("IOException when trying to start \"{}\" process: {}", (Object)executableName, (Object)e.getMessage());
            LOGGER.trace("", e);
            return (R)((ProcessWrapperResult)this.consumer.createResult(null, Integer.MIN_VALUE, e));
        }
        FutureTask output = this.consumer.consume(process.getInputStream(), "SPW \"" + executableName + "\" consumer");
        if (manageProcess) {
            Services.processManager().addProcess(process, command.get(0), timeoutMS, terminateTimeoutMS);
        }
        int exitCode = Integer.MIN_VALUE;
        boolean shutdown = false;
        do {
            interrupted = false;
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException e) {
                interrupted = Thread.interrupted();
                if (shutdown) continue;
                if (manageProcess) {
                    Services.processManager().shutdownProcess(process, executableName);
                    manageProcess = false;
                } else {
                    Services.processManager().addProcess(process, executableName, 0L, terminateTimeoutMS);
                }
                shutdown = true;
            }
        } while (interrupted);
        if (manageProcess) {
            Services.processManager().removeProcess(process, command.get(0));
        }
        try {
            return (R)((ProcessWrapperResult)this.consumer.createResult(output.get(), exitCode, null));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            LOGGER.error("ExecutionException in \"{}\" consumer, no output will be returned: {}", (Object)executableName, (Object)cause.getMessage());
            LOGGER.trace("", e);
            return (R)((ProcessWrapperResult)this.consumer.createResult(null, exitCode, cause));
        }
    }
}

