/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.io.BufferedOutputByteArrayImpl;
import net.pms.io.BufferedOutputFile;
import net.pms.io.OutputConsumer;
import net.pms.io.OutputParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayOutputStreamConsumer
extends OutputConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteArrayOutputStreamConsumer.class);
    private final ReentrantReadWriteLock outputBufferLock = new ReentrantReadWriteLock();
    private BufferedOutputByteArrayImpl outputBuffer;
    private final int bufferSize;

    public ByteArrayOutputStreamConsumer(InputStream inputStream, OutputParams params) {
        super(inputStream);
        this.bufferSize = params.getOutputByteArrayStreamBufferSize() > 512 ? params.getOutputByteArrayStreamBufferSize() : 512;
        this.outputBuffer = new BufferedOutputByteArrayImpl(this.bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] bytes = new byte[Math.min(Math.max(512, this.bufferSize / 8), 64000)];
            int n = 0;
            while ((n = this.inputStream.read(bytes)) > 0) {
                this.outputBufferLock.writeLock().lock();
                try {
                    this.outputBuffer.write(bytes, 0, n);
                }
                finally {
                    this.outputBufferLock.writeLock().unlock();
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug("IO error while reading process output: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        finally {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("Error closing input stream: {}", (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            }
        }
    }

    @Override
    public BufferedOutputFile getBuffer() {
        this.outputBufferLock.readLock().lock();
        try {
            BufferedOutputByteArrayImpl bufferedOutputByteArrayImpl = this.outputBuffer;
            return bufferedOutputByteArrayImpl;
        }
        finally {
            this.outputBufferLock.readLock().unlock();
        }
    }

    @Override
    public List<String> getResults() {
        return null;
    }
}

