/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import net.coobird.thumbnailator.util.exif.Orientation;

public enum ExifOrientation {
    TOP_LEFT(1),
    TOP_RIGHT(2),
    BOTTOM_RIGHT(3),
    BOTTOM_LEFT(4),
    LEFT_TOP(5),
    RIGHT_TOP(6),
    RIGHT_BOTTOM(7),
    LEFT_BOTTOM(8);

    private int value;

    private ExifOrientation(int value) {
        this.value = value;
    }

    public static ExifOrientation typeOf(int value) {
        for (ExifOrientation orientation : ExifOrientation.values()) {
            if (orientation.value != value) continue;
            return orientation;
        }
        return TOP_LEFT;
    }

    public static ExifOrientation typeOf(Integer value) {
        if (value == null) {
            return TOP_LEFT;
        }
        for (ExifOrientation orientation : ExifOrientation.values()) {
            if (orientation.value != value) continue;
            return orientation;
        }
        return TOP_LEFT;
    }

    public static ExifOrientation fromDCRawOrientation(int dcRawOrientation) {
        switch (dcRawOrientation & 7) {
            case 0: {
                return TOP_LEFT;
            }
            case 1: {
                return TOP_RIGHT;
            }
            case 2: {
                return BOTTOM_LEFT;
            }
            case 3: {
                return BOTTOM_RIGHT;
            }
            case 4: {
                return LEFT_TOP;
            }
            case 5: {
                return LEFT_BOTTOM;
            }
            case 6: {
                return RIGHT_TOP;
            }
            case 7: {
                return RIGHT_BOTTOM;
            }
        }
        return TOP_LEFT;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "Orientation " + this.name() + " (" + this.value + ")";
    }

    public int getDCRawOrientation() {
        switch (this) {
            case TOP_LEFT: {
                return 0;
            }
            case TOP_RIGHT: {
                return 1;
            }
            case BOTTOM_RIGHT: {
                return 3;
            }
            case BOTTOM_LEFT: {
                return 2;
            }
            case LEFT_TOP: {
                return 4;
            }
            case RIGHT_TOP: {
                return 6;
            }
            case RIGHT_BOTTOM: {
                return 7;
            }
            case LEFT_BOTTOM: {
                return 5;
            }
        }
        return 0;
    }

    public Orientation getThumbnailatorOrientation() {
        return Orientation.typeOf(this.getValue());
    }
}

