/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.formats.DVRMS;
import net.pms.formats.Format;
import net.pms.formats.ISO;
import net.pms.formats.ISOVOB;
import net.pms.formats.MKV;
import net.pms.formats.MPG;
import net.pms.formats.OGG;
import net.pms.formats.PLAYLIST;
import net.pms.formats.WEB;
import net.pms.formats.audio.AACP;
import net.pms.formats.audio.AC3;
import net.pms.formats.audio.ADPCM;
import net.pms.formats.audio.ADTS;
import net.pms.formats.audio.AIFF;
import net.pms.formats.audio.ATRAC;
import net.pms.formats.audio.AU;
import net.pms.formats.audio.DFF;
import net.pms.formats.audio.DSF;
import net.pms.formats.audio.DTS;
import net.pms.formats.audio.EAC3;
import net.pms.formats.audio.FLAC;
import net.pms.formats.audio.M4A;
import net.pms.formats.audio.MKA;
import net.pms.formats.audio.MLP;
import net.pms.formats.audio.MP3;
import net.pms.formats.audio.MPC;
import net.pms.formats.audio.MPGAudio;
import net.pms.formats.audio.MonkeysAudio;
import net.pms.formats.audio.OGA;
import net.pms.formats.audio.RA;
import net.pms.formats.audio.SHN;
import net.pms.formats.audio.THREEG2A;
import net.pms.formats.audio.THREEGA;
import net.pms.formats.audio.TTA;
import net.pms.formats.audio.TrueHD;
import net.pms.formats.audio.WAV;
import net.pms.formats.audio.WMA;
import net.pms.formats.audio.WavPack;
import net.pms.formats.image.BMP;
import net.pms.formats.image.GIF;
import net.pms.formats.image.ICNS;
import net.pms.formats.image.ICO;
import net.pms.formats.image.IFF;
import net.pms.formats.image.JPG;
import net.pms.formats.image.PCX;
import net.pms.formats.image.PICT;
import net.pms.formats.image.PNG;
import net.pms.formats.image.PNM;
import net.pms.formats.image.PSD;
import net.pms.formats.image.RAW;
import net.pms.formats.image.RGBE;
import net.pms.formats.image.SGI;
import net.pms.formats.image.TGA;
import net.pms.formats.image.TIFF;
import net.pms.formats.image.WBMP;
import net.pms.formats.image.WEBP;
import net.pms.formats.subtitle.ASS;
import net.pms.formats.subtitle.IDX;
import net.pms.formats.subtitle.MicroDVD;
import net.pms.formats.subtitle.SAMI;
import net.pms.formats.subtitle.SUP;
import net.pms.formats.subtitle.SubRip;
import net.pms.formats.subtitle.TXT;
import net.pms.formats.subtitle.WebVTT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormatFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatFactory.class);
    static final Format[] FORMATS = new Format[]{new AACP(), new AC3(), new ADPCM(), new ADTS(), new AIFF(), new ASS(), new ATRAC(), new AU(), new BMP(), new DFF(), new DSF(), new DTS(), new DVRMS(), new EAC3(), new FLAC(), new GIF(), new ICNS(), new ICO(), new IDX(), new IFF(), new ISO(), new ISOVOB(), new JPG(), new M4A(), new MicroDVD(), new MKA(), new MKV(), new MLP(), new MonkeysAudio(), new MP3(), new MPC(), new MPG(), new MPGAudio(), new OGA(), new OGG(), new PCX(), new PICT(), new PLAYLIST(), new PNG(), new PNM(), new PSD(), new RA(), new RAW(), new RGBE(), new SAMI(), new SGI(), new SHN(), new SubRip(), new SUP(), new TGA(), new THREEGA(), new THREEG2A(), new TIFF(), new TrueHD(), new TTA(), new TXT(), new WAV(), new WavPack(), new WBMP(), new WEB(), new WEBP(), new WebVTT(), new WMA()};
    private static final ReentrantReadWriteLock FORMATS_LOCK = new ReentrantReadWriteLock();
    private static final List<Format> REGISTERED_FORMATS = new ArrayList<Format>(Arrays.asList(FORMATS));

    private FormatFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Format getAssociatedFormat(String filename) {
        FORMATS_LOCK.readLock().lock();
        try {
            for (Format format : REGISTERED_FORMATS) {
                if (!format.match(filename)) continue;
                LOGGER.trace("Matched format {} to \"{}\"", (Object)format, (Object)filename);
                Format format2 = format.duplicate();
                return format2;
            }
        }
        finally {
            FORMATS_LOCK.readLock().unlock();
        }
        LOGGER.trace("Could not match any format to \"{}\"", (Object)filename);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Format getFormat(Class<? extends Format> clazz) {
        if (clazz == null) {
            return null;
        }
        FORMATS_LOCK.readLock().lock();
        try {
            for (Format format : REGISTERED_FORMATS) {
                if (!format.getClass().equals(clazz)) continue;
                Format format2 = format.duplicate();
                return format2;
            }
        }
        finally {
            FORMATS_LOCK.readLock().unlock();
        }
        return null;
    }

    public static List<Format> getSupportedFormats() {
        FORMATS_LOCK.readLock().lock();
        try {
            ArrayList<Format> arrayList = new ArrayList<Format>(REGISTERED_FORMATS);
            return arrayList;
        }
        finally {
            FORMATS_LOCK.readLock().unlock();
        }
    }

    public static boolean addFormat(Format format) {
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        FORMATS_LOCK.writeLock().lock();
        try {
            boolean bl = REGISTERED_FORMATS.add(format);
            return bl;
        }
        finally {
            FORMATS_LOCK.writeLock().unlock();
        }
    }

    public static boolean removeFormat(Format format) {
        if (format == null) {
            throw new NullPointerException("format cannot be null");
        }
        FORMATS_LOCK.writeLock().lock();
        try {
            boolean bl = REGISTERED_FORMATS.remove(format);
            return bl;
        }
        finally {
            FORMATS_LOCK.writeLock().unlock();
        }
    }
}

