/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.radiobrowser;

import de.sfuhrm.radiobrowser4j.ConnectionParams;
import de.sfuhrm.radiobrowser4j.EndpointDiscovery;
import de.sfuhrm.radiobrowser4j.RadioBrowser;
import de.sfuhrm.radiobrowser4j.Station;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFiles;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.store.MediaStore;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.SimpleThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadioBrowser4j {
    private static final Logger LOGGER = LoggerFactory.getLogger(RadioBrowser.class.getName());
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final ThreadPoolExecutor BACKGROUND_EXECUTOR = new ThreadPoolExecutor(0, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new SimpleThreadFactory("Lookup RadioBrowser Metadata background worker", "Lookup RadioBrowser Metadata background workers group", 4));
    private static RadioBrowser radioBrowser;

    private RadioBrowser4j() {
    }

    private static boolean shouldLookupAndAddMetadata() {
        if (BACKGROUND_EXECUTOR.isShutdown()) {
            LOGGER.trace("Not doing background WebStream lookup because background executor is shutdown");
            return false;
        }
        if (!MediaDatabase.isAvailable()) {
            LOGGER.trace("Not doing background WebStream lookup because database is closed");
            return false;
        }
        return true;
    }

    private static boolean isRadioBrowserExists() {
        if (radioBrowser == null) {
            Optional<Object> endpoint = Optional.empty();
            try {
                endpoint = new EndpointDiscovery("UMS/" + PMS.getVersion()).discover();
            }
            catch (IOException e) {
                LOGGER.debug("IO problem while endpoint discovery.");
            }
            if (endpoint.isPresent()) {
                ConnectionParams cx = ConnectionParams.builder().apiUrl((String)endpoint.get()).userAgent("UMS/" + PMS.getVersion()).timeout(5000).build();
                radioBrowser = new RadioBrowser(cx);
            }
        }
        return radioBrowser != null;
    }

    public static boolean getWebStreamMetadata(MediaInfo mediaInfo, String url, String radioBrowserUUID) {
        if (!CONFIGURATION.getExternalNetwork() || StringUtils.isAllBlank(radioBrowserUUID)) {
            return false;
        }
        if (RadioBrowser4j.isRadioBrowserExists()) {
            try {
                Long fileId;
                DLNAThumbnail thumbnail;
                UUID uuid = UUID.fromString(radioBrowserUUID);
                Station station = radioBrowser.getStationByUUID(uuid).orElseThrow();
                String genre = RadioBrowser4j.getGenres(station.getTagList());
                Format f = FormatFactory.getAssociatedFormat("." + station.getCodec());
                if (!mediaInfo.hasAudio()) {
                    mediaInfo.addAudioTrack(new MediaAudio());
                }
                if (f != null) {
                    mediaInfo.setMimeType(f.mimeType());
                }
                if (station.getBitrate() != null) {
                    mediaInfo.setBitRate(station.getBitrate());
                    mediaInfo.getDefaultAudioTrack().setBitRate(station.getBitrate());
                }
                if (genre != null) {
                    mediaInfo.getAudioMetadata().setGenre(genre);
                }
                if (StringUtils.isNotBlank(station.getFavicon()) && !ThumbnailSource.RADIOBROWSER.equals((Object)mediaInfo.getThumbnailSource()) && (thumbnail = JavaHttpClient.getThumbnail(station.getFavicon())) != null && (fileId = MediaTableFiles.getFileId(url)) != null) {
                    Long thumbnailId = ThumbnailStore.getId(thumbnail, fileId, ThumbnailSource.RADIOBROWSER);
                    mediaInfo.setThumbnailId(thumbnailId);
                    mediaInfo.setThumbnailSource(ThumbnailSource.RADIOBROWSER);
                }
                return true;
            }
            catch (Exception e) {
                LOGGER.debug("cannot read radio browser metadata for uuid {}", (Object)radioBrowserUUID, (Object)e);
            }
        }
        return false;
    }

    protected static String getGenres(List<String> tags) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tags.size(); ++i) {
            sb.append(tags.get(i));
            if (i >= tags.size() - 1) continue;
            sb.append(" / ");
        }
        return sb.toString();
    }

    public static void backgroundLookupAndAddMetadata(String uri, String radioBrowserUUID, MediaInfo mediaInfo) {
        if (!RadioBrowser4j.shouldLookupAndAddMetadata()) {
            return;
        }
        long elapsed = System.currentTimeMillis() - mediaInfo.getLastExternalLookup();
        if (elapsed < 300000L) {
            return;
        }
        mediaInfo.setLastExternalLookup(System.currentTimeMillis());
        Runnable r = () -> {
            try {
                MediaStore.waitWorkers();
                mediaInfo.waitMediaParsing(10);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return;
            }
            if (!StringUtils.isBlank(radioBrowserUUID) && RadioBrowser4j.getWebStreamMetadata(mediaInfo, uri, radioBrowserUUID)) {
                MediaTableFiles.insertOrUpdateData(uri, 0L, 1, mediaInfo);
            }
        };
        LOGGER.trace("Queuing background WebStream lookup for {}", (Object)uri);
        BACKGROUND_EXECUTOR.execute(r);
    }
}

