/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.musicbrainz.coverart;

import com.universalmediaserver.coverartarchive.api.CoverArtArchiveClient;
import com.universalmediaserver.coverartarchive.api.endpoint.ThumbnailSize;
import com.universalmediaserver.coverartarchive.api.schema.ResultSchema;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableCoverArtArchive;
import net.pms.external.musicbrainz.api.MusicBrainzUtil;
import net.pms.external.musicbrainz.coverart.CoverUtil;
import org.jaudiotagger.tag.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoverArtArchiveUtil
extends CoverUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoverArtArchiveUtil.class);
    private static final long EXPIRATION_TIME = 86400000L;
    private static final Map<String, Object> LOCKS = new HashMap<String, Object>();

    protected CoverArtArchiveUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(String filename) {
        Map<String, Object> map = LOCKS;
        synchronized (map) {
            if (LOCKS.containsKey(filename)) {
                return LOCKS.get(filename);
            }
            Object lock = new Object();
            LOCKS.put(filename, lock);
            return lock;
        }
    }

    @Override
    public byte[] doGetThumbnail(Tag tag, boolean externalNetwork) {
        String mBID = MusicBrainzUtil.getMBID(tag, externalNetwork);
        return CoverArtArchiveUtil.doGetThumbnail(mBID, externalNetwork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] doGetThumbnail(String mBID, boolean externalNetwork) {
        Object lock;
        if (mBID == null) {
            return null;
        }
        Object object = lock = CoverArtArchiveUtil.getLock(mBID);
        synchronized (object) {
            Connection connection = null;
            try {
                MediaTableCoverArtArchive.CoverArtArchiveResult result;
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null && (result = MediaTableCoverArtArchive.findMBID(mBID)).isFound()) {
                    if (result.hasCoverBytes()) {
                        byte[] byArray = result.getCoverBytes();
                        return byArray;
                    }
                    if (System.currentTimeMillis() - result.getModifiedTime() < 86400000L) {
                        byte[] byArray = null;
                        return byArray;
                    }
                }
                if (!externalNetwork) {
                    LOGGER.warn("Can't download cover from Cover Art Archive since external network is disabled");
                    LOGGER.info("Either enable external network or disable cover download");
                    result = null;
                    return result;
                }
                CoverArtArchiveClient client = new CoverArtArchiveClient();
                ResultSchema result2 = client.release(mBID).getDetails();
                if (result2 == null) {
                    LOGGER.debug("Cover for MBID \"{}\" was not found at CoverArtArchive", (Object)mBID);
                    MediaTableCoverArtArchive.writeMBID(mBID, null);
                    byte[] byArray = null;
                    return byArray;
                }
                if (result2.getImages() == null || result2.getImages().isEmpty()) {
                    LOGGER.debug("MBID \"{}\" has no cover at CoverArtArchive", (Object)mBID);
                    if (connection != null) {
                        MediaTableCoverArtArchive.writeMBID(mBID, null);
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] cover = client.release(mBID).getFrontImageBytes(ThumbnailSize.LARGE);
                if (cover != null && cover.length > 0 && connection != null) {
                    MediaTableCoverArtArchive.writeMBID(mBID, null);
                }
                byte[] byArray = cover;
                return byArray;
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }
}

