/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.http.HttpResponse;
import net.pms.external.FileBodySubscriber;
import net.pms.external.ProgressCallback;

public class FileBodyHandler
implements HttpResponse.BodyHandler<Void> {
    private final File file;
    private final String uri;
    private final ProgressCallback progressCallback;

    public FileBodyHandler(File file, String uri, ProgressCallback progressCallback) throws FileNotFoundException {
        if (file == null) {
            throw new FileNotFoundException("File may nor be null");
        }
        this.file = file;
        this.uri = uri;
        this.progressCallback = progressCallback;
    }

    @Override
    public HttpResponse.BodySubscriber<Void> apply(HttpResponse.ResponseInfo responseInfo) {
        long contentLength = responseInfo.headers().firstValueAsLong("Content-Length").orElse(-1L);
        FileBodySubscriber subscriber = new FileBodySubscriber(this.file, contentLength, this.uri, this.progressCallback);
        return HttpResponse.BodySubscribers.fromSubscriber(subscriber, s -> null);
    }
}

