/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.formats.Format;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.store.StoreItem;
import net.pms.util.PlayerUtil;

public class TsMuxeRAudio
extends TsMuxeRVideo {
    public static final EngineId ID = StandardEngineId.TSMUXER_AUDIO;
    public static final String KEY_TSMUXER_AUDIO_EXECUTABLE_TYPE = "tsmuxer_audio_executable_type";
    public static final String NAME = "tsMuxeR Audio";

    TsMuxeRAudio() {
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_TSMUXER_AUDIO_EXECUTABLE_TYPE;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        params.setTimeEnd(media.getDurationInSeconds());
        params.setWaitBeforeStart(2500);
        return super.launchTranscode(resource, media, params);
    }

    @Override
    public String getMimeType() {
        return "audio/transcode";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int purpose() {
        return 1;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public boolean isCompatible(StoreItem resource) {
        return PlayerUtil.isVideo(resource, Format.Identifier.AUDIO_AS_VIDEO);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isAudioFormat();
    }
}

