/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineId;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.StandardEngineId;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.platform.PlatformUtils;
import net.pms.store.StoreItem;
import net.pms.util.PlayerUtil;
import net.pms.util.UMSUtils;

public class MEncoderWebVideo
extends MEncoderVideo {
    public static final EngineId ID = StandardEngineId.MENCODER_WEB_VIDEO;
    public static final String KEY_MENCODER_WEB_EXECUTABLE_TYPE = "mencoder_web_executable_type";
    public static final String NAME = "MEncoder Web Video";

    MEncoderWebVideo() {
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_MENCODER_WEB_EXECUTABLE_TYPE;
    }

    @Override
    public int purpose() {
        return 2;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public String getMimeType() {
        return "video/mpeg";
    }

    protected String[] getDefaultArgs(UmsConfiguration configuration) {
        int nThreads = configuration.getMencoderMaxThreads();
        String acodec = configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3";
        return new String[]{"-msglevel", "all=2", "-quiet", "-prefer-ipv4", "-cache", "16384", "-oac", "lavc", "-of", "lavf", "-lavfopts", "format=dvd", "-ovc", "lavc", "-lavcopts", "vcodec=mpeg2video:vbitrate=4096:threads=" + nThreads + ":acodec=" + acodec + ":abitrate=128", "-vf", "harddup", "-ofps", "25"};
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        String filename;
        IPipeProcess pipe;
        UmsConfiguration configuration = params.getMediaRenderer().getUmsConfiguration();
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        params.getInputPipes()[0] = pipe = PlatformUtils.INSTANCE.getPipeProcess("mencoder" + System.currentTimeMillis(), new String[0]);
        String[] defaultArgs = this.getDefaultArgs(configuration);
        String[] cmdArray = new String[defaultArgs.length + 4];
        cmdArray[0] = this.getExecutable();
        cmdArray[1] = filename = resource.getFileName();
        System.arraycopy(defaultArgs, 0, cmdArray, 2, defaultArgs.length);
        cmdArray[cmdArray.length - 2] = "-o";
        cmdArray[cmdArray.length - 1] = pipe.getInputPipe();
        ProcessWrapper mkfifoProcess = pipe.getPipeProcess();
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(mkfifoProcess);
        mkfifoProcess.runInSameThread();
        pipe.deleteLater();
        pw.runInNewThread();
        UMSUtils.sleep(50);
        return pw;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isWebVideo(item);
    }
}

