/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import java.util.ArrayList;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.HlsHelper;
import net.pms.encoders.StandardEngineId;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.store.StoreItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegHlsVideo
extends FFMpegVideo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegHlsVideo.class);
    public static final EngineId ID = StandardEngineId.FFMPEG_HLS_VIDEO;
    public static final String NAME = "FFmpeg HLS Video";

    FFmpegHlsVideo() {
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        if (!params.isHlsConfigured()) {
            LOGGER.error("No Hls configuration to transcode.");
            return null;
        }
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        params.setWaitBeforeStart(0);
        UmsConfiguration configuration = params.getMediaRenderer().getUmsConfiguration();
        HlsHelper.HlsConfiguration hlsConfiguration = params.getHlsConfiguration();
        boolean needVideo = hlsConfiguration.video.resolutionWidth > -1;
        boolean needAudio = hlsConfiguration.audioStream > -1;
        boolean needSubtitle = hlsConfiguration.subtitle > -1;
        String filename = resource.getFileName();
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getExecutable());
        cmdList.add("-y");
        FFmpegHlsVideo.setLogLevel(cmdList, configuration);
        if (needSubtitle) {
            cmdList.add("-nostdin");
        }
        FFmpegHlsVideo.setDecodingOptions(cmdList, configuration, false);
        if (params.getTimeSeek() > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + (int)params.getTimeSeek());
        }
        if (params.getTimeEnd() > 0.0 && !needSubtitle) {
            cmdList.add("-t");
            cmdList.add(String.valueOf(params.getTimeEnd() - params.getTimeSeek()));
        }
        if (!needVideo) {
            cmdList.add("-vn");
        }
        if (!needAudio) {
            cmdList.add("-an");
        }
        if (!needSubtitle) {
            cmdList.add("-sn");
        }
        cmdList.add("-i");
        if (params.getStdIn() != null) {
            cmdList.add("pipe:");
        } else {
            cmdList.add(filename);
        }
        if (needSubtitle) {
            cmdList.add("-map");
            cmdList.add("0:s:" + hlsConfiguration.subtitle);
            if (params.getTimeEnd() > 0.0) {
                cmdList.add("-t");
                cmdList.add(String.valueOf(params.getTimeEnd()));
            }
        } else {
            cmdList.add("-sn");
        }
        if (media.getAudioTracks().size() > 1) {
            if (needVideo) {
                cmdList.add("-map");
                cmdList.add("0:V");
            }
            if (needAudio) {
                cmdList.add("-map");
                cmdList.add("0:a:" + hlsConfiguration.audioStream);
            }
        }
        cmdList.add("-dn");
        cmdList.add("-copyts");
        if (needVideo) {
            int level;
            if (hlsConfiguration.video.resolutionWidth > 0) {
                cmdList.add("-s:v");
                cmdList.add(String.valueOf(hlsConfiguration.video.resolutionWidth) + "x" + String.valueOf(hlsConfiguration.video.resolutionHeight));
            }
            cmdList.add("-c:v");
            if (!hlsConfiguration.video.videoCodec.startsWith("avc1.")) {
                LOGGER.error("Something wrong, hls codec not handled: {}", (Object)hlsConfiguration.video.videoCodec);
                return null;
            }
            String selectedTranscodeAccelerationMethod = configuration.getFFmpegGPUH264EncodingAccelerationMethod();
            cmdList.add(selectedTranscodeAccelerationMethod);
            cmdList.add("-keyint_min");
            cmdList.add("25");
            if (selectedTranscodeAccelerationMethod.startsWith("libx264")) {
                cmdList.add("-preset");
                if (hlsConfiguration.video.resolutionWidth < 842) {
                    cmdList.add("superfast");
                } else {
                    cmdList.add("ultrafast");
                }
            }
            if (hlsConfiguration.video.videoCodec.startsWith("avc1.64")) {
                cmdList.add("-profile:v");
                cmdList.add("high");
            } else if (hlsConfiguration.video.videoCodec.startsWith("avc1.4D")) {
                cmdList.add("-profile:v");
                cmdList.add("main");
            } else if (hlsConfiguration.video.videoCodec.startsWith("avc1.42")) {
                cmdList.add("-profile:v");
                cmdList.add("baseline");
            }
            String hexLevel = hlsConfiguration.video.videoCodec.substring(hlsConfiguration.video.videoCodec.length() - 2);
            try {
                level = Integer.parseInt(hexLevel, 16);
            }
            catch (NumberFormatException nfe) {
                level = 30;
            }
            cmdList.add("-level");
            cmdList.add(String.valueOf(level));
            cmdList.add("-pix_fmt");
            cmdList.add("yuv420p");
        } else {
            cmdList.add("-vn");
        }
        if (needAudio) {
            cmdList.add("-c:a");
            if (hlsConfiguration.audio.audioCodec.startsWith("mp4a.40.")) {
                if (!hlsConfiguration.audio.audioCodec.endsWith(".2")) {
                    LOGGER.trace("Something wrong, falling back to aac");
                }
                cmdList.add("aac");
            } else {
                cmdList.add("ac3");
            }
            if (hlsConfiguration.audio.audioChannels != 0) {
                cmdList.add("-ac");
                cmdList.add(String.valueOf(hlsConfiguration.audio.audioChannels));
            }
            if (hlsConfiguration.audio.audioBitRate > 0) {
                cmdList.add("-ab");
                cmdList.add(String.valueOf(hlsConfiguration.audio.audioBitRate));
            }
        } else {
            cmdList.add("-an");
        }
        FFmpegHlsVideo.setEncodingThreads(cmdList, configuration);
        cmdList.add("-f");
        if (needSubtitle && !needAudio && !needVideo) {
            cmdList.add("webvtt");
        } else {
            cmdList.add("mpegts");
            cmdList.add("-skip_estimate_duration_from_pts");
            cmdList.add("1");
            cmdList.add("-use_wallclock_as_timestamps");
            cmdList.add("1");
            cmdList.add("-movflags");
            cmdList.add("frag_keyframe");
        }
        return FFmpegHlsVideo.runHlsTranscodeProcess(params, cmdList);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && encodingFormat.isTranscodeToHLS();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMimeType() {
        return "application/x-mpegURL";
    }
}

