/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.pms.dlna.protocolinfo.DLNAOrgConversionIndicator;
import net.pms.dlna.protocolinfo.DLNAOrgFlags;
import net.pms.dlna.protocolinfo.DLNAOrgOperations;
import net.pms.dlna.protocolinfo.DLNAOrgPlaySpeeds;
import net.pms.dlna.protocolinfo.DLNAOrgProfileName;
import net.pms.dlna.protocolinfo.MimeType;
import net.pms.dlna.protocolinfo.ProfileName;
import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.Protocol;
import org.jupnp.support.model.dlna.DLNAAttribute;
import org.jupnp.support.model.dlna.DLNAProfiles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolInfo
implements Comparable<ProtocolInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolInfo.class);
    public static final String WILDCARD = "*";
    public static final SortedMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> EMPTYMAP = Collections.unmodifiableSortedMap(ProtocolInfo.createEmptyAttributesMap());
    protected final Protocol protocol;
    protected final String network;
    protected final MimeType mimeType;
    protected final String additionalInfo;
    protected final SortedMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> attributes;
    protected final String attributesString;
    protected final String stringValue;

    public ProtocolInfo(String protocolInfoString) throws ParseException {
        String tmpNetwork = WILDCARD;
        MimeType tmpMimeType = MimeType.ANYANY;
        String tmpAdditionalInfo = WILDCARD;
        if (StringUtils.isBlank(protocolInfoString)) {
            this.protocol = Protocol.ALL;
        } else {
            protocolInfoString = protocolInfoString.trim();
            String[] elements = protocolInfoString.split("\\s*:\\s*");
            this.protocol = Protocol.value(elements[0]);
            if (elements.length > 1) {
                tmpNetwork = elements[1];
            }
            if (elements.length > 2) {
                tmpMimeType = this.createMimeType(elements[2]);
            }
            if (elements.length > 3) {
                tmpAdditionalInfo = elements[3];
            }
            if (elements.length > 4) {
                throw new ParseException("Invalid protocolInfo string \"" + protocolInfoString + "\"");
            }
        }
        this.network = tmpNetwork;
        this.mimeType = tmpMimeType;
        this.additionalInfo = tmpAdditionalInfo;
        this.attributes = Collections.unmodifiableSortedMap(this.parseAdditionalInfo());
        this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, String contentFormat, String additionalInfo) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = this.createMimeType(contentFormat);
        this.additionalInfo = StringUtils.isBlank(additionalInfo) ? WILDCARD : additionalInfo;
        this.attributes = Collections.unmodifiableSortedMap(this.parseAdditionalInfo());
        this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, MimeType mimeType, String additionalInfo) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = mimeType == null ? MimeType.ANYANY : mimeType;
        this.additionalInfo = StringUtils.isBlank(additionalInfo) ? WILDCARD : additionalInfo;
        this.attributes = Collections.unmodifiableSortedMap(this.parseAdditionalInfo());
        this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, String contentFormat, Map<ProtocolInfoAttributeName, ProtocolInfoAttribute> attributes) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = this.createMimeType(contentFormat);
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> tmpAttributes = ProtocolInfo.createEmptyAttributesMap();
        tmpAttributes.putAll(attributes);
        this.attributes = Collections.unmodifiableSortedMap(tmpAttributes);
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, MimeType mimeType, Map<ProtocolInfoAttributeName, ProtocolInfoAttribute> attributes) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = mimeType == null ? MimeType.ANYANY : mimeType;
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> tmpAttributes = ProtocolInfo.createEmptyAttributesMap();
        tmpAttributes.putAll(attributes);
        this.attributes = Collections.unmodifiableSortedMap(tmpAttributes);
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, String contentFormat, EnumMap<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = this.createMimeType(contentFormat);
        this.attributes = Collections.unmodifiableSortedMap(ProtocolInfo.dlnaAttributesToAttributes(attributes));
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, String network, MimeType mimeType, EnumMap<DLNAAttribute.Type, DLNAAttribute<?>> attributes) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = StringUtils.isBlank(network) ? WILDCARD : network;
        this.mimeType = mimeType == null ? MimeType.ANYANY : mimeType;
        this.attributes = Collections.unmodifiableSortedMap(ProtocolInfo.dlnaAttributesToAttributes(attributes));
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, DLNAProfiles profile) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = WILDCARD;
        this.mimeType = this.createMimeType(profile.getContentFormat());
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> tmpAttributes = ProtocolInfo.createEmptyAttributesMap();
        DLNAOrgProfileName profileName = (DLNAOrgProfileName)DLNAOrgProfileName.FACTORY.createProfileName(profile.getCode());
        tmpAttributes.put(profileName.getName(), profileName);
        this.attributes = Collections.unmodifiableSortedMap(tmpAttributes);
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(Protocol protocol, DLNAProfiles profile, EnumMap<DLNAAttribute.Type, DLNAAttribute<?>> dlnaAttributes) {
        this.protocol = protocol == null ? Protocol.ALL : protocol;
        this.network = WILDCARD;
        this.mimeType = this.createMimeType(profile.getContentFormat());
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> tmpAttributes = ProtocolInfo.dlnaAttributesToAttributes(dlnaAttributes);
        DLNAOrgProfileName profileName = (DLNAOrgProfileName)DLNAOrgProfileName.FACTORY.createProfileName(profile.getCode());
        tmpAttributes.put(profileName.getName(), profileName);
        this.attributes = Collections.unmodifiableSortedMap(tmpAttributes);
        this.additionalInfo = this.attributesString = this.generateAttributesString();
        this.stringValue = this.generateStringValue();
    }

    public ProtocolInfo(org.jupnp.support.model.ProtocolInfo template) {
        this(template.getProtocol(), template.getNetwork(), template.getContentFormat(), template.getAdditionalInfo());
    }

    public DLNAOrgProfileName getDLNAProfileName() {
        ProtocolInfoAttribute pnAttribute = (ProtocolInfoAttribute)this.attributes.get(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_PN);
        return pnAttribute instanceof DLNAOrgProfileName ? (DLNAOrgProfileName)pnAttribute : null;
    }

    public DLNAOrgOperations getDLNAOperations() {
        ProtocolInfoAttribute operationsAttribute = (ProtocolInfoAttribute)this.attributes.get(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_OP);
        return operationsAttribute instanceof DLNAOrgOperations ? (DLNAOrgOperations)operationsAttribute : null;
    }

    public DLNAOrgPlaySpeeds getDLNAPlaySpeeds() {
        ProtocolInfoAttribute playSpeedsAttribute = (ProtocolInfoAttribute)this.attributes.get(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_PS);
        return playSpeedsAttribute instanceof DLNAOrgPlaySpeeds ? (DLNAOrgPlaySpeeds)playSpeedsAttribute : null;
    }

    public DLNAOrgConversionIndicator getDLNAConversionIndicator() {
        ProtocolInfoAttribute conversionIndicatorAttribute = (ProtocolInfoAttribute)this.attributes.get(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_CI);
        return conversionIndicatorAttribute instanceof DLNAOrgConversionIndicator ? (DLNAOrgConversionIndicator)conversionIndicatorAttribute : null;
    }

    public DLNAOrgFlags getFlags() {
        ProtocolInfoAttribute flagsAttribute = (ProtocolInfoAttribute)this.attributes.get(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_FLAGS);
        return flagsAttribute instanceof DLNAOrgFlags ? (DLNAOrgFlags)flagsAttribute : null;
    }

    public ProfileName getProfileName() {
        for (ProtocolInfoAttribute attribute : this.attributes.values()) {
            if (!(attribute instanceof ProfileName)) continue;
            ProfileName profileName = (ProfileName)attribute;
            return profileName;
        }
        return null;
    }

    public String getAttributesString() {
        return this.attributesString;
    }

    private String generateAttributesString() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (ProtocolInfoAttribute attribute : this.attributes.values()) {
            String attributeString = attribute.getAttributeString();
            if (!StringUtils.isNotBlank(attributeString)) continue;
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(attributeString);
        }
        return sb.toString();
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    private MimeType createMimeType(String contentFormat) {
        try {
            return MimeType.valueOf(contentFormat);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing MimeType from \"{}\": {}", (Object)contentFormat, (Object)e.getMessage());
            LOGGER.trace("", e);
            return MimeType.ANYANY;
        }
    }

    public org.jupnp.util.MimeType getSeamlessMimeType() throws IllegalArgumentException {
        return org.jupnp.util.MimeType.valueOf(this.mimeType.toString());
    }

    private SortedMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> parseAdditionalInfo() {
        String[] attributeStrings;
        if (StringUtils.isBlank(this.additionalInfo) || WILDCARD.equals(this.additionalInfo.trim())) {
            return EMPTYMAP;
        }
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> result = ProtocolInfo.createEmptyAttributesMap();
        for (String attributeString : attributeStrings = this.additionalInfo.trim().toUpperCase(Locale.ROOT).split("\\s*;\\s*")) {
            if (StringUtils.isBlank(attributeString)) continue;
            String[] attributeEntry = attributeString.split("\\s*=\\s*");
            if (attributeEntry.length == 2) {
                try {
                    ProtocolInfoAttribute attribute = ProtocolInfoAttribute.FACTORY.createAttribute(attributeEntry[0], attributeEntry[1], this.protocol);
                    if (attribute != null) {
                        result.put(attribute.getName(), attribute);
                        continue;
                    }
                    LOGGER.debug("Failed to parse attribute \"{}\"", (Object)attributeString);
                }
                catch (ParseException e) {
                    LOGGER.debug("Failed to parse attribute \"{}\": {}", (Object)attributeString, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
                continue;
            }
            LOGGER.debug("Invalid ProtocolInfo attribute \"{}\"", (Object)attributeString);
        }
        return result;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getContentFormat() {
        return this.mimeType.toString();
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public SortedMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> getAttributes() {
        return this.attributes;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Protocol: ").append((Object)this.protocol).append(", Network: ").append(this.network).append(", ContentFormat/MimeType: ").append(this.mimeType);
        if (StringUtils.isNotBlank(this.additionalInfo)) {
            sb.append(", AdditionalInfo: ").append(this.additionalInfo);
        }
        if (!this.mimeType.toString().equals(this.mimeType.toStringWithoutParameters())) {
            sb.append(", Simple MimeType: ").append(this.mimeType.toStringWithoutParameters());
        }
        if (this.mimeType.isDRM()) {
            sb.append(", DRM");
        }
        if (!this.mimeType.getParameters().isEmpty()) {
            sb.append(", MimeType Parameters: ").append(this.mimeType.getParameters());
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append(", Attributes: ").append(this.attributes);
        }
        return sb.toString();
    }

    public String toString() {
        return this.stringValue;
    }

    private String generateStringValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol == null ? WILDCARD : this.protocol).append(":").append(StringUtils.isBlank(this.network) ? WILDCARD : this.network).append(":").append(this.mimeType == null ? MimeType.ANYANY : this.mimeType).append(":").append(StringUtils.isBlank(this.attributesString) ? WILDCARD : this.attributesString);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.attributesString == null ? 0 : this.attributesString.hashCode());
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtocolInfo)) {
            return false;
        }
        ProtocolInfo other = (ProtocolInfo)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.attributesString == null ? other.attributesString != null : !this.attributesString.equals(other.attributesString)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        if (this.network == null ? other.network != null : !this.network.equals(other.network)) {
            return false;
        }
        return this.protocol == other.protocol;
    }

    public static TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> dlnaAttributesToAttributes(EnumMap<DLNAAttribute.Type, DLNAAttribute<?>> dlnaAttributes) {
        TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> attributes = ProtocolInfo.createEmptyAttributesMap();
        for (Map.Entry<DLNAAttribute.Type, DLNAAttribute<?>> entry : dlnaAttributes.entrySet()) {
            try {
                ProtocolInfoAttribute attribute = ProtocolInfoAttribute.FACTORY.createAttribute(entry.getKey().getAttributeName(), entry.getValue().getString(), Protocol.HTTP_GET);
                if (attribute == null) continue;
                attributes.put(attribute.getName(), attribute);
            }
            catch (ParseException e) {
                LOGGER.debug("Couldn't parse DLNAAttribute \"{}\" = \"{}\": {}", entry.getKey().getAttributeName(), entry.getValue().getString(), e.getMessage());
                LOGGER.trace("", e);
            }
        }
        return attributes;
    }

    public static TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute> createEmptyAttributesMap() {
        return new TreeMap<ProtocolInfoAttributeName, ProtocolInfoAttribute>(new AttributeComparator());
    }

    @Override
    public int compareTo(ProtocolInfo other) {
        int result;
        if (other == null) {
            return -1;
        }
        if (this.protocol == null && other.protocol != null) {
            return 1;
        }
        if (this.protocol != null && other.protocol == null) {
            return -1;
        }
        if (this.protocol != null && other.protocol != null && (result = this.protocol.compareTo(other.protocol)) != 0) {
            return result;
        }
        if (this.network == null && other.network != null) {
            return 1;
        }
        if (this.network != null && other.network == null) {
            return -1;
        }
        if (this.network != null && other.network != null && (result = this.network.compareTo(other.network)) != 0) {
            return result;
        }
        if (this.mimeType == null && other.mimeType != null) {
            return 1;
        }
        if (this.mimeType != null && other.mimeType == null) {
            return -1;
        }
        if (this.mimeType != null && other.mimeType != null && (result = this.mimeType.compareTo(other.mimeType)) != 0) {
            return result;
        }
        if (this.additionalInfo == null && other.additionalInfo != null) {
            return 1;
        }
        if (this.additionalInfo != null && other.additionalInfo == null) {
            return -1;
        }
        if (this.additionalInfo != null && other.additionalInfo != null) {
            return this.additionalInfo.compareTo(other.additionalInfo);
        }
        return 0;
    }

    public static class AttributeComparator
    implements Comparator<ProtocolInfoAttributeName>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static final List<ProtocolInfoAttributeName> DEFINED_ORDER = List.of(ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_OP, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_PS, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_CI, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_FLAGS, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.ARIB_OR_JP_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DTV_MVP_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.PANASONIC_COM_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.MICROSOFT_COM_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.SHARP_COM_PN, ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.SONY_COM_PN);

        @Override
        public int compare(ProtocolInfoAttributeName o1, ProtocolInfoAttributeName o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int o1Index = DEFINED_ORDER.indexOf(o1);
            int o2Index = DEFINED_ORDER.indexOf(o2);
            if (o1Index >= 0 && o2Index >= 0) {
                return o1Index - o2Index;
            }
            if (o1Index < 0 && o2Index < 0) {
                return o1.getName().compareTo(o2.getName());
            }
            if (o1Index < 0) {
                return 1;
            }
            if (o2Index < 0) {
                return -1;
            }
            String o1Name = o1.getName();
            String o2Name = o2.getName();
            if (o1Name == null && o2Name == null) {
                return 0;
            }
            if (o1Name == null) {
                return 1;
            }
            if (o2Name == null) {
                return -1;
            }
            return o1Name.compareTo(o2Name);
        }
    }
}

