/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import net.pms.dlna.DLNAImageProfile;
import net.pms.encoders.AviSynthFFmpeg;
import net.pms.encoders.AviSynthMEncoder;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.TranscodingSettings;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.encoders.VLCVideo;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlnaHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DlnaHelper.class);
    private static final String[] DLNA_LOCALES = new String[]{"NA", "JP", "EU"};

    protected DlnaHelper() {
    }

    public static String getDlnaContentFeatures(StoreItem resource) {
        int localizationValue = 1;
        String dlnaOrgPnFlags = DlnaHelper.getDlnaOrgPnFlags(resource, localizationValue);
        return (String)(dlnaOrgPnFlags != null ? dlnaOrgPnFlags + ";" : "") + DlnaHelper.getDlnaOrgOpFlags(resource) + ";DLNA.ORG_CI=0;DLNA.ORG_FLAGS=01700000000000000000000000000000";
    }

    public static String getDlnaImageContentFeatures(StoreResource resource, DLNAImageProfile profile, boolean thumbnailRequest) {
        StringBuilder sb = new StringBuilder();
        if (profile != null) {
            sb.append("DLNA.ORG_PN=").append(profile);
        }
        MediaInfo mediaInfo = resource.getMediaInfo();
        ImageInfo thumbnailImageInf = null;
        if (resource.getThumbnailImageInfo() != null) {
            thumbnailImageInf = resource.getThumbnailImageInfo();
        } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
            thumbnailImageInf = mediaInfo.getThumbnail().getImageInfo();
        }
        ImageInfo imageInfo = null;
        if (thumbnailRequest) {
            imageInfo = thumbnailImageInf;
        } else if (mediaInfo != null) {
            imageInfo = mediaInfo.getImageInfo();
        }
        if (profile != null && !thumbnailRequest && thumbnailImageInf != null && profile.useThumbnailSource(imageInfo, thumbnailImageInf)) {
            imageInfo = thumbnailImageInf;
        }
        if (profile != null && imageInfo != null) {
            DLNAImageProfile.HypotheticalResult hypotheticalResult = profile.calculateHypotheticalProperties(imageInfo);
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append("DLNA.ORG_CI=").append(hypotheticalResult.conversionNeeded ? "1" : "0");
        }
        if (sb.length() > 0) {
            sb.append(';');
        }
        sb.append("DLNA.ORG_FLAGS=00900000000000000000000000000000");
        return sb.toString();
    }

    protected static int getDLNALocalesCount() {
        return DLNA_LOCALES.length;
    }

    protected static String getDlnaOrgOpFlags(StoreItem item) {
        String dlnaOrgOpFlags = "01";
        Renderer renderer = item.getDefaultRenderer();
        if (renderer.isTranscodeSeekByTime() && item.isTranscoded() && item.getTranscodingSettings().getEngine().isTimeSeekable()) {
            dlnaOrgOpFlags = renderer.isTranscodeSeekByTimeExclusive() ? "10" : "11";
        }
        return "DLNA.ORG_OP=" + dlnaOrgOpFlags;
    }

    protected static String getDlnaOrgPnFlags(StoreItem item, int localizationValue) {
        String mime = item.getRendererMimeType();
        Renderer renderer = item.getDefaultRenderer();
        TranscodingSettings transcodingSettings = item.getTranscodingSettings();
        EncodingFormat encodingFormat = transcodingSettings != null ? transcodingSettings.getEncodingFormat() : null;
        MediaInfo mediaInfo = item.getMediaInfo();
        MediaSubtitle mediaSubtitle = item.getMediaSubtitle();
        MediaVideo defaultVideoTrack = mediaInfo != null ? mediaInfo.getDefaultVideoTrack() : null;
        MediaAudio defaultAudioTrack = mediaInfo != null ? mediaInfo.getDefaultAudioTrack() : null;
        MediaAudio mediaAudio = item.getMediaAudio();
        MediaSubtitle resolvedSubtitle = mediaSubtitle;
        Object dlnaOrgPnFlags = null;
        if (renderer.isDLNAOrgPNUsed() || renderer.isAccurateDLNAOrgPN()) {
            if (renderer.isPS3()) {
                if (mime.equals("video/x-divx")) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=AVI";
                } else if (mime.equals("video/x-ms-wmv") && defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getWmvOrgPN(mediaInfo, encodingFormat);
                }
            } else if (mime.equals("video/x-divx")) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=AVI";
            } else if (mime.equals("video/x-ms-wmv") && defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getWmvOrgPN(mediaInfo, encodingFormat);
            } else if (mime.equals("video/mpeg") || mime.equals("application/x-mpegURL") || mime.equals("application/vnd.apple.mpegURL")) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegPsOrgPN(localizationValue);
                if (transcodingSettings != null) {
                    boolean isOutputtingMPEGTS;
                    boolean bl = isOutputtingMPEGTS = TsMuxeRVideo.ID.equals(transcodingSettings.getEngine().getEngineId()) || VideoLanVideoStreaming.ID.equals(transcodingSettings.getEngine().getEngineId());
                    if (!isOutputtingMPEGTS && transcodingSettings.getEncodingFormat().isTranscodeToMPEGTS() && (MEncoderVideo.ID.equals(transcodingSettings.getEngine().getEngineId()) || FFMpegVideo.ID.equals(transcodingSettings.getEngine().getEngineId()) || VLCVideo.ID.equals(transcodingSettings.getEngine().getEngineId()) || AviSynthFFmpeg.ID.equals(transcodingSettings.getEngine().getEngineId()) || AviSynthMEncoder.ID.equals(transcodingSettings.getEngine().getEngineId()))) {
                        isOutputtingMPEGTS = true;
                    }
                    if (!isOutputtingMPEGTS && (renderer.getUmsConfiguration().isMencoderMuxWhenCompatible() && MEncoderVideo.ID.equals(transcodingSettings.getEngine().getEngineId()) || renderer.getUmsConfiguration().isFFmpegMuxWithTsMuxerWhenCompatible() && FFMpegVideo.ID.equals(transcodingSettings.getEngine().getEngineId()))) {
                        if (renderer.isAccurateDLNAOrgPN()) {
                            if (resolvedSubtitle == null) {
                                MediaAudio audio = mediaAudio != null ? mediaAudio : item.resolveAudioStream();
                                resolvedSubtitle = item.resolveSubtitlesStream(audio == null ? null : audio.getLang(), false);
                            }
                            if (resolvedSubtitle == null) {
                                LOGGER.trace("We do not want a subtitle for {}", (Object)item.getName());
                            } else {
                                LOGGER.trace("We do want a subtitle for {}", (Object)item.getName());
                            }
                        }
                        if (resolvedSubtitle == null && !item.hasExternalSubtitles() && mediaInfo != null && mediaInfo.getDvdtrack() == null && Engine.isMuxable(mediaInfo.getDefaultVideoTrack(), renderer) && renderer.isVideoStreamTypeSupportedInTranscodingContainer(mediaInfo, transcodingSettings.getEncodingFormat(), "mpegts")) {
                            isOutputtingMPEGTS = true;
                        }
                    }
                    if (isOutputtingMPEGTS) {
                        if (transcodingSettings.getEncodingFormat().isTranscodeToH264() && !VideoLanVideoStreaming.ID.equals(transcodingSettings.getEngine().getEngineId())) {
                            dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsH264OrgPN(localizationValue, false);
                        } else if (transcodingSettings.getEncodingFormat().isTranscodeToMPEG2()) {
                            dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsMpeg2OrgPN(localizationValue, mediaInfo, false);
                        }
                    }
                } else if (mediaInfo != null && mediaInfo.isMpegTS() && defaultVideoTrack != null) {
                    if (defaultVideoTrack.isH264()) {
                        dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsH264OrgPN(localizationValue, true);
                    } else if (defaultVideoTrack.isMpeg2()) {
                        dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsMpeg2OrgPN(localizationValue, mediaInfo, true);
                    }
                }
            } else if (mediaInfo != null && mime.equals("video/vnd.dlna.mpeg-tts")) {
                if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.isH264() || encodingFormat != null && encodingFormat.isTranscodeToH264()) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsH264OrgPN(localizationValue, !item.isTranscoded());
                } else if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.isMpeg2() || encodingFormat != null && encodingFormat.isTranscodeToMPEG2()) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMpegTsMpeg2OrgPN(localizationValue, mediaInfo, !item.isTranscoded());
                }
            } else if (mediaInfo != null && mime.equals("video/mp4")) {
                if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.isH265() && defaultAudioTrack != null && (defaultAudioTrack.isAC3() || defaultAudioTrack.isEAC3() || defaultAudioTrack.isHEAAC())) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=DASH_HEVC_MP4_UHD_NA";
                } else if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.isH264()) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMp4H264OrgPN(mediaInfo, encodingFormat);
                }
            } else if (mediaInfo != null && mime.equals("video/x-matroska")) {
                if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.isH264()) {
                    dlnaOrgPnFlags = "DLNA.ORG_PN=" + DlnaHelper.getMkvH264OrgPN(mediaInfo, null);
                }
            } else if (mediaInfo != null && mime.equals("video/x-ms-asf")) {
                if (!item.isTranscoded() && defaultVideoTrack != null && defaultVideoTrack.getCodec().equals("vc1") && defaultAudioTrack != null && defaultAudioTrack.isWMA()) {
                    dlnaOrgPnFlags = mediaInfo.getDefaultVideoTrack() != null && mediaInfo.getDefaultVideoTrack().isHDVideo() ? "DLNA.ORG_PN=VC1_ASF_AP_L2_WMA" : "DLNA.ORG_PN=VC1_ASF_AP_L1_WMA";
                }
            } else if (mediaInfo != null && mime.equals("image/jpeg")) {
                int width = mediaInfo.getWidth();
                int height = mediaInfo.getHeight();
                dlnaOrgPnFlags = width > 1024 || height > 768 ? "DLNA.ORG_PN=JPEG_LRG" : (width > 640 || height > 480 ? "DLNA.ORG_PN=JPEG_MED" : (width > 160 || height > 160 ? "DLNA.ORG_PN=JPEG_SM" : "DLNA.ORG_PN=JPEG_TN"));
            } else if (mime.equals("audio/mpeg")) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=MP3";
            } else if (mime.substring(0, 9).equals("audio/L16") || mime.equals("audio/wav")) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=LPCM";
            }
            if (dlnaOrgPnFlags != null) {
                dlnaOrgPnFlags = "DLNA.ORG_PN=" + renderer.getDlnaProfileId(((String)dlnaOrgPnFlags).substring(12));
            }
        }
        return dlnaOrgPnFlags;
    }

    private static String getMpegPsOrgPN(int index) {
        if (index == 1 || index == 2) {
            return "MPEG_PS_NTSC";
        }
        return "MPEG_PS_PAL";
    }

    private static String getMpegTsMpeg2OrgPN(int index, MediaInfo media, boolean isStreaming) {
        Object orgPN = "MPEG_TS_";
        orgPN = media != null && media.getDefaultVideoTrack() == null && media.getDefaultVideoTrack().isHDVideo() ? (String)orgPN + "HD" : (String)orgPN + "SD";
        orgPN = (String)orgPN + (switch (index) {
            case 1 -> "_NA";
            case 2 -> "_JP";
            default -> "_EU";
        });
        if (!isStreaming) {
            orgPN = (String)orgPN + "_ISO";
        }
        return orgPN;
    }

    private static String getMpegTsH264OrgPN(int index, boolean isStreaming) {
        Object orgPN = "AVC_TS";
        orgPN = (String)orgPN + (switch (index) {
            case 1 -> "_NA";
            case 2 -> "_JP";
            default -> "_EU";
        });
        if (!isStreaming) {
            orgPN = (String)orgPN + "_ISO";
        }
        return orgPN;
    }

    private static String getMkvH264OrgPN(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "AVC_MKV";
        orgPN = media == null || media.getDefaultVideoTrack() == null || media.getDefaultVideoTrack().getFormatProfile() == null || media.getDefaultVideoTrack().getFormatProfile().contains("high") ? (String)orgPN + "_HP" : (String)orgPN + "_MP";
        orgPN = (String)orgPN + "_HD";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && media.getDefaultAudioTrack().isAACLC() || encodingFormat != null && encodingFormat.isTranscodeToAAC()) {
                orgPN = (String)orgPN + "_AAC_MULT5";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isAC3() || encodingFormat != null && encodingFormat.isTranscodeToAC3()) {
                orgPN = (String)orgPN + "_AC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTS()) {
                orgPN = (String)orgPN + "_DTS";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isEAC3()) {
                orgPN = (String)orgPN + "_EAC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isHEAAC()) {
                orgPN = (String)orgPN + "_HEAAC_L4";
            }
        }
        return orgPN;
    }

    private static String getMp4H264OrgPN(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "AVC_MP4";
        orgPN = media != null && media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().getFormatProfile() != null ? (media.getDefaultVideoTrack().getFormatProfile().contains("high") ? (encodingFormat == null && media.getDefaultAudioTrack() != null && media.getDefaultAudioTrack().isHEAAC() ? (String)orgPN + "_HD_HEAACv2_L6" : (String)orgPN + "_HP_HD") : (media.getDefaultVideoTrack().getFormatProfile().contains("baseline") ? (String)orgPN + "_BL" : (String)orgPN + "_MP_SD")) : (String)orgPN + "_MP_SD";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && (media.getDefaultAudioTrack().isAC3() || media.getDefaultAudioTrack().isEAC3()) || encodingFormat != null && encodingFormat.isTranscodeToAC3()) {
                orgPN = (String)orgPN + "_EAC3";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTS()) {
                orgPN = (String)orgPN + "_DTS";
            } else if (encodingFormat == null && media.getDefaultAudioTrack().isDTSHD()) {
                orgPN = (String)orgPN + "_DTSHD";
            }
        }
        return orgPN;
    }

    private static String getWmvOrgPN(MediaInfo media, EncodingFormat encodingFormat) {
        Object orgPN = "WMV";
        orgPN = media != null && media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().isHDVideo() ? (String)orgPN + "HIGH" : (String)orgPN + "MED";
        if (media != null && media.getDefaultAudioTrack() != null) {
            if (encodingFormat == null && media.getDefaultAudioTrack().isWMA() || encodingFormat != null && encodingFormat.isTranscodeToWMV()) {
                orgPN = (String)orgPN + "_FULL";
            } else if (encodingFormat == null && (media.getDefaultAudioTrack().isWMAPro() || media.getDefaultAudioTrack().isWMA10())) {
                orgPN = (String)orgPN + "_PRO";
            }
        }
        return orgPN;
    }
}

