/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import com.drew.metadata.Metadata;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAProfileException;
import net.pms.dlna.DLNAThumbnail;
import net.pms.image.Image;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLNAImage
extends Image {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DLNAImage.class);
    protected final DLNAImageProfile profile;

    public DLNAImage(Image image, DLNAImageProfile profile, boolean copy) throws DLNAProfileException {
        super(image, copy);
        DLNAImageProfile dLNAImageProfile = this.profile = profile != null ? profile : DLNAImage.findMatchingProfile(this.imageInfo, this instanceof DLNAThumbnail);
        if (this.profile == null) {
            throw new NullPointerException("DLNAImage: profile cannot be null");
        }
        this.checkCompliance();
    }

    public DLNAImage(byte[] bytes, ImageInfo imageInfo, DLNAImageProfile profile, boolean copy) throws DLNAProfileException {
        super(bytes, imageInfo, copy);
        DLNAImageProfile dLNAImageProfile = this.profile = profile != null ? profile : DLNAImage.findMatchingProfile(imageInfo, this instanceof DLNAThumbnail);
        if (this.profile == null) {
            throw new NullPointerException("DLNAImage: profile cannot be null");
        }
        this.checkCompliance();
    }

    public DLNAImage(byte[] bytes, int width, int height, ImageFormat format, ColorModel colorModel, Metadata metadata, DLNAImageProfile profile, boolean copy) throws DLNAProfileException, ParseException {
        super(bytes, width, height, format, colorModel, metadata, true, copy);
        DLNAImageProfile dLNAImageProfile = this.profile = profile != null ? profile : DLNAImage.findMatchingProfile(this.imageInfo, this instanceof DLNAThumbnail);
        if (this.profile == null) {
            throw new NullPointerException("DLNAImage: profile cannot be null");
        }
        this.checkCompliance();
    }

    public DLNAImage(byte[] bytes, ImageFormat format, BufferedImage bufferedImage, Metadata metadata, DLNAImageProfile profile, boolean copy) throws DLNAProfileException, ParseException {
        super(bytes, format, bufferedImage, metadata, copy);
        DLNAImageProfile dLNAImageProfile = this.profile = profile != null ? profile : DLNAImage.findMatchingProfile(this.imageInfo, this instanceof DLNAThumbnail);
        if (this.profile == null) {
            throw new NullPointerException("DLNAImage: profile cannot be null");
        }
        this.checkCompliance();
    }

    private void checkCompliance() throws DLNAProfileException {
        DLNAImageProfile.DLNAComplianceResult result = this.profile.checkCompliance(this.imageInfo);
        if (result.isAllCorrect()) {
            return;
        }
        StringBuilder sb = new StringBuilder(150);
        sb.append(this.getClass().getSimpleName()).append(": Compliance check failed for ").append(this.profile);
        List<String> failures = result.getFailures();
        if (!failures.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                sb.append(" with the following failures:\n").append(StringUtils.join(failures, "\n"));
            } else {
                sb.append(" for: ").append(StringUtils.join(failures, ", "));
            }
        }
        throw new DLNAProfileException(sb.toString());
    }

    private static DLNAImageProfile findMatchingProfile(ImageInfo imageInfo, boolean dlnaThumbnail) {
        if (imageInfo == null || imageInfo.getFormat() == null || imageInfo.getWidth() < 1 || imageInfo.getHeight() < 1) {
            return null;
        }
        switch (imageInfo.getFormat()) {
            case GIF: {
                if (dlnaThumbnail || !DLNAImageProfile.GIF_LRG.checkCompliance(imageInfo).isAllCorrect()) break;
                return DLNAImageProfile.GIF_LRG;
            }
            case JPEG: {
                DLNAImageProfile.DLNAComplianceResult result = DLNAImageProfile.JPEG_TN.checkCompliance(imageInfo);
                if (result.isAllCorrect()) {
                    return DLNAImageProfile.JPEG_TN;
                }
                if (!result.isColorsCorrect() || !result.isFormatCorrect()) break;
                if (DLNAImageProfile.JPEG_SM.isResolutionCorrect(imageInfo)) {
                    return DLNAImageProfile.JPEG_SM;
                }
                if (DLNAImageProfile.JPEG_MED.isResolutionCorrect(imageInfo)) {
                    return DLNAImageProfile.JPEG_MED;
                }
                if (DLNAImageProfile.JPEG_LRG.isResolutionCorrect(imageInfo)) {
                    return DLNAImageProfile.JPEG_LRG;
                }
                return DLNAImageProfile.createJPEG_RES_H_V(imageInfo.getWidth(), imageInfo.getHeight());
            }
            case PNG: {
                DLNAImageProfile.DLNAComplianceResult result = DLNAImageProfile.PNG_TN.checkCompliance(imageInfo);
                if (result.isAllCorrect()) {
                    return DLNAImageProfile.PNG_TN;
                }
                if (!result.isColorsCorrect() || !result.isFormatCorrect() || !DLNAImageProfile.PNG_LRG.isResolutionCorrect(imageInfo)) break;
                return DLNAImageProfile.PNG_LRG;
            }
        }
        return null;
    }

    public static DLNAImage toDLNAImage(Image inputImage) throws IOException {
        return DLNAImage.toDLNAImage(inputImage, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAImage toDLNAImage(InputStream inputStream) throws IOException {
        return DLNAImage.toDLNAImage(inputStream, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAImage toDLNAImage(byte[] sourceByteArray) throws IOException {
        return DLNAImage.toDLNAImage(sourceByteArray, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static DLNAImage toDLNAImage(Image inputImage, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputImage == null) {
            return null;
        }
        return (DLNAImage)ImagesUtil.transcodeImage(inputImage, outputProfile, false, padToSize, null);
    }

    public static DLNAImage toDLNAImage(InputStream inputStream, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (DLNAImage)ImagesUtil.transcodeImage(inputStream, outputProfile, false, padToSize, null);
    }

    public static DLNAImage toDLNAImage(byte[] inputByteArray, DLNAImageProfile outputProfile, boolean padToSize) throws IOException {
        if (inputByteArray == null) {
            return null;
        }
        return (DLNAImage)ImagesUtil.transcodeImage(inputByteArray, outputProfile, false, padToSize, null);
    }

    public static DLNAImage toDLNAImage(Image inputImage, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        if (inputImage == null) {
            return null;
        }
        return (DLNAImage)ImagesUtil.transcodeImage(inputImage, width, height, scaleType, outputFormat, true, false, padToSize, null);
    }

    public static DLNAImage toDLNAImage(InputStream inputStream, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        if (inputStream == null) {
            return null;
        }
        return (DLNAImage)ImagesUtil.transcodeImage(inputStream, width, height, scaleType, outputFormat, true, false, padToSize, null);
    }

    public static DLNAImage toDLNAImage(byte[] inputByteArray, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        return (DLNAImage)ImagesUtil.transcodeImage(inputByteArray, width, height, scaleType, outputFormat, true, false, padToSize, null);
    }

    public DLNAImageProfile getDLNAImageProfile() {
        return this.profile;
    }

    @Override
    public DLNAImage copy() {
        try {
            return new DLNAImage(this.bytes, this.imageInfo, this.profile, true);
        }
        catch (DLNAProfileException e) {
            LOGGER.error("Impossible situation in DLNAImage.copy(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.profile != null) {
            sb.append(", DLNA Profile = ").append(this.profile);
        }
    }
}

