/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.pms.database.UserTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTableTablesVersions
extends UserTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTableTablesVersions.class);
    protected static final String TABLE_NAME = "TABLES_VERSIONS";
    private static final String COL_TABLE_NAME = "TABLE_NAME";
    private static final String COL_TABLE_VERSION = "TABLE_VERSION";
    private static final String TABLE_COL_TABLE_NAME = "TABLES_VERSIONS.TABLE_NAME";
    private static final String SQL_GET_ALL_BY_TABLE_NAME = "SELECT * FROM TABLES_VERSIONS WHERE TABLES_VERSIONS.TABLE_NAME = ? LIMIT 1";
    private static final String SQL_GET_VERSION_BY_TABLE_NAME = "SELECT TABLE_VERSION FROM TABLES_VERSIONS WHERE TABLES_VERSIONS.TABLE_NAME = ? LIMIT 1";
    private static final String SQL_DELETE_BY_TABLE_NAME = "DELETE FROM TABLES_VERSIONS WHERE TABLES_VERSIONS.TABLE_NAME = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (!UserTableTablesVersions.tableExists(connection, TABLE_NAME)) {
            UserTableTablesVersions.createTable(connection);
        }
    }

    protected static final void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"USERS", (Object)TABLE_NAME);
        UserTableTablesVersions.execute(connection, "CREATE TABLE TABLES_VERSIONS(TABLE_NAME VARCHAR(50) PRIMARY KEY, TABLE_VERSION INTEGER NOT NULL)");
    }

    protected static final Integer getTableVersion(Connection connection, String tableName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_VERSION_BY_TABLE_NAME);){
            Integer n;
            block17: {
                ResultSet result;
                block15: {
                    Integer n2;
                    block16: {
                        statement.setString(1, tableName);
                        result = statement.executeQuery();
                        try {
                            if (!result.next()) break block15;
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("Table version for database table \"{}\" is {}", (Object)tableName, (Object)result.getInt(1));
                            }
                            n2 = result.getInt(1);
                            if (result == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return n2;
                }
                LOGGER.trace("Table version for database table \"{}\" not found", (Object)tableName);
                n = null;
                if (result == null) break block17;
                result.close();
            }
            return n;
        }
    }

    protected static final void setTableVersion(Connection connection, String tableName, int version) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL_BY_TABLE_NAME, 1005, 1008);){
            statement.setString(1, tableName);
            try (ResultSet result = statement.executeQuery();){
                if (!result.next()) {
                    LOGGER.trace("Setting table version for database table \"{}\" to {}", (Object)tableName, (Object)version);
                    result.moveToInsertRow();
                    result.updateString(COL_TABLE_NAME, tableName);
                    result.updateInt(COL_TABLE_VERSION, version);
                    result.insertRow();
                } else if (result.getInt(COL_TABLE_VERSION) == version) {
                    LOGGER.trace("Table version for database table \"{}\" is already {}, aborting set", (Object)tableName, (Object)version);
                } else {
                    int currentVersion = result.getInt(COL_TABLE_VERSION);
                    LOGGER.trace("Updating table version for database table \"{}\" from {} to {}", tableName, currentVersion, version);
                    result.updateInt(COL_TABLE_VERSION, version);
                    result.updateRow();
                }
            }
        }
    }

    protected static final void removeTableVersion(Connection connection, String tableName) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(SQL_DELETE_BY_TABLE_NAME);){
            statement.setString(1, tableName);
            statement.executeUpdate();
        }
    }
}

