/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.JsonArray;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.video.metadata.ApiStringArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataCountries
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataCountries.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_COUNTRIES";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_COUNTRY = "COUNTRY";
    public static final String TABLE_COL_FILEID = "VIDEO_METADATA_COUNTRIES.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_COUNTRIES.TVSERIESID";
    public static final String TABLE_COL_COUNTRY = "VIDEO_METADATA_COUNTRIES.COUNTRY";
    private static final String SQL_GET_COUNTRY_FILEID = "SELECT VIDEO_METADATA_COUNTRIES.COUNTRY FROM VIDEO_METADATA_COUNTRIES WHERE VIDEO_METADATA_COUNTRIES.FILEID = ?";
    private static final String SQL_GET_COUNTRY_TVSERIESID = "SELECT VIDEO_METADATA_COUNTRIES.COUNTRY FROM VIDEO_METADATA_COUNTRIES WHERE VIDEO_METADATA_COUNTRIES.TVSERIESID = ?";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM VIDEO_METADATA_COUNTRIES WHERE VIDEO_METADATA_COUNTRIES.FILEID = ?";
    private static final String SQL_GET_ALL_TVSERIESID = "SELECT * FROM VIDEO_METADATA_COUNTRIES WHERE VIDEO_METADATA_COUNTRIES.TVSERIESID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataCountries.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataCountries.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataCountries.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataCountries.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataCountries.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "DROP INDEX IF EXISTS FILENAME_COUNTRY_TVSERIESID_IDX");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ADD COLUMN IF NOT EXISTS FILEID INTEGER");
                    if (MediaTableVideoMetadataCountries.isColumnExist(connection, TABLE_NAME, "FILENAME")) {
                        MediaTableVideoMetadataCountries.executeUpdate(connection, "UPDATE VIDEO_METADATA_COUNTRIES SET FILEID=(SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = VIDEO_METADATA_COUNTRIES.FILENAME) WHERE VIDEO_METADATA_COUNTRIES.FILENAME != ''");
                        MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES DROP COLUMN IF EXISTS FILENAME");
                    }
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ALTER COLUMN IF EXISTS TVSERIESID DROP DEFAULT");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "UPDATE VIDEO_METADATA_COUNTRIES SET FILEID = NULL WHERE VIDEO_METADATA_COUNTRIES.FILEID = -1");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "UPDATE VIDEO_METADATA_COUNTRIES SET TVSERIESID = NULL WHERE VIDEO_METADATA_COUNTRIES.TVSERIESID = -1");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ADD CONSTRAINT VIDEO_METADATA_COUNTRIES_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ADD CONSTRAINT VIDEO_METADATA_COUNTRIES_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataCountries.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_COUNTRIES ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataCountries.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataCountries.execute(connection, "CREATE TABLE VIDEO_METADATA_COUNTRIES(ID IDENTITY PRIMARY KEY, TVSERIESID BIGINT, FILEID BIGINT, COUNTRY VARCHAR(1024) NOT NULL, CONSTRAINT VIDEO_METADATA_COUNTRIES_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_COUNTRIES_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)");
    }

    public static void set(Connection connection, Long fileId, ApiStringArray countries, Long tvSeriesID) {
        long id;
        String tableColumn;
        String sqlSelect;
        if (countries == null) {
            return;
        }
        if (tvSeriesID != null) {
            sqlSelect = SQL_GET_ALL_TVSERIESID;
            tableColumn = COL_TVSERIESID;
            id = tvSeriesID;
        } else if (fileId != null) {
            sqlSelect = SQL_GET_ALL_FILEID;
            tableColumn = COL_FILEID;
            id = fileId;
        } else {
            return;
        }
        ArrayList<String> newCountries = new ArrayList<String>(countries);
        try (PreparedStatement ps = connection.prepareStatement(sqlSelect, 1003, 1008);){
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String country = rs.getString(COL_COUNTRY);
                    if (newCountries.contains(country)) {
                        LOGGER.trace("Record \"{}\" already exists {} {} {}", country, tableColumn, id);
                        newCountries.remove(country);
                        continue;
                    }
                    LOGGER.trace("Removing record \"{}\" for {} {}", country, tableColumn, id);
                    rs.deleteRow();
                }
                for (String country : newCountries) {
                    rs.moveToInsertRow();
                    rs.updateLong(tableColumn, id);
                    rs.updateString(COL_COUNTRY, country);
                    rs.insertRow();
                    LOGGER.trace("Set new entry \"{}\" successfully in VIDEO_METADATA_COUNTRIES with {} {}", country, tableColumn, id);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fileId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static ApiStringArray getCountriesForFile(Connection connection, Long fileId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_COUNTRY_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_COUNTRIES for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForFile(Connection connection, Long fileId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_COUNTRY_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_COUNTRIES for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static ApiStringArray getCountriesForTvSeries(Connection connection, Long tvSerieId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_COUNTRY_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_COUNTRIES for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForTvSeries(Connection connection, Long tvSerieId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_COUNTRY_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_COUNTRIES for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }
}

