/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.JsonArray;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.media.video.metadata.ApiStringArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableVideoMetadataActors
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadataActors.class);
    public static final String TABLE_NAME = "VIDEO_METADATA_ACTORS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_FILEID = "FILEID";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_ACTOR = "ACTOR";
    public static final String TABLE_COL_FILEID = "VIDEO_METADATA_ACTORS.FILEID";
    private static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA_ACTORS.TVSERIESID";
    public static final String TABLE_COL_ACTOR = "VIDEO_METADATA_ACTORS.ACTOR";
    private static final String SQL_GET_ACTORS_FILEID = "SELECT VIDEO_METADATA_ACTORS.ACTOR FROM VIDEO_METADATA_ACTORS WHERE VIDEO_METADATA_ACTORS.FILEID = ?";
    private static final String SQL_GET_ACTORS_TVSERIESID = "SELECT VIDEO_METADATA_ACTORS.ACTOR FROM VIDEO_METADATA_ACTORS WHERE VIDEO_METADATA_ACTORS.TVSERIESID = ?";
    private static final String SQL_GET_ALL_FILEID = "SELECT * FROM VIDEO_METADATA_ACTORS WHERE VIDEO_METADATA_ACTORS.FILEID = ?";
    private static final String SQL_GET_ALL_TVSERIESID = "SELECT * FROM VIDEO_METADATA_ACTORS WHERE VIDEO_METADATA_ACTORS.TVSERIESID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadataActors.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    MediaTableVideoMetadataActors.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableVideoMetadataActors.dropTable(connection, TABLE_NAME);
                MediaTableVideoMetadataActors.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            MediaTableVideoMetadataActors.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableVideoMetadataActors.executeUpdate(connection, "DROP INDEX IF EXISTS FILENAME_ACTOR_TVSERIESID_IDX");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ADD COLUMN IF NOT EXISTS FILEID INTEGER");
                    if (MediaTableVideoMetadataActors.isColumnExist(connection, TABLE_NAME, "FILENAME")) {
                        MediaTableVideoMetadataActors.executeUpdate(connection, "UPDATE VIDEO_METADATA_ACTORS SET FILEID = (SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = VIDEO_METADATA_ACTORS.FILENAME) WHERE VIDEO_METADATA_ACTORS.FILENAME != ''");
                        MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS DROP COLUMN IF EXISTS FILENAME");
                    }
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ALTER COLUMN IF EXISTS TVSERIESID DROP  DEFAULT ");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "UPDATE VIDEO_METADATA_ACTORS SET FILEID = NULL WHERE VIDEO_METADATA_ACTORS.FILEID = -1");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "UPDATE VIDEO_METADATA_ACTORS SET TVSERIESID = NULL WHERE VIDEO_METADATA_ACTORS.TVSERIESID = -1");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ADD CONSTRAINT VIDEO_METADATA_ACTORS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ADD CONSTRAINT VIDEO_METADATA_ACTORS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE");
                    continue block4;
                }
                case 2: {
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ALTER COLUMN IF EXISTS FILEID BIGINT");
                    MediaTableVideoMetadataActors.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA_ACTORS ALTER COLUMN IF EXISTS TVSERIESID BIGINT");
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadataActors.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 3));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadataActors.execute(connection, "CREATE TABLE VIDEO_METADATA_ACTORS(ID IDENTITY PRIMARY KEY, TVSERIESID BIGINT, FILEID BIGINT, ACTOR VARCHAR(1024) NOT NULL, CONSTRAINT VIDEO_METADATA_ACTORS_FILEID_FK FOREIGN KEY(FILEID) REFERENCES VIDEO_METADATA(FILEID) ON DELETE CASCADE, CONSTRAINT VIDEO_METADATA_ACTORS_TVSERIESID_FK FOREIGN KEY(TVSERIESID) REFERENCES TV_SERIES(ID) ON DELETE CASCADE)");
    }

    public static void set(Connection connection, Long fileId, ApiStringArray actors, Long tvSeriesID) {
        long id;
        String tableColumn;
        String sqlSelect;
        if (actors == null) {
            return;
        }
        if (tvSeriesID != null) {
            sqlSelect = SQL_GET_ALL_TVSERIESID;
            tableColumn = COL_TVSERIESID;
            id = tvSeriesID;
        } else if (fileId != null) {
            sqlSelect = SQL_GET_ALL_FILEID;
            tableColumn = COL_FILEID;
            id = fileId;
        } else {
            return;
        }
        ArrayList<String> newActors = new ArrayList<String>(actors);
        try (PreparedStatement ps = connection.prepareStatement(sqlSelect, 1003, 1008);){
            ps.setLong(1, id);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String actor = rs.getString(COL_ACTOR);
                    if (newActors.contains(actor)) {
                        LOGGER.trace("Record \"{}\" already exists {} {} {}", actor, tableColumn, id);
                        newActors.remove(actor);
                        continue;
                    }
                    LOGGER.trace("Removing record \"{}\" for {} {}", actor, tableColumn, id);
                    rs.deleteRow();
                }
                for (String actor : newActors) {
                    rs.moveToInsertRow();
                    rs.updateLong(tableColumn, id);
                    rs.updateString(COL_ACTOR, actor);
                    rs.insertRow();
                    LOGGER.trace("Set new entry \"{}\" successfully in VIDEO_METADATA_ACTORS with {} {}", actor, tableColumn, id);
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, fileId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static ApiStringArray getActorsForFile(Connection connection, Long fileId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ACTORS_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_ACTORS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForFile(Connection connection, Long fileId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ACTORS_FILEID);){
            ps.setLong(1, fileId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_ACTORS for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static ApiStringArray getActorsForTvSeries(Connection connection, Long tvSerieId) {
        ApiStringArray result = new ApiStringArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ACTORS_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_ACTORS for TV serie ID \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static JsonArray getJsonArrayForTvSeries(Connection connection, Long tvSerieId) {
        JsonArray result = new JsonArray();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ACTORS_TVSERIESID);){
            ps.setLong(1, tvSerieId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA_ACTORS for \"{}\": {}", (Object)tvSerieId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }
}

