/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.old;

import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.configuration.old.MapFileConfiguration;
import net.pms.configuration.old.WebSourcesConfiguration;
import net.pms.configuration.sharedcontent.ApertureContent;
import net.pms.configuration.sharedcontent.FeedAudioContent;
import net.pms.configuration.sharedcontent.FeedImageContent;
import net.pms.configuration.sharedcontent.FeedVideoContent;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.IPhotoContent;
import net.pms.configuration.sharedcontent.ITunesContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentArray;
import net.pms.configuration.sharedcontent.StreamAudioContent;
import net.pms.configuration.sharedcontent.StreamVideoContent;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldConfigurationImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldConfigurationImporter.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String KEY_FOLDERS = "folders";
    private static final String KEY_FOLDERS_IGNORED = "folders_ignored";
    private static final String KEY_FOLDERS_MONITORED = "folders_monitored";
    private static final String KEY_ITUNES_LIBRARY_PATH = "itunes_library_path";
    private static final String KEY_SHOW_APERTURE_LIBRARY = "show_aperture_library";
    private static final String KEY_SHOW_IPHOTO_LIBRARY = "show_iphoto_library";
    private static final String KEY_SHOW_ITUNES_LIBRARY = "show_itunes_library";

    private OldConfigurationImporter() {
    }

    public static synchronized SharedContentArray getOldConfigurations() {
        List<WebSourcesConfiguration.WebSource> list;
        List<MapFileConfiguration> virtualsFolders;
        SharedContentArray result = new SharedContentArray();
        List<Path> sharedFolders = OldConfigurationImporter.getSharedFolders();
        if (!sharedFolders.isEmpty()) {
            for (Path path : sharedFolders) {
                File file = path.toFile();
                boolean monitored = OldConfigurationImporter.getMonitoredFolders().contains(path);
                result.add(new FolderContent(file, monitored));
            }
        }
        if ((virtualsFolders = MapFileConfiguration.parseVirtualFolders()) != null && !virtualsFolders.isEmpty()) {
            for (MapFileConfiguration virtualsFolder : virtualsFolders) {
                result.add(OldConfigurationImporter.getVirtualFolderFromMapFileConfiguration(virtualsFolder));
            }
        }
        if ((list = WebSourcesConfiguration.getWebSourcesFromConfiguration()) != null && !list.isEmpty()) {
            for (WebSourcesConfiguration.WebSource webSource : list) {
                String sourceType;
                switch (sourceType = webSource.getSourceType()) {
                    case "audiofeed": {
                        result.add(new FeedAudioContent(webSource.getFolderName().replace(",", "/"), webSource.getResourceName(), webSource.getUri()));
                        break;
                    }
                    case "imagefeed": {
                        result.add(new FeedImageContent(webSource.getFolderName().replace(",", "/"), webSource.getResourceName(), webSource.getUri()));
                        break;
                    }
                    case "videofeed": {
                        result.add(new FeedVideoContent(webSource.getFolderName().replace(",", "/"), webSource.getResourceName(), webSource.getUri()));
                        break;
                    }
                    case "audiostream": {
                        result.add(new StreamAudioContent(webSource.getFolderName().replace(",", "/"), webSource.getResourceName(), webSource.getUri(), webSource.getThumbnail()));
                        break;
                    }
                    case "videostream": {
                        result.add(new StreamVideoContent(webSource.getFolderName().replace(",", "/"), webSource.getResourceName(), webSource.getUri(), webSource.getThumbnail()));
                        break;
                    }
                }
            }
        }
        OldConfigurationImporter.ensureiPhotoSettings(result);
        OldConfigurationImporter.ensureApertureSettings(result);
        OldConfigurationImporter.ensureiTunesSettings(result);
        return result;
    }

    private static VirtualFolderContent getVirtualFolderFromMapFileConfiguration(MapFileConfiguration virtualsFolder) {
        String name = virtualsFolder.getName();
        ArrayList<SharedContent> sharedContents = new ArrayList<SharedContent>();
        for (File file : virtualsFolder.getFiles()) {
            sharedContents.add(new FolderContent(file));
        }
        for (MapFileConfiguration child : virtualsFolder.getChildren()) {
            sharedContents.add(OldConfigurationImporter.getVirtualFolderFromMapFileConfiguration(child));
        }
        return new VirtualFolderContent(null, name, sharedContents, virtualsFolder.isAddToMediaLibrary());
    }

    @Nonnull
    private static ArrayList<Path> getFolders(String key) {
        String[] foldersArray;
        String foldersString = CONFIGURATION.getString(key, null);
        ArrayList<Path> folders = new ArrayList<Path>();
        if (foldersString == null || foldersString.length() == 0) {
            return folders;
        }
        for (String folder : foldersArray = foldersString.trim().split("\\s*,\\s*")) {
            folder = folder.replace("&comma;", ",");
            if (KEY_FOLDERS.equals(key)) {
                LOGGER.info("Checking shared folder: \"{}\"", (Object)folder);
            }
            try {
                Path path = Paths.get(folder, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        if (KEY_FOLDERS.equals(key)) {
                            LOGGER.warn("The \"{}\" is not a folder! Please remove it from your shared folders list on the \"Shared Content\" tab or in the configuration file.", (Object)folder);
                        } else {
                            LOGGER.debug("The \"{}\" is not a folder - check the configuration for key \"{}\"", (Object)folder, (Object)key);
                        }
                    }
                } else if (KEY_FOLDERS.equals(key)) {
                    LOGGER.warn("\"{}\" does not exist. Please remove it from your shared folders list on the \"Shared Content\" tab or in the configuration file.", (Object)folder);
                } else {
                    LOGGER.debug("\"{}\" does not exist - check the configuration for key \"{}\"", (Object)folder, (Object)key);
                }
                folders.add(path);
            }
            catch (InvalidPathException ex) {
                LOGGER.info("Invalid path found: {}", (Object)folder);
                LOGGER.debug(null, ex);
            }
        }
        return folders;
    }

    private static List<Path> getSharedFolders() {
        return OldConfigurationImporter.getFolders(KEY_FOLDERS);
    }

    private static List<Path> getMonitoredFolders() {
        return OldConfigurationImporter.getFolders(KEY_FOLDERS_MONITORED);
    }

    private static List<Path> getIgnoredFolders() {
        return OldConfigurationImporter.getFolders(KEY_FOLDERS_IGNORED);
    }

    public static boolean ensureSettingsChanges(SharedContentArray values) {
        boolean updated = OldConfigurationImporter.ensureiPhotoSettings(values);
        updated |= OldConfigurationImporter.ensureApertureSettings(values);
        return updated |= OldConfigurationImporter.ensureiTunesSettings(values);
    }

    private static boolean ensureiPhotoSettings(SharedContentArray values) {
        boolean updated = false;
        if (CONFIGURATION.getBoolean(KEY_SHOW_IPHOTO_LIBRARY, false)) {
            boolean iphotoFound = false;
            for (SharedContent value : values) {
                if (!(value instanceof IPhotoContent)) continue;
                iphotoFound = true;
                break;
            }
            if (!iphotoFound) {
                values.add(new IPhotoContent());
                updated = true;
            }
            CONFIGURATION.getConfiguration().clearProperty(KEY_SHOW_IPHOTO_LIBRARY);
        }
        return updated;
    }

    private static boolean ensureApertureSettings(SharedContentArray values) {
        boolean updated = false;
        if (CONFIGURATION.getBoolean(KEY_SHOW_APERTURE_LIBRARY, false)) {
            boolean apertureFound = false;
            for (SharedContent value : values) {
                if (!(value instanceof ApertureContent)) continue;
                apertureFound = true;
                break;
            }
            if (!apertureFound) {
                values.add(new ApertureContent());
                updated = true;
            }
            CONFIGURATION.getConfiguration().clearProperty(KEY_SHOW_APERTURE_LIBRARY);
        }
        return updated;
    }

    private static boolean ensureiTunesSettings(SharedContentArray values) {
        boolean updated = false;
        if (CONFIGURATION.getBoolean(KEY_SHOW_ITUNES_LIBRARY, false)) {
            String path = CONFIGURATION.getString(KEY_ITUNES_LIBRARY_PATH, "");
            boolean itunesFound = false;
            for (SharedContent value : values) {
                ITunesContent iTunesContent;
                if (!(value instanceof ITunesContent) || !path.equals((iTunesContent = (ITunesContent)value).getPath())) continue;
                itunesFound = true;
                break;
            }
            if (!itunesFound) {
                values.add(new ITunesContent(path));
                updated = true;
            }
            CONFIGURATION.getConfiguration().clearProperty(KEY_SHOW_ITUNES_LIBRARY);
            CONFIGURATION.getConfiguration().clearProperty(KEY_ITUNES_LIBRARY_PATH);
        }
        return updated;
    }
}

