/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import net.pms.PMS;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.UmsConfiguration;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.util.FileWatcher;
import net.pms.util.PropertiesUtil;
import net.pms.util.SortedHeaderMap;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererConfigurations {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererConfigurations.class);
    public static final String ALL_RENDERERS_KEY = "All renderers";
    private static final Object LOAD_RENDERER_CONFIGURATIONS_LOCK = new Object();
    private static final List<String> ALL_RENDERERS_NAMES = Collections.synchronizedList(new ArrayList());
    public static final Comparator<RendererConfiguration> RENDERER_LOADING_PRIORITY_COMPARATOR = (r1, r2) -> {
        int p2;
        if (r1 == null || r2 == null) {
            if (r1 == null && r2 == null) {
                return 0;
            }
            return r1 == null ? 1 : -1;
        }
        int p1 = r1.getLoadingPriority();
        if (p1 > (p2 = r2.getLoadingPriority())) {
            return -1;
        }
        if (p1 < p2) {
            return 1;
        }
        return r1.getConfName().compareToIgnoreCase(r2.getConfName());
    };
    private static final SortedSet<RendererConfiguration> ENABLED_RENDERERS_CONFS = Collections.synchronizedSortedSet(new TreeSet<RendererConfiguration>(RENDERER_LOADING_PRIORITY_COMPARATOR));
    private static final Map<String, PropertiesConfiguration> DEVICES_CONFS = Collections.synchronizedMap(new HashMap());
    private static RendererConfiguration defaultConf;
    private static Renderer defaultRenderer;
    private static final FileWatcher.Listener RELOADER;

    private RendererConfigurations() {
    }

    public static RendererConfiguration getDefaultConf() {
        return defaultConf;
    }

    public static Renderer getDefaultRenderer() {
        return defaultRenderer;
    }

    public static List<RendererConfiguration> getEnabledRenderersConfigurations() {
        return new ArrayList<RendererConfiguration>(ENABLED_RENDERERS_CONFS);
    }

    private static void addRendererConfiguration(RendererConfiguration r) {
        ENABLED_RENDERERS_CONFS.add(r);
    }

    public static synchronized RendererConfiguration getRendererConfigurationByName(String name) {
        for (RendererConfiguration conf : ENABLED_RENDERERS_CONFS) {
            if (!conf.getConfName().toLowerCase().contains(name.toLowerCase())) continue;
            return conf;
        }
        return null;
    }

    public static synchronized RendererConfiguration getRendererConfigurationByHeaders(SortedHeaderMap sortedHeaders) {
        if (PMS.getConfiguration().isRendererForceDefault()) {
            RendererConfiguration r = RendererConfigurations.getDefaultConf();
            LOGGER.debug("Forcing renderer match to \"" + r.getRendererName() + "\"");
            return r;
        }
        for (RendererConfiguration r : ENABLED_RENDERERS_CONFS) {
            if (!r.match(sortedHeaders)) continue;
            LOGGER.debug("Matched media renderer \"" + r.getRendererName() + "\" based on headers " + String.valueOf(sortedHeaders));
            return r;
        }
        return null;
    }

    public static synchronized RendererConfiguration getRendererConfigurationByUPNPDetails(String details) {
        for (RendererConfiguration r : ENABLED_RENDERERS_CONFS) {
            if (!r.matchUPNPDetails(details)) continue;
            LOGGER.debug("Matched media renderer \"" + r.getRendererName() + "\" based on dlna details \"" + details + "\"");
            return r;
        }
        return null;
    }

    public static File getRenderersDir() {
        String[] pathList;
        for (String path : pathList = PropertiesUtil.getProjectProperties().get("project.renderers.dir").split(",")) {
            File file;
            if (path.trim().length() <= 0 || !(file = new File(path.trim())).isDirectory()) continue;
            if (file.canRead()) {
                return file;
            }
            LOGGER.warn("Can't read directory: {}", (Object)file.getAbsolutePath());
        }
        return null;
    }

    public static File getProfileRenderersDir() {
        File file = new File(UmsConfiguration.getProfileDirectory(), "renderers");
        if (file.isDirectory()) {
            if (file.canRead()) {
                return file;
            }
            LOGGER.warn("Can't read directory: {}", (Object)file.getAbsolutePath());
        }
        return null;
    }

    public static File getRenderersIconFile(String icon) {
        File file = new File(icon);
        if (!file.isAbsolute() && file.getParent() == null) {
            file = new File(RendererConfigurations.getProfileRenderersDir(), icon);
            if (file.isFile() && file.exists()) {
                return file;
            }
            return new File(RendererConfigurations.getRenderersDir(), icon);
        }
        return file;
    }

    public static File getWritableRenderersDir() {
        String[] pathList;
        File file = new File(UmsConfiguration.getProfileDirectory(), "renderers");
        if (file.isDirectory()) {
            if (file.canWrite()) {
                return file;
            }
            LOGGER.warn("Can't write directory: {}", (Object)file.getAbsolutePath());
        }
        for (String path : pathList = PropertiesUtil.getProjectProperties().get("project.renderers.dir").split(",")) {
            if (path.trim().length() <= 0 || !(file = new File(path.trim())).isDirectory()) continue;
            if (file.canWrite()) {
                return file;
            }
            LOGGER.warn("Can't write directory: {}", (Object)file.getAbsolutePath());
        }
        return null;
    }

    public static List<String> getAllRenderersNames() {
        return new ArrayList<String>(ALL_RENDERERS_NAMES);
    }

    public static synchronized JsonArray getAllRendererNamesAsJsonArray() {
        List<String> values = RendererConfigurations.getAllRenderersNames();
        JsonArray jsonArray = new JsonArray();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", ALL_RENDERERS_KEY);
        jsonObject.addProperty("label", "i18n@AllRenderers");
        jsonArray.add(jsonObject);
        jsonObject = new JsonObject();
        jsonObject.addProperty("value", "None");
        jsonObject.addProperty("label", "i18n@None");
        jsonArray.add(jsonObject);
        for (int i = 0; i < values.size(); ++i) {
            jsonObject = new JsonObject();
            jsonObject.addProperty("value", values.get(i));
            jsonObject.addProperty("label", values.get(i));
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static synchronized JsonArray getEnabledRendererNamesAsJsonArray() {
        List<RendererConfiguration> values = RendererConfigurations.getEnabledRenderersConfigurations();
        RendererConfigurations.sortRendererConfigurationsByName(values);
        JsonArray jsonArray = new JsonArray();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("value", "");
        jsonObject.addProperty("label", "i18n@UnknownRenderer");
        jsonArray.add(jsonObject);
        for (int i = 0; i < values.size(); ++i) {
            jsonObject = new JsonObject();
            String value = values.get(i).getConfName();
            jsonObject.addProperty("value", value);
            jsonObject.addProperty("label", value);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static boolean hasDeviceConfiguration(String id) {
        return DEVICES_CONFS.containsKey(id);
    }

    public static boolean isDeviceConfigurationChanged(String id, PropertiesConfiguration deviceConf) {
        return DEVICES_CONFS.containsKey(id) && deviceConf != DEVICES_CONFS.get(id);
    }

    public static PropertiesConfiguration getDeviceConfiguration(String id) {
        return DEVICES_CONFS.get(id);
    }

    public static void removeDeviceConfiguration(String id) {
        DEVICES_CONFS.remove(id);
    }

    public static int getDeviceUpnpMode(String id) {
        if (DEVICES_CONFS.containsKey(id)) {
            return Renderer.getUpnpMode(DEVICES_CONFS.get(id).getString("UpnpAllow", "true"));
        }
        return 1;
    }

    public static void createRendererFile(Renderer renderer, File file, boolean load, File refFile) {
        try {
            List<String> lines = RendererConfiguration.getRendererLines(renderer, refFile);
            FileUtils.writeLines(file, StandardCharsets.UTF_8.name(), lines, "\r\n");
            if (load) {
                try {
                    RendererConfiguration rendererConf = new RendererConfiguration(file);
                    RendererConfigurations.addRendererConfiguration(rendererConf);
                    renderer.inherit(rendererConf);
                }
                catch (ConfigurationException ce) {
                    LOGGER.debug("Error initializing renderer configuration: " + String.valueOf(ce));
                }
            }
        }
        catch (IOException ie) {
            LOGGER.debug("Error creating renderer configuration file: " + String.valueOf(ie));
        }
    }

    public static File createDeviceFile(Renderer renderer, String filename, boolean load) {
        File file = null;
        try {
            if (StringUtils.isBlank((CharSequence)filename)) {
                filename = renderer.getDefaultFilename();
            } else if (!((String)filename).endsWith(".conf")) {
                filename = (String)filename + ".conf";
            }
            File dir2 = RendererConfigurations.getWritableRenderersDir();
            if (dir2 == null) {
                LOGGER.warn("Error creating device configuration file: Can't find a writable directory");
            }
            file = new File(dir2, (String)filename);
            List<String> lines = RendererConfiguration.getDeviceLines(renderer);
            FileUtils.writeLines(file, StandardCharsets.UTF_8.name(), lines, "\r\n");
            if (load) {
                RendererConfiguration rendererConf = new RendererConfiguration(file);
                RendererConfigurations.reloadDeviceFile(file, rendererConf);
                FileWatcher.add(new FileWatcher.Watch(file.getPath(), RELOADER));
            }
        }
        catch (IOException | ConfigurationException ie) {
            LOGGER.debug("Error creating device configuration file: " + String.valueOf(ie));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadRendererConfigurations() {
        RendererConfiguration fallbackConf;
        String rendererFallback;
        Iterator iterator = LOAD_RENDERER_CONFIGURATIONS_LOCK;
        synchronized (iterator) {
            ALL_RENDERERS_NAMES.clear();
            ENABLED_RENDERERS_CONFS.clear();
            try {
                defaultConf = new RendererConfiguration(null);
                defaultRenderer = new Renderer(defaultConf);
            }
            catch (ConfigurationException e) {
                LOGGER.debug("Caught exception", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            RendererConfigurations.loadConfigurations(RendererConfigurations.getProfileRenderersDir(), true);
            RendererConfigurations.loadConfigurations(RendererConfigurations.getRenderersDir(), false);
        }
        LOGGER.info("Enabled " + ENABLED_RENDERERS_CONFS.size() + " configurations, listed in order of loading priority:");
        for (RendererConfiguration rendererConf : ENABLED_RENDERERS_CONFS) {
            LOGGER.info(":   " + String.valueOf(rendererConf));
        }
        if (!ENABLED_RENDERERS_CONFS.isEmpty() && StringUtils.isNotBlank(rendererFallback = PMS.getConfiguration().getRendererDefault()) && (fallbackConf = RendererConfigurations.getRendererConfigurationByName(rendererFallback)) != null) {
            defaultConf = fallbackConf;
            try {
                defaultRenderer.inherit(defaultConf);
            }
            catch (ConfigurationException e) {
                LOGGER.debug("Caught exception", e);
            }
        }
        Collections.sort(ALL_RENDERERS_NAMES, String.CASE_INSENSITIVE_ORDER);
    }

    private static void loadConfigurations(File renderersDir, boolean profile) {
        if (renderersDir != null) {
            LOGGER.info("Loading renderer and device configurations from " + renderersDir.getAbsolutePath());
            Object[] files = renderersDir.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                if (!((File)file).getName().endsWith(".conf")) continue;
                try {
                    RendererConfiguration rendererConf = new RendererConfiguration((File)file);
                    if (rendererConf.hasDeviceId()) {
                        RendererConfigurations.loadDeviceConfiguration(rendererConf);
                    } else {
                        RendererConfigurations.loadRendererConfiguration(rendererConf, profile);
                    }
                    FileWatcher.add(new FileWatcher.Watch(((File)file).getPath(), RELOADER));
                }
                catch (ConfigurationException ce) {
                    LOGGER.info("Error in loading configuration of: " + ((File)file).getAbsolutePath());
                }
            }
        }
    }

    private static void loadRendererConfiguration(RendererConfiguration rendererConf, boolean profile) {
        List<String> selectedRenderers = PMS.getConfiguration().getSelectedRenderers();
        Object rendererName = rendererConf.getConfName();
        if (profile) {
            rendererName = (String)rendererName + "*";
        }
        if (!ALL_RENDERERS_NAMES.contains(rendererName)) {
            ALL_RENDERERS_NAMES.add((String)rendererName);
        }
        String renderersGroup = null;
        if (((String)rendererName).indexOf(32) > 0) {
            renderersGroup = ((String)rendererName).substring(0, ((String)rendererName).indexOf(32));
        }
        if (selectedRenderers.contains(rendererName) || selectedRenderers.contains(renderersGroup) || selectedRenderers.contains(ALL_RENDERERS_KEY)) {
            ENABLED_RENDERERS_CONFS.add(rendererConf);
        } else {
            LOGGER.debug("Ignored \"{}\" configuration", rendererName);
        }
    }

    private static List<String> loadDeviceConfiguration(RendererConfiguration rendererConf) {
        String[] ids;
        ArrayList<String> idsList = new ArrayList<String>();
        String deviceId = rendererConf.getDeviceId();
        for (String id : ids = deviceId.split("\\s*,\\s*")) {
            if (!StringUtils.isNotBlank(id)) continue;
            if (!idsList.contains(deviceId)) {
                idsList.add(id);
            }
            DEVICES_CONFS.put(id, (PropertiesConfiguration)rendererConf.getConfiguration());
            LOGGER.info("Loaded device configuration {} for {}", (Object)rendererConf.getFile().getName(), (Object)id);
        }
        return idsList;
    }

    private static void reloadConfigurationFile(String filename) {
        File file = new File(filename);
        try {
            RendererConfiguration rendererConf = new RendererConfiguration(file);
            if (rendererConf.hasDeviceId()) {
                RendererConfigurations.reloadDeviceFile(file, rendererConf);
            }
        }
        catch (ConfigurationException ce) {
            LOGGER.info("Error in reloading configuration of: " + file.getAbsolutePath());
        }
    }

    private static void reloadDeviceFile(File file, RendererConfiguration rendererConf) {
        ArrayList<String> idsList = new ArrayList<String>();
        Iterator<String> iterator = DEVICES_CONFS.keySet().iterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            PropertiesConfiguration deviceConfiguration = DEVICES_CONFS.get(id);
            if (!deviceConfiguration.getFile().equals(file)) continue;
            idsList.add(id);
            iterator.remove();
        }
        idsList.addAll(RendererConfigurations.loadDeviceConfiguration(rendererConf));
        if (!idsList.isEmpty()) {
            for (Renderer renderer : ConnectedRenderers.getConnectedRenderers()) {
                if (!idsList.contains(renderer.getId())) continue;
                renderer.reset();
            }
        }
    }

    public static void sortRendererConfigurationsByName(List<RendererConfiguration> rendererConfigurations) {
        Collections.sort(rendererConfigurations, (o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getRendererName().toLowerCase().compareTo(o2.getRendererName().toLowerCase());
        });
    }

    static {
        RELOADER = (filename, event, watch, isDir) -> RendererConfigurations.reloadConfigurationFile(filename);
    }
}

