/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import de.sfuhrm.radiobrowser4j.Paging;
import java.util.List;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PagingSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagingSpliterator.class);
    private static final int FETCH_SIZE_DEFAULT = 128;
    private Paging logicalPage = Paging.at(0, 128);
    private List<T> currentData;
    private int currentDataIndex = 0;
    private final Function<Paging, List<T>> fetchPage;
    private Paging view;
    private boolean endOfList;

    PagingSpliterator(Function<Paging, List<T>> fetchPageFunction, Paging view) {
        super(Long.MAX_VALUE, 0);
        this.fetchPage = fetchPageFunction;
        this.currentData = null;
        this.view = view;
        this.endOfList = false;
    }

    private void loadPage() {
        Paging physicalPage = null;
        if (this.view != null) {
            boolean lastPage = this.logicalPage.getOffset() + 128 >= this.view.getLimit();
            int fetchLimit = 128;
            if (lastPage && (fetchLimit = Math.min(128, this.view.getLimit() - this.logicalPage.getOffset())) <= 0) {
                fetchLimit = 0;
                this.endOfList = true;
            }
            if (fetchLimit > 0) {
                physicalPage = Paging.at(this.view.getOffset() + this.logicalPage.getOffset(), fetchLimit);
            }
        } else {
            physicalPage = this.logicalPage;
        }
        log.debug("Loading logical page {}, physical page {}, view {}", this.logicalPage, physicalPage, this.view);
        if (physicalPage != null) {
            this.currentData = this.fetchPage.apply(physicalPage);
            log.debug("Elements in loaded page: {}", (Object)this.currentData.size());
            this.currentDataIndex = 0;
            if (this.currentData.isEmpty()) {
                this.endOfList = true;
            }
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean hasMore;
        boolean bl = hasMore = !this.endOfList;
        if (this.currentData == null && !this.endOfList) {
            this.loadPage();
        }
        if (this.currentData != null && !this.endOfList && this.currentDataIndex >= this.currentData.size()) {
            this.logicalPage = this.logicalPage.next();
            this.loadPage();
        }
        if (this.currentData != null && this.currentDataIndex < this.currentData.size()) {
            T element = this.currentData.get(this.currentDataIndex);
            action.accept(element);
            ++this.currentDataIndex;
            hasMore = true;
        }
        return hasMore;
    }
}

