/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.watchproviders;

import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.schema.watchproviders.WatchProviderRegionsResponseSchema;
import com.universalmediaserver.tmdbapi.schema.watchproviders.WatchProviderResponseSchema;
import java.util.HashMap;

public class WatchProvidersEndpoint
extends Endpoint {
    private static final String V3_WATCH_PROVIDERS_ENDPOINT = "/3/watch/providers/";
    private static final String REGIONS_ENDPOINT = "/3/watch/providers/regions";
    private static final String MOVIE_ENDPOINT = "/3/watch/providers/movie";
    private static final String TV_ENDPOINT = "/3/watch/providers/tv";
    private String language;
    private String watchRegion;

    public WatchProvidersEndpoint(TMDbClient tmdbClient) {
        super(tmdbClient);
    }

    public WatchProvidersEndpoint setLanguage(String value) {
        this.language = value;
        return this;
    }

    public WatchProvidersEndpoint setWatchRegion(String value) {
        this.watchRegion = value.toUpperCase();
        return this;
    }

    public WatchProviderRegionsResponseSchema getRegions() {
        HashMap<String, String> query = new HashMap<String, String>();
        WatchProvidersEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        return this.tmdbClient.get(REGIONS_ENDPOINT, WatchProviderRegionsResponseSchema.class, query);
    }

    public WatchProviderResponseSchema forMovies() {
        HashMap<String, String> query = new HashMap<String, String>();
        WatchProvidersEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        WatchProvidersEndpoint.addQueryString(query, "watch_region", this.watchRegion);
        return this.tmdbClient.get(MOVIE_ENDPOINT, WatchProviderResponseSchema.class, query);
    }

    public WatchProviderResponseSchema forTv() {
        HashMap<String, String> query = new HashMap<String, String>();
        WatchProvidersEndpoint.addQueryString(query, "language", this.language, this.tmdbClient.getDefaultLanguage());
        WatchProvidersEndpoint.addQueryString(query, "watch_region", this.watchRegion);
        return this.tmdbClient.get(TV_ENDPOINT, WatchProviderResponseSchema.class, query);
    }
}

