/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.tmdbapi.endpoint.list;

import com.google.gson.JsonObject;
import com.universalmediaserver.tmdbapi.TMDbClient;
import com.universalmediaserver.tmdbapi.endpoint.Endpoint;
import com.universalmediaserver.tmdbapi.endpoint.list.ListSortBy;
import com.universalmediaserver.tmdbapi.schema.list.ListStatusSchema;
import java.util.HashMap;

public class ListV3Endpoint
extends Endpoint {
    private static final String V3_LIST_ENDPOINT = "/3/list";
    private final String name;
    private final String iso639Part1;
    private String description;
    private String iso3166Part1;
    private Boolean isPublic;
    private String sortBy;

    public ListV3Endpoint(TMDbClient tmdbClient, String name, String iso639Part1) {
        super(tmdbClient);
        this.iso639Part1 = iso639Part1;
        this.name = name;
    }

    public ListV3Endpoint setDescription(String value) {
        this.description = value;
        return this;
    }

    public ListV3Endpoint setIso3166Part1(String value) {
        this.iso3166Part1 = value;
        return this;
    }

    public ListV3Endpoint setPublic(Boolean value) {
        this.isPublic = value;
        return this;
    }

    public ListV3Endpoint setSortBy(ListSortBy value) {
        this.sortBy = value != null ? value.toString() : null;
        return this;
    }

    public ListStatusSchema create() {
        HashMap<String, String> query = new HashMap<String, String>();
        ListV3Endpoint.addQueryString(query, "session_id", this.tmdbClient.getSessionId());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", this.name);
        jsonObject.addProperty("iso_639_1", this.iso639Part1);
        ListV3Endpoint.addPostString(jsonObject, "description", this.description);
        ListV3Endpoint.addPostString(jsonObject, "iso_3166_1", this.iso3166Part1);
        ListV3Endpoint.addPostBoolean(jsonObject, "public", this.isPublic, true);
        ListV3Endpoint.addPostString(jsonObject, "sort_by", this.sortBy);
        return this.tmdbClient.post(V3_LIST_ENDPOINT, ListStatusSchema.class, query, jsonObject.toString());
    }
}

