/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.tga;

import java.util.Locale;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class TGAImageWriteParam
extends ImageWriteParam {
    public TGAImageWriteParam() {
        this(null);
    }

    public TGAImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteCompressed = true;
        this.compressionTypes = new String[]{"None", "RLE"};
    }

    static boolean isRLE(ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata) {
        return (imageWriteParam == null || imageWriteParam.canWriteCompressed() && imageWriteParam.getCompressionMode() == 3) && "RLE".equals(TGAImageWriteParam.compressionTypeFromMetadata(iIOMetadata)) || imageWriteParam != null && imageWriteParam.canWriteCompressed() && imageWriteParam.getCompressionMode() == 2 && "RLE".equals(imageWriteParam.getCompressionType());
    }

    private static String compressionTypeFromMetadata(IIOMetadata iIOMetadata) {
        IIOMetadataNode iIOMetadataNode;
        NodeList nodeList;
        if (iIOMetadata != null && (nodeList = (iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0")).getElementsByTagName("CompressionTypeName")).getLength() > 0) {
            Node node = nodeList.item(0).getAttributes().getNamedItem("value");
            return node != null ? node.getNodeValue() : null;
        }
        return null;
    }
}

