/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.sgi;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

final class SGIHeader {
    private int compression;
    private int bytesPerPixel;
    private int dimensions;
    private int width;
    private int height;
    private int channels;
    private int minValue;
    private int maxValue;
    private String name;
    private int colorMode;

    SGIHeader() {
    }

    public int getCompression() {
        return this.compression;
    }

    public int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public String getName() {
        return this.name;
    }

    public int getColorMode() {
        return this.colorMode;
    }

    public String toString() {
        return "SGIHeader{compression=" + this.compression + ", bytesPerPixel=" + this.bytesPerPixel + ", dimensions=" + this.dimensions + ", width=" + this.width + ", height=" + this.height + ", channels=" + this.channels + ", minValue=" + this.minValue + ", maxValue=" + this.maxValue + ", name='" + this.name + '\'' + ", colorMode=" + this.colorMode + '}';
    }

    public static SGIHeader read(ImageInputStream imageInputStream) throws IOException {
        short s = imageInputStream.readShort();
        if (s != 474) {
            throw new IIOException(String.format("Not an SGI image. Expected SGI magic %04x, read %04x", (short)474, s));
        }
        SGIHeader sGIHeader = new SGIHeader();
        sGIHeader.compression = imageInputStream.readUnsignedByte();
        sGIHeader.bytesPerPixel = imageInputStream.readUnsignedByte();
        sGIHeader.dimensions = imageInputStream.readUnsignedShort();
        sGIHeader.width = imageInputStream.readUnsignedShort();
        sGIHeader.height = imageInputStream.readUnsignedShort();
        sGIHeader.channels = imageInputStream.readUnsignedShort();
        sGIHeader.minValue = imageInputStream.readInt();
        sGIHeader.maxValue = imageInputStream.readInt();
        imageInputStream.readInt();
        byte[] byArray = new byte[80];
        imageInputStream.readFully(byArray);
        sGIHeader.name = SGIHeader.toAsciiString(byArray);
        sGIHeader.colorMode = imageInputStream.readInt();
        imageInputStream.skipBytes(404);
        return sGIHeader;
    }

    private static String toAsciiString(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
            break;
        }
        return new String(byArray, 0, n, StandardCharsets.US_ASCII);
    }
}

