/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pcx;

import com.twelvemonkeys.io.enc.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

final class RLEDecoder
implements Decoder {
    static final int COMPRESSED_RUN_MASK = 192;

    RLEDecoder() {
    }

    @Override
    public int decode(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        int n;
        while (byteBuffer.remaining() >= 64 && (n = inputStream.read()) >= 0) {
            if ((n & 0xC0) == 192) {
                int n2 = n & 0xFFFFFF3F;
                int n3 = inputStream.read();
                if (n3 < 0) break;
                for (int i = 0; i < n2; ++i) {
                    byteBuffer.put((byte)n3);
                }
                continue;
            }
            byteBuffer.put((byte)n);
        }
        return byteBuffer.position();
    }
}

