/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.ImageWriterBase;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImage10Metadata;
import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageWriterSpi;
import com.twelvemonkeys.imageio.util.ImageTypeSpecifiers;
import com.twelvemonkeys.imageio.util.ProgressListenerBase;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JPEGImageWriter
extends ImageWriterBase {
    private final ImageWriter delegate;
    private final ProgressDelegator progressDelegator;

    public JPEGImageWriter(JPEGImageWriterSpi jPEGImageWriterSpi, ImageWriter imageWriter) {
        super(jPEGImageWriterSpi);
        this.delegate = imageWriter;
        this.progressDelegator = new ProgressDelegator();
    }

    private void installListeners() {
        this.delegate.addIIOWriteProgressListener(this.progressDelegator);
        this.delegate.addIIOWriteWarningListener(this.progressDelegator);
    }

    @Override
    protected void resetMembers() {
        this.delegate.reset();
        this.installListeners();
    }

    @Override
    public void setOutput(Object object) {
        super.setOutput(object);
        this.delegate.setOutput(object);
    }

    @Override
    public Object getOutput() {
        return this.delegate.getOutput();
    }

    @Override
    public Locale[] getAvailableLocales() {
        return this.delegate.getAvailableLocales();
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    @Override
    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return this.delegate.getDefaultWriteParam();
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultStreamMetadata(imageWriteParam);
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return this.delegate.convertStreamMetadata(iIOMetadata, imageWriteParam);
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return this.delegate.convertImageMetadata(iIOMetadata, imageTypeSpecifier, imageWriteParam);
    }

    @Override
    public int getNumThumbnailsSupported(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getNumThumbnailsSupported(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    @Override
    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, IIOMetadata iIOMetadata, IIOMetadata iIOMetadata2) {
        return this.delegate.getPreferredThumbnailSizes(imageTypeSpecifier, imageWriteParam, iIOMetadata, iIOMetadata2);
    }

    @Override
    public boolean canWriteRasters() {
        return this.delegate.canWriteRasters();
    }

    @Override
    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        if (this.isDestinationCMYK(iIOImage, imageWriteParam)) {
            this.writeCMYK(iIOMetadata, iIOImage, imageWriteParam);
        } else {
            if (iIOImage.getMetadata() instanceof JPEGImage10Metadata) {
                ImageTypeSpecifier imageTypeSpecifier = iIOImage.hasRaster() ? null : ImageTypeSpecifiers.createFromRenderedImage(iIOImage.getRenderedImage());
                IIOMetadata iIOMetadata2 = this.delegate.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
                JPEGImage10Metadata jPEGImage10Metadata = (JPEGImage10Metadata)iIOImage.getMetadata();
                iIOMetadata2.setFromTree(jPEGImage10Metadata.getNativeMetadataFormatName(), jPEGImage10Metadata.getNativeTree());
                iIOImage.setMetadata(iIOMetadata2);
            }
            this.delegate.write(iIOMetadata, iIOImage, imageWriteParam);
        }
    }

    private boolean isDestinationCMYK(IIOImage iIOImage, ImageWriteParam imageWriteParam) {
        return !iIOImage.hasRaster() && iIOImage.getRenderedImage().getColorModel().getColorSpace().getType() == 9 || imageWriteParam != null && imageWriteParam.getDestinationType() != null && imageWriteParam.getDestinationType().getColorModel().getColorSpace().getType() == 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCMYK(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        RenderedImage renderedImage = iIOImage.getRenderedImage();
        boolean bl = imageWriteParam != null && imageWriteParam.getDestinationType() != null;
        ImageTypeSpecifier imageTypeSpecifier = bl ? imageWriteParam.getDestinationType() : ImageTypeSpecifiers.createFromRenderedImage(renderedImage);
        IIOMetadata iIOMetadata2 = this.convertCMYKMetadata(iIOImage.getMetadata(), imageTypeSpecifier, imageWriteParam);
        InvertedRaster invertedRaster = new InvertedRaster(JPEGImageWriter.getRaster(renderedImage));
        if (bl) {
            imageWriteParam.setDestinationType(null);
        }
        try {
            this.delegate.write(iIOMetadata, new IIOImage(invertedRaster, null, iIOMetadata2), imageWriteParam);
        }
        finally {
            if (bl) {
                imageWriteParam.setDestinationType(imageTypeSpecifier);
            }
        }
    }

    private IIOMetadata convertCMYKMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) throws IIOInvalidTreeException {
        Object object;
        Object object2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_jpeg_image_1.0");
        iIOMetadataNode.appendChild(new IIOMetadataNode("JPEGVariety"));
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("markerSequence");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = iIOMetadata != null ? (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_jpeg_image_1.0") : new IIOMetadataNode("emptyNode");
        NodeList nodeList = iIOMetadataNode3.getElementsByTagName("unknown");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object2 = (IIOMetadataNode)nodeList.item(i);
            if ("226".equals(((IIOMetadataNode)object2).getAttribute("MarkerTag")) && (object = ((IIOMetadataNode)object2).getUserObject()) instanceof byte[] && ((byte[])object).length >= "ICC_PROFILE".length() && "ICC_PROFILE".equals(new String((byte[])object, 0, "ICC_PROFILE".length()))) continue;
            iIOMetadataNode2.appendChild((Node)object2);
        }
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("app14Adobe");
        iIOMetadataNode4.setAttribute("transform", "0");
        iIOMetadataNode2.appendChild(iIOMetadataNode4);
        object2 = imageTypeSpecifier.getColorModel().getColorSpace();
        if (object2 instanceof ICC_ColorSpace) {
            object = ((ICC_ColorSpace)object2).getProfile();
            byte[] byArray = ((ICC_Profile)object).getData();
            String string = "ICC_PROFILE";
            int n = string.length();
            byte[] byArray2 = string.getBytes(StandardCharsets.US_ASCII);
            int n2 = 65535 - n - 3 - 2;
            int n3 = (int)Math.ceil((float)byArray.length / (float)n2);
            for (int i = 0; i < n3; ++i) {
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("unknown");
                iIOMetadataNode5.setAttribute("MarkerTag", String.valueOf(226));
                int n4 = Math.min(n2, byArray.length - i * n2);
                byte[] byArray3 = new byte[n + 3 + n4];
                System.arraycopy(byArray2, 0, byArray3, 0, n);
                byArray3[n] = 0;
                byArray3[n + 1] = (byte)(1 + i);
                byArray3[n + 2] = (byte)n3;
                System.arraycopy(byArray, i * n2, byArray3, n + 3, n4);
                iIOMetadataNode5.setUserObject(byArray3);
                iIOMetadataNode2.appendChild(iIOMetadataNode5);
            }
        }
        object = iIOMetadataNode3.getElementsByTagName("COM");
        for (int i = 0; i < object.getLength(); ++i) {
            iIOMetadataNode2.appendChild(object.item(i));
        }
        IIOMetadata iIOMetadata2 = this.delegate.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        iIOMetadata2.mergeTree("javax_imageio_jpeg_image_1.0", iIOMetadataNode);
        return iIOMetadata2;
    }

    private static Raster getRaster(RenderedImage renderedImage) {
        return renderedImage instanceof BufferedImage ? ((BufferedImage)renderedImage).getRaster() : (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1 ? renderedImage.getTile(0, 0) : renderedImage.getData());
    }

    @Override
    public boolean canWriteSequence() {
        return this.delegate.canWriteSequence();
    }

    @Override
    public void prepareWriteSequence(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.prepareWriteSequence(iIOMetadata);
    }

    @Override
    public void writeToSequence(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeToSequence(iIOImage, imageWriteParam);
    }

    @Override
    public void endWriteSequence() throws IOException {
        this.delegate.endWriteSequence();
    }

    @Override
    public boolean canReplaceStreamMetadata() throws IOException {
        return this.delegate.canReplaceStreamMetadata();
    }

    @Override
    public void replaceStreamMetadata(IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceStreamMetadata(iIOMetadata);
    }

    @Override
    public boolean canReplaceImageMetadata(int n) throws IOException {
        return this.delegate.canReplaceImageMetadata(n);
    }

    @Override
    public void replaceImageMetadata(int n, IIOMetadata iIOMetadata) throws IOException {
        this.delegate.replaceImageMetadata(n, iIOMetadata);
    }

    @Override
    public boolean canInsertImage(int n) throws IOException {
        return this.delegate.canInsertImage(n);
    }

    @Override
    public void writeInsert(int n, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.writeInsert(n, iIOImage, imageWriteParam);
    }

    @Override
    public boolean canRemoveImage(int n) throws IOException {
        return this.delegate.canRemoveImage(n);
    }

    @Override
    public void removeImage(int n) throws IOException {
        this.delegate.removeImage(n);
    }

    @Override
    public boolean canWriteEmpty() throws IOException {
        return this.delegate.canWriteEmpty();
    }

    @Override
    public void prepareWriteEmpty(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, int n, int n2, IIOMetadata iIOMetadata2, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareWriteEmpty(iIOMetadata, imageTypeSpecifier, n, n2, iIOMetadata2, list, imageWriteParam);
    }

    @Override
    public void endWriteEmpty() throws IOException {
        this.delegate.endWriteEmpty();
    }

    @Override
    public boolean canInsertEmpty(int n) throws IOException {
        return this.delegate.canInsertEmpty(n);
    }

    @Override
    public void prepareInsertEmpty(int n, ImageTypeSpecifier imageTypeSpecifier, int n2, int n3, IIOMetadata iIOMetadata, List<? extends BufferedImage> list, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.prepareInsertEmpty(n, imageTypeSpecifier, n2, n3, iIOMetadata, list, imageWriteParam);
    }

    @Override
    public void endInsertEmpty() throws IOException {
        this.delegate.endInsertEmpty();
    }

    @Override
    public boolean canReplacePixels(int n) throws IOException {
        return this.delegate.canReplacePixels(n);
    }

    @Override
    public void prepareReplacePixels(int n, Rectangle rectangle) throws IOException {
        this.delegate.prepareReplacePixels(n, rectangle);
    }

    @Override
    public void replacePixels(RenderedImage renderedImage, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(renderedImage, imageWriteParam);
    }

    @Override
    public void replacePixels(Raster raster, ImageWriteParam imageWriteParam) throws IOException {
        this.delegate.replacePixels(raster, imageWriteParam);
    }

    @Override
    public void endReplacePixels() throws IOException {
        this.delegate.endReplacePixels();
    }

    @Override
    public void abort() {
        super.abort();
        this.delegate.abort();
    }

    @Override
    public void reset() {
        super.reset();
        this.delegate.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.delegate.dispose();
    }

    private class ProgressDelegator
    extends ProgressListenerBase
    implements IIOWriteWarningListener {
        private ProgressDelegator() {
        }

        @Override
        public void imageComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processImageComplete();
        }

        @Override
        public void imageProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processImageProgress(f);
        }

        @Override
        public void imageStarted(ImageWriter imageWriter, int n) {
            JPEGImageWriter.this.processImageStarted(n);
        }

        @Override
        public void thumbnailComplete(ImageWriter imageWriter) {
            JPEGImageWriter.this.processThumbnailComplete();
        }

        @Override
        public void thumbnailProgress(ImageWriter imageWriter, float f) {
            JPEGImageWriter.this.processThumbnailProgress(f);
        }

        @Override
        public void thumbnailStarted(ImageWriter imageWriter, int n, int n2) {
            JPEGImageWriter.this.processThumbnailStarted(n, n2);
        }

        @Override
        public void writeAborted(ImageWriter imageWriter) {
            JPEGImageWriter.this.processWriteAborted();
        }

        @Override
        public void warningOccurred(ImageWriter imageWriter, int n, String string) {
            JPEGImageWriter.this.processWarningOccurred(n, string);
        }
    }

    private static class InvertedRaster
    extends WritableRaster {
        InvertedRaster(final Raster raster) {
            super(raster.getSampleModel(), new DataBuffer(raster.getDataBuffer().getDataType(), raster.getDataBuffer().getSize()){
                private final DataBuffer delegate;
                {
                    super(n, n2);
                    this.delegate = raster.getDataBuffer();
                }

                @Override
                public int getElem(int n, int n2) {
                    return 255 - this.delegate.getElem(n, n2);
                }

                @Override
                public void setElem(int n, int n2, int n3) {
                    throw new UnsupportedOperationException("setElem");
                }
            }, new Point());
        }
    }
}

